/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.FixDefaultListCellRenderer;

public class GroupSelectorDialog
extends CommonDialog {
    private JList fieldList;
    private String selectedGroup;

    public GroupSelectorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public GroupSelectorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public GroupSelectorDialog() throws HeadlessException {
        this.init();
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.fieldList = new JList();
        this.fieldList.setCellRenderer(new FixDefaultListCellRenderer());
        this.fieldList.setVisibleRowCount(5);
        this.fieldList.setSelectionMode(0);
        this.fieldList.addMouseListener(new MouseHandler());
        this.fieldList.addListSelectionListener(new SelectionUpdateHandler());
        this.setTitle(UtilMessages.getInstance().getString("GroupSelectorDialog.Title"));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.GroupSelector";
    }

    protected Component createContentPane() {
        return new JScrollPane(this.fieldList);
    }

    public void setGroups(String[] queries) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (int i = 0; i < queries.length; ++i) {
            listModel.addElement(queries[i]);
        }
        this.fieldList.setModel(listModel);
    }

    public String getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(String selectedQuery) {
        String oldQuery = this.selectedGroup;
        this.selectedGroup = selectedQuery;
        this.firePropertyChange("selectedGroup", oldQuery, selectedQuery);
        this.getConfirmAction().setEnabled(this.validateInputs(false));
    }

    public String performEdit(String[] queries, String selectedGroup) {
        this.setGroups(queries);
        this.setSelectedGroup(selectedGroup);
        if (super.performEdit()) {
            return this.getSelectedGroup();
        }
        return selectedGroup;
    }

    protected boolean validateInputs(boolean onConfirm) {
        String selectedValue = (String)this.fieldList.getSelectedValue();
        return !StringUtils.isEmpty((String)selectedValue);
    }

    private class SelectionUpdateHandler
    implements ListSelectionListener {
        private SelectionUpdateHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GroupSelectorDialog.this.setSelectedGroup((String)GroupSelectorDialog.this.fieldList.getSelectedValue());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getButton() == 1) {
                String selectedValue = (String)GroupSelectorDialog.this.fieldList.getSelectedValue();
                GroupSelectorDialog.this.setSelectedGroup(selectedValue);
                if (selectedValue != null) {
                    GroupSelectorDialog.this.setConfirmed(true);
                    GroupSelectorDialog.this.dispose();
                }
            }
        }
    }
}

