/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class HyperLink
extends JLabel {
    public HyperLink(String linkName) {
        super(String.format("<html><u>%s</u></html>", linkName));
        this.addMouseListener(new HyperlinkMouseHandler());
        this.setForeground(Color.blue);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public HyperLink(String lbl, ImageIcon icon) {
        this(lbl);
        this.setIcon(icon);
    }

    private class HyperlinkMouseHandler
    extends MouseAdapter {
        private HyperlinkMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            HyperLink.this.setForeground(Color.black);
            HyperLink.this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            HyperLink.this.setForeground(Color.blue);
            HyperLink.this.setCursor(new Cursor(0));
        }
    }
}

