/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.dnd;

import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.FocusManager;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.RootBandRenderComponent;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportFunctionNode;
import org.pentaho.reporting.designer.core.editor.structuretree.ReportParametersNode;
import org.pentaho.reporting.designer.core.editor.structuretree.SubReportParametersNode;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.dnd.ClipboardManager;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.DataSourceEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ExpressionRemoveUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ParameterEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.SectionEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.BandType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionCollection;
import org.pentaho.reporting.engine.classic.core.parameters.ModifiableReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class InsertationUtil {
    public static final String SUBREPORT_BANDED_HINT = "subreport-banded-hint";
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private InsertationUtil() {
    }

    public static Object[] getFromClipboard() {
        try {
            Object[] data = ClipboardManager.getManager().getContents();
            if (data == null) {
                return EMPTY_ARRAY;
            }
            return data;
        }
        catch (UnsupportedFlavorException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
            return EMPTY_ARRAY;
        }
        catch (IOException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
            return EMPTY_ARRAY;
        }
    }

    public static boolean isInsertAllowed(Object target, Object data) {
        if (target instanceof SubReport || target instanceof MasterReport) {
            return data instanceof Group || data instanceof ReportHeader || data instanceof ReportFooter || data instanceof PageHeader || data instanceof PageFooter;
        }
        if (target instanceof Group) {
            return data instanceof Group || data instanceof GroupBody || data instanceof GroupHeader || data instanceof GroupFooter;
        }
        if (target instanceof SubGroupBody) {
            return data instanceof Group;
        }
        if (target instanceof GroupDataBody) {
            return data instanceof DetailsHeader || data instanceof DetailsFooter || data instanceof NoDataBand || data instanceof ItemBand;
        }
        if (target instanceof Band) {
            if (data instanceof AbstractReportDefinition) {
                for (Band b = (Band)target; b != null; b = b.getParent()) {
                    if (!(b instanceof PageHeader) && !(b instanceof PageFooter) && !(b instanceof DetailsHeader) && !(b instanceof DetailsFooter) && !(b instanceof Watermark)) continue;
                    return false;
                }
            } else if (data instanceof Group || data instanceof GroupBody) {
                return false;
            }
            return data instanceof Element;
        }
        return data instanceof Expression || data instanceof ParameterDefinitionEntry || data instanceof DataFactory;
    }

    public static Object getInsertationPoint(ReportDocumentContext renderContext) {
        Component owner = FocusManager.getCurrentManager().getPermanentFocusOwner();
        if (!(owner instanceof RootBandRenderComponent)) {
            ReportElement element;
            Section parentSection;
            Object o = renderContext.getSelectionModel().getLeadSelection();
            if (o == null) {
                return null;
            }
            if (o instanceof Band) {
                return o;
            }
            if (o instanceof ReportElement && (parentSection = (element = (ReportElement)o).getParentSection()) instanceof Band) {
                return parentSection;
            }
            if (o instanceof CompoundDataFactory) {
                return o;
            }
            if (o instanceof ReportFunctionNode) {
                return o;
            }
            if (o instanceof ReportParametersNode) {
                return o;
            }
            if (o instanceof SubReportParametersNode) {
                return o;
            }
            return null;
        }
        RootBandRenderComponent rootBandRenderComponent = (RootBandRenderComponent)owner;
        Band rootBand = rootBandRenderComponent.getRootBand();
        DocumentContextSelectionModel selectionModel = renderContext.getSelectionModel();
        for (Element element : selectionModel.getSelectedElementsOfType(Element.class)) {
            if (!(element instanceof Band) || !ModelUtility.isDescendant((Section)rootBand, (ReportElement)element)) continue;
            return element;
        }
        return rootBand;
    }

    public static Object insert(Object rawLeadSelection, AbstractReportDefinition report, Object fromClipboard) {
        if (fromClipboard instanceof Expression) {
            return InsertationUtil.insertExpression(report, (Expression)fromClipboard);
        }
        if (fromClipboard instanceof ParameterDefinitionEntry) {
            return InsertationUtil.insertParameter(report, (ParameterDefinitionEntry)fromClipboard);
        }
        if (fromClipboard instanceof DataFactory) {
            return InsertationUtil.insertDataFactory(report, (DataFactory)fromClipboard);
        }
        if (!(fromClipboard instanceof Element)) {
            return false;
        }
        Element insert = (Element)fromClipboard;
        if (!(rawLeadSelection instanceof Element)) {
            return false;
        }
        if (rawLeadSelection instanceof Band) {
            Band target = (Band)rawLeadSelection;
            if (target == insert) {
                return false;
            }
            if (ModelUtility.isDescendant((Section)target, (ReportElement)insert)) {
                return false;
            }
            if (insert.getParent() != null) {
                throw new IllegalStateException();
            }
            try {
                Object subreportHint;
                Element element = InsertationUtil.normalizeForInsert(insert);
                if (element == null) {
                    return false;
                }
                if (element instanceof SubReport && Boolean.TRUE.equals(subreportHint = insert.getAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", SUBREPORT_BANDED_HINT))) {
                    if (target instanceof AbstractRootLevelBand) {
                        AbstractRootLevelBand rlb = (AbstractRootLevelBand)target;
                        rlb.addSubReport((SubReport)element);
                        return element;
                    }
                    return false;
                }
                target.addElement(element);
                return element;
            }
            catch (CloneNotSupportedException e1) {
                UncaughtExceptionsModel.getInstance().addException(e1);
                return false;
            }
        }
        if (rawLeadSelection instanceof AbstractReportDefinition) {
            AbstractReportDefinition g = (AbstractReportDefinition)rawLeadSelection;
            if (insert instanceof PageHeader) {
                PageHeader header = (PageHeader)insert.derive();
                g.setPageHeader(header);
                return header;
            }
            if (insert instanceof PageFooter) {
                PageFooter footer = (PageFooter)insert.derive();
                g.setPageFooter(footer);
                return footer;
            }
            if (insert instanceof ReportHeader) {
                ReportHeader header = (ReportHeader)insert.derive();
                g.setReportHeader(header);
                return header;
            }
            if (insert instanceof ReportFooter) {
                ReportFooter footer = (ReportFooter)insert.derive();
                g.setReportFooter(footer);
                return footer;
            }
            if (insert instanceof Group) {
                Group group = (Group)insert.derive();
                g.setRootGroup(group);
                return group;
            }
            return null;
        }
        if (rawLeadSelection instanceof RelationalGroup) {
            RelationalGroup g = (RelationalGroup)rawLeadSelection;
            if (insert instanceof GroupHeader) {
                GroupHeader header = (GroupHeader)insert.derive();
                g.setHeader(header);
                return header;
            }
            if (insert instanceof GroupFooter) {
                GroupFooter footer = (GroupFooter)insert.derive();
                g.setFooter(footer);
                return footer;
            }
            if (insert instanceof GroupBody) {
                GroupBody body = (GroupBody)insert.derive();
                try {
                    g.setBody(body);
                    return body;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }
        if (rawLeadSelection instanceof SubGroupBody) {
            SubGroupBody body = (SubGroupBody)rawLeadSelection;
            if (insert instanceof RelationalGroup || insert instanceof CrosstabGroup) {
                try {
                    Group group = (Group)insert.derive();
                    body.setGroup(group);
                    return group;
                }
                catch (Exception cne) {
                    UncaughtExceptionsModel.getInstance().addException(cne);
                    return null;
                }
            }
            return null;
        }
        if (rawLeadSelection instanceof GroupDataBody) {
            GroupDataBody body = (GroupDataBody)rawLeadSelection;
            if (insert instanceof DetailsHeader) {
                DetailsHeader detailsHeader = (DetailsHeader)insert.derive();
                body.setDetailsHeader(detailsHeader);
                return detailsHeader;
            }
            if (insert instanceof DetailsFooter) {
                DetailsFooter footer = (DetailsFooter)insert.derive();
                body.setDetailsFooter(footer);
                return footer;
            }
            if (insert instanceof ItemBand) {
                ItemBand itemBand = (ItemBand)insert.derive();
                body.setItemBand(itemBand);
                return itemBand;
            }
            if (insert instanceof NoDataBand) {
                NoDataBand noDataBand = (NoDataBand)insert.derive();
                body.setNoDataBand(noDataBand);
                return noDataBand;
            }
            return null;
        }
        if (rawLeadSelection instanceof CrosstabCellBody) {
            CrosstabCellBody body = (CrosstabCellBody)rawLeadSelection;
            if (insert instanceof CrosstabCell) {
                CrosstabCell crosstabCell = (CrosstabCell)insert.derive();
                body.addElement(crosstabCell);
                return crosstabCell;
            }
        }
        return null;
    }

    private static Object insertDataFactory(AbstractReportDefinition report, DataFactory fromClipboard) {
        CompoundDataFactory element = (CompoundDataFactory)report.getDataFactory();
        DataFactory df = fromClipboard;
        DataFactory dataFactory = df.derive();
        element.add(dataFactory);
        report.notifyNodeChildAdded((Object)dataFactory);
        return dataFactory;
    }

    private static Object insertParameter(AbstractReportDefinition report, ParameterDefinitionEntry fromClipboard) {
        if (!(report instanceof MasterReport)) {
            return null;
        }
        MasterReport masterReportElement = (MasterReport)report;
        ParameterDefinitionEntry pe = fromClipboard;
        try {
            ModifiableReportParameterDefinition definition = (ModifiableReportParameterDefinition)masterReportElement.getParameterDefinition();
            ParameterDefinitionEntry definitionEntry = (ParameterDefinitionEntry)pe.clone();
            definition.addParameterDefinition(definitionEntry);
            report.notifyNodeChildAdded((Object)definitionEntry);
            return definitionEntry;
        }
        catch (CloneNotSupportedException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
            return null;
        }
    }

    private static Object insertExpression(AbstractReportDefinition report, Expression fromClipboard) {
        Expression expression = fromClipboard;
        Expression instance = expression.getInstance();
        report.addExpression(instance);
        report.notifyNodeChildAdded((Object)instance);
        return instance;
    }

    private static Element normalizeForInsert(Element insert) throws CloneNotSupportedException {
        if (!(insert instanceof Section)) {
            return insert.derive();
        }
        if (insert instanceof SubReport) {
            return insert.derive();
        }
        if (insert instanceof Band) {
            Band band = (Band)insert;
            if (!(insert instanceof RootLevelBand)) {
                return band.derive();
            }
            Band newBand = new Band();
            band.copyInto((Element)newBand);
            band.setElementType(BandType.INSTANCE);
            return newBand;
        }
        return null;
    }

    public static UndoEntry delete(ReportDocumentContext context, Object data) {
        ItemBand oldBand;
        GroupFooter oldFooter;
        GroupHeader oldHeader;
        RelationalGroup g;
        if (data == context.getReportDefinition()) {
            return null;
        }
        if (data instanceof ParameterDefinitionEntry) {
            return InsertationUtil.deleteParameter(context, data);
        }
        if (data instanceof Expression) {
            return InsertationUtil.deleteExpression(context, data);
        }
        if (data instanceof DataFactory) {
            return InsertationUtil.deleteDataFactory(context, data);
        }
        if (data instanceof MasterReport) {
            return null;
        }
        if (data instanceof GroupBody) {
            return InsertationUtil.deleteGroupBody((GroupBody)data);
        }
        if (data instanceof Group) {
            return InsertationUtil.deleteGroup((Group)data);
        }
        if (!(data instanceof Element)) {
            return null;
        }
        Element veElement = (Element)data;
        Section parent = veElement.getParentSection();
        if (data instanceof SubReport && parent instanceof AbstractRootLevelBand) {
            AbstractRootLevelBand re = (AbstractRootLevelBand)parent;
            SubReport report = (SubReport)data;
            int index = ModelUtility.findSubreportIndexOf((RootLevelBand)re, report);
            if (index != -1) {
                re.removeSubreport(report);
            }
            if (veElement.getParent() == null) {
                return new BandedSubreportEditUndoEntry(re.getObjectID(), index, report, null);
            }
        }
        if (parent instanceof Band) {
            Band band = (Band)parent;
            int index = ModelUtility.findIndexOf((Section)band, veElement);
            band.removeElement(veElement);
            return new ElementEditUndoEntry(band.getObjectID(), index, veElement, null);
        }
        if (data instanceof GroupHeader) {
            g = (RelationalGroup)parent;
            oldHeader = g.getHeader();
            GroupHeader newHeader = new GroupHeader();
            g.setHeader(newHeader);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newHeader), (Element)oldHeader, (Element)newHeader);
        }
        if (data instanceof GroupFooter) {
            g = (RelationalGroup)parent;
            oldFooter = g.getFooter();
            GroupFooter newFooter = new GroupFooter();
            g.setFooter(newFooter);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newFooter), (Element)oldFooter, (Element)newFooter);
        }
        if (data instanceof ReportFooter) {
            g = (AbstractReportDefinition)parent;
            oldFooter = g.getReportFooter();
            ReportFooter newFooter = new ReportFooter();
            g.setReportFooter(newFooter);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newFooter), (Element)oldFooter, (Element)newFooter);
        }
        if (data instanceof ReportHeader) {
            g = (AbstractReportDefinition)parent;
            oldHeader = g.getReportHeader();
            ReportHeader newHeader = new ReportHeader();
            g.setReportHeader(newHeader);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newHeader), (Element)oldHeader, (Element)newHeader);
        }
        if (data instanceof PageHeader) {
            g = (AbstractReportDefinition)parent;
            oldHeader = g.getPageHeader();
            PageHeader newHeader = new PageHeader();
            g.setPageHeader(newHeader);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newHeader), (Element)oldHeader, (Element)newHeader);
        }
        if (data instanceof PageFooter) {
            g = (AbstractReportDefinition)parent;
            oldFooter = g.getPageFooter();
            PageFooter newFooter = new PageFooter();
            g.setPageFooter(newFooter);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newFooter), (Element)oldFooter, (Element)newFooter);
        }
        if (data instanceof ItemBand) {
            g = (GroupDataBody)parent;
            oldBand = g.getItemBand();
            ItemBand newBand = new ItemBand();
            g.setItemBand(newBand);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newBand), (Element)oldBand, (Element)newBand);
        }
        if (data instanceof NoDataBand) {
            g = (GroupDataBody)parent;
            oldBand = g.getNoDataBand();
            NoDataBand newBand = new NoDataBand();
            g.setNoDataBand(newBand);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newBand), (Element)oldBand, (Element)newBand);
        }
        if (data instanceof DetailsHeader) {
            g = (GroupDataBody)parent;
            oldHeader = g.getDetailsHeader();
            DetailsHeader newHeader = new DetailsHeader();
            g.setDetailsHeader(newHeader);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newHeader), (Element)oldHeader, (Element)newHeader);
        }
        if (data instanceof DetailsFooter) {
            g = (GroupDataBody)parent;
            oldFooter = g.getDetailsFooter();
            DetailsFooter newFooter = new DetailsFooter();
            g.setDetailsFooter(newFooter);
            return new SectionEditUndoEntry(g.getObjectID(), ModelUtility.findIndexOf((Section)g, (Element)newFooter), (Element)oldFooter, (Element)newFooter);
        }
        return null;
    }

    private static UndoEntry deleteGroupBody(GroupBody data) {
        GroupBody subgroup = data;
        RelationalGroup parent = (RelationalGroup)subgroup.getParentSection();
        if (parent != null) {
            GroupBody body = parent.getBody();
            GroupDataBody newBody = new GroupDataBody();
            parent.setBody((GroupBody)newBody);
            return new SectionEditUndoEntry(parent.getObjectID(), ModelUtility.findIndexOf((Section)parent, (Element)newBody), (Element)body, (Element)newBody);
        }
        return null;
    }

    private static UndoEntry deleteDataFactory(ReportDocumentContext context, Object data) {
        AbstractReportDefinition report = context.getReportDefinition();
        CompoundDataFactory dataFactory = (CompoundDataFactory)report.getDataFactory();
        int count = dataFactory.size();
        for (int i = 0; i < count; ++i) {
            DataFactory df = dataFactory.getReference(i);
            if (df != data) continue;
            dataFactory.remove(i);
            report.notifyNodeChildRemoved((Object)df);
            return new DataSourceEditUndoEntry(i, df, null);
        }
        return null;
    }

    private static UndoEntry deleteExpression(ReportDocumentContext context, Object data) {
        AbstractReportDefinition report = context.getReportDefinition();
        ExpressionCollection expressionCollection = report.getExpressions();
        int count = expressionCollection.size();
        for (int i = 0; i < count; ++i) {
            Expression definitionEntry = expressionCollection.getExpression(i);
            if (definitionEntry != data) continue;
            expressionCollection.removeExpression(i);
            report.notifyNodeChildRemoved((Object)definitionEntry);
            return new ExpressionRemoveUndoEntry(i, definitionEntry);
        }
        return null;
    }

    private static UndoEntry deleteParameter(ReportDocumentContext context, Object data) {
        AbstractReportDefinition report = context.getReportDefinition();
        if (!(report instanceof MasterReport)) {
            return null;
        }
        MasterReport mreport = (MasterReport)report;
        ReportParameterDefinition definition = mreport.getParameterDefinition();
        if (!(definition instanceof ModifiableReportParameterDefinition)) {
            return null;
        }
        ModifiableReportParameterDefinition mdef = (ModifiableReportParameterDefinition)definition;
        int count = mdef.getParameterCount();
        for (int i = 0; i < count; ++i) {
            ParameterDefinitionEntry definitionEntry = mdef.getParameterDefinition(i);
            if (definitionEntry != data) continue;
            mdef.removeParameterDefinition(i);
            report.notifyNodeChildRemoved((Object)definitionEntry);
            return new ParameterEditUndoEntry(i, definitionEntry, null);
        }
        return null;
    }

    private static UndoEntry deleteGroup(Group groupElement) {
        Section parent = groupElement.getParentSection();
        if (parent instanceof SubGroupBody) {
            SubGroupBody parentBody = (SubGroupBody)groupElement.getParentSection();
            Group oldGroup = parentBody.getGroup();
            RelationalGroup newRootGroup = new RelationalGroup();
            parentBody.setGroup((Group)newRootGroup);
            return new SectionEditUndoEntry(parentBody.getObjectID(), ModelUtility.findIndexOf((Section)parentBody, (Element)newRootGroup), (Element)oldGroup, (Element)newRootGroup);
        }
        if (parent instanceof AbstractReportDefinition) {
            AbstractReportDefinition report = (AbstractReportDefinition)parent;
            Group oldGroup = report.getRootGroup();
            RelationalGroup newRootGroup = new RelationalGroup();
            report.setRootGroup((Group)newRootGroup);
            return new SectionEditUndoEntry(report.getObjectID(), ModelUtility.findIndexOf((Section)report, (Element)newRootGroup), (Element)oldGroup, (Element)newRootGroup);
        }
        return null;
    }

    public static Object prepareForCopy(ReportDocumentContext context, Object data) {
        if (data instanceof ParameterDefinitionEntry) {
            AbstractReportDefinition report = context.getReportDefinition();
            if (!(report instanceof MasterReport)) {
                return null;
            }
            MasterReport mreport = (MasterReport)report;
            ReportParameterDefinition definition = mreport.getParameterDefinition();
            if (!(definition instanceof ModifiableReportParameterDefinition)) {
                return null;
            }
            ModifiableReportParameterDefinition mdef = (ModifiableReportParameterDefinition)definition;
            int count = mdef.getParameterCount();
            for (int i = 0; i < count; ++i) {
                ParameterDefinitionEntry definitionEntry = mdef.getParameterDefinition(i);
                if (definitionEntry != data) continue;
                try {
                    return definitionEntry.clone();
                }
                catch (CloneNotSupportedException e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                    return null;
                }
            }
            return null;
        }
        if (data instanceof Expression) {
            AbstractReportDefinition report = context.getReportDefinition();
            ExpressionCollection expressionCollection = report.getExpressions();
            int count = expressionCollection.size();
            for (int i = 0; i < count; ++i) {
                Expression definitionEntry = expressionCollection.getExpression(i);
                if (definitionEntry != data) continue;
                return definitionEntry.getInstance();
            }
            return null;
        }
        if (data instanceof DataFactory) {
            AbstractReportDefinition report = context.getReportDefinition();
            CompoundDataFactory dataFactory = (CompoundDataFactory)report.getDataFactory();
            int count = dataFactory.size();
            for (int i = 0; i < count; ++i) {
                DataFactory df = dataFactory.getReference(i);
                if (df != data) continue;
                return df.derive();
            }
            return null;
        }
        if (!(data instanceof Element)) {
            return null;
        }
        Element e = (Element)data;
        Element derived = e.derive();
        if (e instanceof SubReport) {
            if (InsertationUtil.isBandedSubreport(e)) {
                derived.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", SUBREPORT_BANDED_HINT, (Object)Boolean.TRUE);
            } else {
                derived.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", SUBREPORT_BANDED_HINT, (Object)Boolean.FALSE);
            }
        }
        return derived;
    }

    private static boolean isBandedSubreport(Element r) {
        Band parent = r.getParent();
        if (!(parent instanceof RootLevelBand)) {
            return false;
        }
        RootLevelBand rlb = (RootLevelBand)parent;
        SubReport[] reports = rlb.getSubReports();
        for (int i = 0; i < reports.length; ++i) {
            SubReport report = reports[i];
            if (r != report) continue;
            return true;
        }
        return false;
    }
}

