/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.pentaho.reporting.designer.core.util.docking.Category;
import org.pentaho.reporting.designer.core.util.docking.GlobalPane;

public class SideWindowCarrierPanel
extends JComponent {
    private ArrayList<Category> childs;
    private JPanel dragPanel;
    private GlobalPane.Alignment alignment;
    private JComponent contentPane;
    private CategoryVisibleUpdateHandler visibleUpdateHandler;

    public SideWindowCarrierPanel(GlobalPane.Alignment alignment) {
        this.setVisible(false);
        this.visibleUpdateHandler = new CategoryVisibleUpdateHandler();
        this.alignment = alignment;
        this.childs = new ArrayList();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        this.dragPanel = new JPanel();
        this.dragPanel.setPreferredSize(new Dimension(5, 5));
        this.dragPanel.setSize(5, 5);
        this.dragPanel.setOpaque(true);
        this.dragPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        DragHandler dragHandler = new DragHandler();
        this.dragPanel.addMouseListener(dragHandler);
        this.dragPanel.addMouseMotionListener(dragHandler);
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        switch (alignment) {
            case TOP: {
                this.add((Component)this.dragPanel, "South");
                this.dragPanel.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case BOTTOM: {
                this.add((Component)this.dragPanel, "North");
                this.dragPanel.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case LEFT: {
                this.add((Component)this.dragPanel, "East");
                this.dragPanel.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case RIGHT: {
                this.add((Component)this.dragPanel, "West");
                this.dragPanel.setCursor(Cursor.getPredefinedCursor(11));
            }
        }
    }

    public void addWindow(Category toolWindow) {
        if (this.childs.contains(toolWindow)) {
            return;
        }
        this.childs.add(toolWindow);
        toolWindow.addPropertyChangeListener("minimized", this.visibleUpdateHandler);
        this.revalidateComponent();
    }

    public void removeWindow(Category toolWindow) {
        this.childs.remove(toolWindow);
        toolWindow.removePropertyChangeListener("minimized", this.visibleUpdateHandler);
        this.revalidateComponent();
    }

    public Category getWindow(int index) {
        return this.childs.get(index);
    }

    public int getWindowCount() {
        return this.childs.size();
    }

    public void setToolWindowHeight(int height) {
        for (int i = 0; i < this.childs.size(); ++i) {
            Category category = this.childs.get(i);
            JComponent toolWindow = category.getMainComponent();
            Dimension size = toolWindow.getSize();
            size.height = height - this.dragPanel.getHeight();
            toolWindow.setSize(size);
        }
    }

    public void setToolWindowWidth(int width) {
        for (int i = 0; i < this.childs.size(); ++i) {
            Category category = this.childs.get(i);
            JComponent toolWindow = category.getMainComponent();
            Dimension size = toolWindow.getSize();
            size.width = width - this.dragPanel.getWidth();
            toolWindow.setSize(size);
        }
    }

    public JComponent getDragPanel() {
        return this.dragPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revalidateComponent() {
        try {
            this.recomputeVisibleFlag();
            this.contentPane.removeAll();
            if (this.childs.isEmpty()) {
                return;
            }
            ArrayList<JComponent> tempList = new ArrayList<JComponent>(this.childs.size());
            for (int i = 0; i < this.childs.size(); ++i) {
                Category category = this.childs.get(i);
                if (category.isMinimized()) continue;
                tempList.add(category.getMainComponent());
            }
            if (tempList.isEmpty()) {
                return;
            }
            if (tempList.size() == 1) {
                JComponent mainComponent = (JComponent)tempList.get(0);
                this.contentPane.add((Component)mainComponent, "Center");
                return;
            }
            JComponent firstComponent = (JComponent)tempList.get(0);
            JSplitPane splitPane = new JSplitPane(this.alignment.getDirection(), true);
            splitPane.setUI(new KillAllBordersBasicSplitPaneUI());
            splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            splitPane.setTopComponent(firstComponent);
            splitPane.setDividerLocation(0.5);
            splitPane.setResizeWeight(0.5);
            splitPane.setContinuousLayout(true);
            this.contentPane.add((Component)splitPane, "Center");
            for (int i = 1; i < tempList.size(); ++i) {
                JComponent toolWindow = (JComponent)tempList.get(i);
                if (i == tempList.size() - 1) {
                    splitPane.setBottomComponent(toolWindow);
                    splitPane.setDividerLocation(0.5);
                    splitPane.setResizeWeight(0.5);
                    continue;
                }
                JSplitPane childSplitPane = new JSplitPane(this.alignment.getDirection(), true);
                childSplitPane.setUI(new KillAllBordersBasicSplitPaneUI());
                childSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                childSplitPane.setTopComponent(toolWindow);
                childSplitPane.setDividerLocation(0.5);
                childSplitPane.setResizeWeight(0.5);
                splitPane.setBottomComponent(childSplitPane);
                splitPane.setDividerLocation(0.5);
                splitPane.setResizeWeight(0.5);
                splitPane = childSplitPane;
            }
        }
        finally {
            this.revalidate();
            this.invalidate();
            this.repaint();
        }
    }

    private void recomputeVisibleFlag() {
        for (int i = 0; i < this.childs.size(); ++i) {
            Category category = this.childs.get(i);
            if (category.isMinimized()) continue;
            this.setVisible(true);
            return;
        }
        this.setVisible(false);
    }

    public void setPreferredContentSize(Integer value) {
        if (value == null) {
            this.contentPane.setPreferredSize(null);
            this.contentPane.revalidate();
            return;
        }
        Dimension dimension = this.contentPane.getSize();
        if (this.alignment == GlobalPane.Alignment.LEFT || this.alignment == GlobalPane.Alignment.RIGHT) {
            dimension.width = value;
        } else if (this.alignment == GlobalPane.Alignment.TOP || this.alignment == GlobalPane.Alignment.BOTTOM) {
            dimension.height = value;
        }
        this.contentPane.setPreferredSize(dimension);
        this.contentPane.revalidate();
    }

    public Integer getPreferredContentSize() {
        Dimension dimension = this.contentPane.getPreferredSize();
        if (dimension == null) {
            return null;
        }
        if (this.alignment == GlobalPane.Alignment.LEFT || this.alignment == GlobalPane.Alignment.RIGHT) {
            return dimension.width;
        }
        if (this.alignment == GlobalPane.Alignment.TOP || this.alignment == GlobalPane.Alignment.BOTTOM) {
            return dimension.height;
        }
        return null;
    }

    private class CategoryVisibleUpdateHandler
    implements PropertyChangeListener {
        private CategoryVisibleUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SideWindowCarrierPanel.this.revalidateComponent();
        }
    }

    private static class KillAllBordersBasicSplitPaneUI
    extends BasicSplitPaneUI {
        private KillAllBordersBasicSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new BasicSplitPaneDivider(this){

                @Override
                public void setBorder(Border b) {
                }
            };
        }
    }

    private class DragHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private int startX;
        private int startY;

        private DragHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SideWindowCarrierPanel.this.alignment == GlobalPane.Alignment.LEFT) {
                int x = e.getX();
                int xDiff = this.startX - x;
                int w = Math.max(0, SideWindowCarrierPanel.this.getWidth() - xDiff);
                Dimension s = SideWindowCarrierPanel.this.contentPane.getSize();
                s.width = w;
                SideWindowCarrierPanel.this.contentPane.setPreferredSize(s);
                SideWindowCarrierPanel.this.contentPane.revalidate();
            } else if (SideWindowCarrierPanel.this.alignment == GlobalPane.Alignment.RIGHT) {
                int x = e.getX();
                int xDiff = this.startX - x;
                int w = Math.max(0, SideWindowCarrierPanel.this.getWidth() + xDiff);
                Dimension s = SideWindowCarrierPanel.this.contentPane.getSize();
                s.width = w;
                SideWindowCarrierPanel.this.contentPane.setPreferredSize(s);
                SideWindowCarrierPanel.this.contentPane.revalidate();
            } else if (SideWindowCarrierPanel.this.alignment == GlobalPane.Alignment.TOP) {
                int y = e.getY();
                int yDiff = this.startY - y;
                int h = Math.max(0, SideWindowCarrierPanel.this.getHeight() - yDiff);
                Dimension s = SideWindowCarrierPanel.this.contentPane.getSize();
                s.height = h;
                SideWindowCarrierPanel.this.contentPane.setPreferredSize(s);
                SideWindowCarrierPanel.this.contentPane.revalidate();
            } else if (SideWindowCarrierPanel.this.alignment == GlobalPane.Alignment.BOTTOM) {
                int y = e.getY();
                int yDiff = this.startY - y;
                int h = Math.max(0, SideWindowCarrierPanel.this.getHeight() + yDiff);
                Dimension s = SideWindowCarrierPanel.this.contentPane.getSize();
                s.height = h;
                SideWindowCarrierPanel.this.contentPane.setPreferredSize(s);
                SideWindowCarrierPanel.this.contentPane.revalidate();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

