/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.settings.DateFormatModel;
import org.pentaho.reporting.designer.core.settings.NumberFormatModel;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.ArrayAccessUtility;
import org.pentaho.reporting.designer.core.util.table.ArrayTableModel;
import org.pentaho.reporting.designer.core.util.table.CellEditorUtility;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.GenericTransferable;
import org.pentaho.reporting.libraries.designtime.swing.bulk.BulkDataProvider;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkDownAction;
import org.pentaho.reporting.libraries.designtime.swing.bulk.SortBulkUpAction;

public class ArrayCellEditorDialog
extends CommonDialog {
    private static final String FIELD_VALUE_ROLE = "Field";
    private static final String QUERY_VALUE_ROLE = "Query";
    private static final String GROUP_VALUE_ROLE = "Group";
    private static final String NUMBER_FORMAT_VALUE_ROLE = "NumberFormat";
    private static final String DATE_FORMAT_VALUE_ROLE = "DateFormat";
    private ArrayTableModel tableModel;
    private ElementMetaDataTable table;
    private ElementMetaDataTable paletteList;
    private ArrayTableModel paletteListModel;
    private DataFlavor dataFlavor;
    private JPanel contentPane;
    private boolean defaultSize;

    public ArrayCellEditorDialog() throws HeadlessException {
        this.init();
    }

    public ArrayCellEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public ArrayCellEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(UtilMessages.getInstance().getString("ArrayCellEditorDialog.Title"));
        this.tableModel = new ArrayTableModel();
        this.table = new ElementMetaDataTable();
        this.table.setModel(this.tableModel);
        this.paletteListModel = new ArrayTableModel();
        this.paletteListModel.setEditable(false);
        this.paletteList = new ElementMetaDataTable();
        this.paletteList.setModel(this.paletteListModel);
        this.paletteList.setDragEnabled(true);
        this.paletteList.setTransferHandler(new ListTransferHandler());
        this.paletteList.setDropMode(DropMode.ON);
        this.paletteList.addMouseListener(new DoubleClickHandler(this.paletteList.getSelectionModel()));
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BorderLayout());
        super.init();
    }

    protected void performInitialResize() {
        super.performInitialResize();
        this.defaultSize = true;
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ArrayCellEditor";
    }

    protected ArrayTableModel getPaletteListModel() {
        return this.paletteListModel;
    }

    protected ArrayTableModel getTableModel() {
        return this.tableModel;
    }

    protected Component createContentPane() {
        return this.contentPane;
    }

    public Object editArray(Object data, Class arrayType, String valueRole, Class propertyEditorType, String[] extraFields) {
        if (arrayType == null) {
            throw new NullPointerException();
        }
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Expect an array class, not a primitive data-type");
        }
        Class<?> componentType = arrayType.getComponentType();
        if (!ArrayAccessUtility.isArray(data)) {
            data = Array.newInstance(componentType, 0);
        }
        this.dataFlavor = componentType.isArray() ? null : GenericTransferable.ELEMENT_FLAVOR;
        this.tableModel.setType(componentType);
        this.tableModel.setValueRole(valueRole);
        this.tableModel.setExtraFields(extraFields);
        this.tableModel.setPropertyEditorType(propertyEditorType);
        this.tableModel.setData(ArrayAccessUtility.normalizeArray(data), componentType);
        this.paletteListModel.setType(componentType);
        this.paletteListModel.setValueRole(valueRole);
        this.paletteListModel.setExtraFields(extraFields);
        this.paletteListModel.setPropertyEditorType(propertyEditorType);
        this.paletteListModel.setData(ArrayAccessUtility.normalizeArray(data), componentType);
        if (this.dataFlavor != null) {
            this.paletteListModel.clear();
            Object[] selection = this.getSelection(arrayType, valueRole, propertyEditorType, extraFields);
            if (selection != null && selection.length != 0) {
                for (Object s : selection) {
                    this.paletteListModel.add(s);
                }
                this.configurePanelWithSelection();
            } else {
                this.configurePanelWithoutSelection();
            }
        } else {
            this.configurePanelWithoutSelection();
        }
        if (this.defaultSize) {
            this.performInitialResize();
            this.defaultSize = false;
        }
        if (!this.performEdit()) {
            return null;
        }
        this.table.stopEditing();
        Object[] objects = this.tableModel.toArray();
        return ArrayAccessUtility.normalizeNative(objects, componentType);
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.table.getReportDesignerContext();
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        if (reportDesignerContext != null) {
            this.table.setReportDesignerContext(reportDesignerContext);
            this.paletteList.setReportDesignerContext(reportDesignerContext);
        } else {
            this.table.setReportDesignerContext(null);
            this.paletteList.setReportDesignerContext(null);
        }
    }

    public DataFlavor getDataFlavor() {
        return this.dataFlavor;
    }

    private Object[] getSelection(Class arrayType, String valueRole, Class propertyEditorType, String[] extraFields) {
        if (String[].class.equals((Object)arrayType)) {
            if (FIELD_VALUE_ROLE.equals(valueRole)) {
                return CellEditorUtility.getFieldsAsString(this.getReportDesignerContext(), extraFields);
            }
            if (GROUP_VALUE_ROLE.equals(valueRole)) {
                return CellEditorUtility.getGroups(this.getReportDesignerContext());
            }
            if (QUERY_VALUE_ROLE.equals(valueRole)) {
                return CellEditorUtility.getQueryNames(this.getReportDesignerContext());
            }
            if (NUMBER_FORMAT_VALUE_ROLE.equals(valueRole)) {
                return new NumberFormatModel().getNumberFormats();
            }
            if (DATE_FORMAT_VALUE_ROLE.equals(valueRole)) {
                return new DateFormatModel().getNumberFormats();
            }
            if (propertyEditorType != null && PropertyEditor.class.isAssignableFrom(propertyEditorType)) {
                if ("org.pentaho.reporting.engine.classic.extensions.legacy.charts.propertyeditor.ColorPropertyEditor".equals(propertyEditorType.getName())) {
                    return CellEditorUtility.getExcelColorsAsText();
                }
                try {
                    PropertyEditor editor = (PropertyEditor)propertyEditorType.newInstance();
                    return editor.getTags();
                }
                catch (Throwable e) {
                    UncaughtExceptionsModel.getInstance().addException(e);
                }
            }
        } else if (Color[].class.equals((Object)arrayType)) {
            return ColorUtility.getPredefinedExcelColors();
        }
        return null;
    }

    private void configurePanelWithSelection() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        JLabel columnsLabel = new JLabel(UtilMessages.getInstance().getString("ArrayCellEditorDialog.SelectedItems"));
        AddEntryAction addGroupAction = new AddEntryAction(this.tableModel);
        RemoveEntryAction removeGroupAction = new RemoveEntryAction(this.tableModel, selectionModel);
        SortBulkUpAction sortUpAction = new SortBulkUpAction((BulkDataProvider)this.tableModel, selectionModel, (JTable)this.table);
        SortBulkDownAction sortDownAction = new SortBulkDownAction((BulkDataProvider)this.tableModel, selectionModel, (JTable)this.table);
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        JLabel tablesColumnsLabel = new JLabel(UtilMessages.getInstance().getString("ArrayCellEditorDialog.AvailableSelection"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)tablesColumnsLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 5.0;
        gbc.gridheight = 1;
        gbc.weightx = 2.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        JScrollPane comp = new JScrollPane(this.paletteList, 20, 30);
        tablesPane.add((Component)comp, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)sortUpAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)sortDownAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)addGroupAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)removeGroupAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 5;
        gbc.insets = new Insets(0, 5, 5, 0);
        tablesPane.add((Component)new JScrollPane(this.table, 20, 30), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = new Insets(5, 5, 5, 0);
        tablesPane.add((Component)new BorderlessButton((Action)new AddSelectionAction(this.paletteList.getSelectionModel())), gbc);
        this.contentPane.removeAll();
        this.contentPane.add(tablesPane);
        this.contentPane.invalidate();
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private void configurePanelWithoutSelection() {
        JLabel columnsLabel = new JLabel(UtilMessages.getInstance().getString("ArrayCellEditorDialog.SelectedItems"));
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        AddEntryAction addGroupAction = new AddEntryAction(this.tableModel);
        RemoveEntryAction removeGroupAction = new RemoveEntryAction(this.tableModel, selectionModel);
        SortBulkUpAction sortUpAction = new SortBulkUpAction((BulkDataProvider)this.tableModel, selectionModel, (JTable)this.table);
        SortBulkDownAction sortDownAction = new SortBulkDownAction((BulkDataProvider)this.tableModel, selectionModel, (JTable)this.table);
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)columnsLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)sortUpAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)sortDownAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)addGroupAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)new BorderlessButton((Action)removeGroupAction), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 5;
        gbc.insets = new Insets(0, 5, 5, 0);
        tablesPane.add((Component)new JScrollPane(this.table, 20, 30), gbc);
        this.contentPane.removeAll();
        this.contentPane.add(tablesPane);
        this.contentPane.invalidate();
        this.contentPane.revalidate();
        this.contentPane.repaint();
    }

    private class AddSelectionAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;

        private AddSelectionAction(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.putValue("SmallIcon", IconLoader.getInstance().getFowardArrowIcon());
            this.putValue("ShortDescription", Messages.getString("EditGroupDetailsDialog.AddColumn", new Object[0]));
            selectionModel.addListSelectionListener(this);
            this.setEnabled(!selectionModel.isSelectionEmpty());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayTableModel data = ArrayCellEditorDialog.this.getTableModel();
            ArrayTableModel fields = ArrayCellEditorDialog.this.getPaletteListModel();
            for (int i = 0; i < fields.getSize(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                data.add(fields.get(i));
            }
        }
    }

    private class ListTransferHandler
    extends TransferHandler {
        private ListTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            DataFlavor dataFlavor = ArrayCellEditorDialog.this.getDataFlavor();
            if (!support.isDataFlavorSupported(dataFlavor)) {
                return false;
            }
            if (!support.isDrop()) {
                return false;
            }
            try {
                Object[] transferData = (Object[])support.getTransferable().getTransferData(dataFlavor);
                if (transferData == null) {
                    return false;
                }
                ArrayList<Object> items = new ArrayList<Object>();
                for (Object item : transferData) {
                    if (item instanceof FieldDefinition) {
                        FieldDefinition fd = (FieldDefinition)item;
                        items.add(fd.getName());
                        continue;
                    }
                    items.add(item);
                }
                TransferHandler.DropLocation dropLocation = support.getDropLocation();
                Point point = dropLocation.getDropPoint();
                int idx = ArrayCellEditorDialog.this.table.rowAtPoint(point);
                if (idx == -1) {
                    for (int i = 0; i < items.size(); ++i) {
                        ArrayCellEditorDialog.this.tableModel.add(items.get(i));
                    }
                } else {
                    for (int i = items.size() - 1; i >= 0; --i) {
                        ArrayCellEditorDialog.this.tableModel.add(idx, items.get(i));
                    }
                }
            }
            catch (Exception e) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
            return super.importData(support);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            return support.isDataFlavorSupported(ArrayCellEditorDialog.this.getDataFlavor());
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList lcomp = (JList)c;
            Object[] selectedValues = lcomp.getSelectedValues();
            return new GenericTransferable(selectedValues);
        }
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private ListSelectionModel selectionModel;

        private DoubleClickHandler(ListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                ArrayTableModel data = ArrayCellEditorDialog.this.getTableModel();
                ArrayTableModel fields = ArrayCellEditorDialog.this.getPaletteListModel();
                for (int i = 0; i < fields.getSize(); ++i) {
                    if (!this.selectionModel.isSelectedIndex(i)) continue;
                    data.add(fields.get(i));
                }
            }
        }
    }

    private class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        private ListSelectionModel selectionModel;
        private ArrayTableModel tableModel;

        private RemoveEntryAction(ArrayTableModel tableModel, ListSelectionModel selectionModel) {
            this.tableModel = tableModel;
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", UtilMessages.getInstance().getString("ArrayCellEditorDialog.RemoveEntry.Description"));
            this.selectionModel = selectionModel;
            this.selectionModel.addListSelectionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            ArrayCellEditorDialog.this.table.stopEditing();
            int maxIdx = this.selectionModel.getMaxSelectionIndex();
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (i = this.selectionModel.getMinSelectionIndex(); i <= maxIdx; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                list.add(0, i);
            }
            for (i = 0; i < list.size(); ++i) {
                Integer dataEntry = (Integer)list.get(i);
                this.tableModel.remove(dataEntry);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!this.selectionModel.isSelectionEmpty());
        }
    }

    private static class AddEntryAction
    extends AbstractAction {
        private ArrayTableModel tableModel;

        private AddEntryAction(ArrayTableModel tableModel) {
            this.tableModel = tableModel;
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", UtilMessages.getInstance().getString("ArrayCellEditorDialog.AddEntry.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.tableModel.add(null);
        }
    }
}

