/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Paint;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.ReportRenderContext;
import org.pentaho.reporting.designer.core.settings.SettingsListener;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.table.ArrayCellEditor;
import org.pentaho.reporting.designer.core.util.table.ArrayCellRenderer;
import org.pentaho.reporting.designer.core.util.table.DesignerPropertyCellEditorWithEllipsis;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.GroupedNameCellRenderer;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingHeaderCellEditor;
import org.pentaho.reporting.designer.core.util.table.GroupingHeaderCellRenderer;
import org.pentaho.reporting.designer.core.util.table.StringValueCellEditor;
import org.pentaho.reporting.designer.core.util.table.expressions.ExpressionCellHandler;
import org.pentaho.reporting.designer.core.util.table.expressions.ReportPreProcessorCellEditor;
import org.pentaho.reporting.designer.core.util.table.expressions.ReportPreProcessorCellRenderer;
import org.pentaho.reporting.designer.core.util.table.expressions.StructureFunctionCellEditor;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.FormattingTableCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.PaintCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.date.DateCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.date.TimeCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.PropertyEditorCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.PropertyEditorCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;

public class ElementMetaDataTable
extends JTable
implements DesignerContextComponent {
    private static final Log logger = LogFactory.getLog(ElementMetaDataTable.class);
    private GroupingHeaderCellRenderer groupingCellRenderer;
    private PropertyEditorCellRenderer propertyEditorCellRenderer;
    private DesignerPropertyCellEditorWithEllipsis propertyEditorCellEditor;
    private PropertyEditorCellEditor taggedPropertyEditorCellEditor;
    private ArrayCellRenderer arrayCellRenderer;
    private ArrayCellEditor arrayCellEditor;
    private ExpressionCellHandler expressionsCellEditor;
    private ExpressionCellHandler expressionsCellRenderer;
    private StringValueCellEditor stringValueCellEditor;
    private StructureFunctionCellEditor structureFunctionCellEditor;
    private ReportPreProcessorCellEditor reportPreProcessorCellEditor;
    private ReportPreProcessorCellRenderer reportPreProcessorCellRenderer;
    private ActiveContextChangeHandler changeHandler;

    public ElementMetaDataTable() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setGridColor(SystemColor.controlShadow);
        this.changeHandler = new ActiveContextChangeHandler();
        this.structureFunctionCellEditor = new StructureFunctionCellEditor();
        this.reportPreProcessorCellEditor = new ReportPreProcessorCellEditor();
        this.expressionsCellEditor = new ExpressionCellHandler();
        this.expressionsCellRenderer = new ExpressionCellHandler();
        this.reportPreProcessorCellRenderer = new ReportPreProcessorCellRenderer();
        this.groupingCellRenderer = new GroupingHeaderCellRenderer();
        this.taggedPropertyEditorCellEditor = new PropertyEditorCellEditor();
        this.propertyEditorCellEditor = new DesignerPropertyCellEditorWithEllipsis();
        this.propertyEditorCellRenderer = new PropertyEditorCellRenderer();
        this.arrayCellRenderer = new ArrayCellRenderer();
        this.arrayCellEditor = new ArrayCellEditor();
        this.stringValueCellEditor = new StringValueCellEditor();
        this.setDefaultEditor(Object.class, null);
        this.setDefaultEditor(GroupingHeader.class, new GroupingHeaderCellEditor());
        this.setDefaultEditor(Expression.class, this.expressionsCellEditor);
        this.setDefaultEditor(StructureFunction.class, this.structureFunctionCellEditor);
        this.setDefaultEditor(ReportPreProcessor.class, this.reportPreProcessorCellEditor);
        this.setDefaultEditor(Number.class, (TableCellEditor)new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(Integer.class, (TableCellEditor)new GenericCellEditor(Integer.class));
        this.setDefaultEditor(Float.class, (TableCellEditor)new GenericCellEditor(Float.class));
        this.setDefaultEditor(Double.class, (TableCellEditor)new GenericCellEditor(Double.class));
        this.setDefaultEditor(Short.class, (TableCellEditor)new GenericCellEditor(Short.class));
        this.setDefaultEditor(Byte.class, (TableCellEditor)new GenericCellEditor(Byte.class));
        this.setDefaultEditor(Long.class, (TableCellEditor)new GenericCellEditor(Long.class));
        this.setDefaultEditor(BigInteger.class, (TableCellEditor)new GenericCellEditor(BigInteger.class));
        this.setDefaultEditor(BigDecimal.class, (TableCellEditor)new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(String.class, this.stringValueCellEditor);
        this.setDefaultEditor(java.util.Date.class, (TableCellEditor)new DateCellEditor(java.util.Date.class));
        this.setDefaultEditor(Date.class, (TableCellEditor)new DateCellEditor(java.util.Date.class));
        this.setDefaultEditor(Time.class, (TableCellEditor)new TimeCellEditor(Time.class));
        this.setDefaultEditor(Timestamp.class, (TableCellEditor)new DateCellEditor(Timestamp.class));
        this.setDefaultRenderer(GroupingHeader.class, new GroupingHeaderCellRenderer());
        this.setDefaultRenderer(GroupedName.class, new GroupedNameCellRenderer());
        this.setDefaultRenderer(StructureFunction.class, this.expressionsCellRenderer);
        this.setDefaultRenderer(Expression.class, this.expressionsCellRenderer);
        this.setDefaultRenderer(Paint.class, (TableCellRenderer)new PaintCellRenderer());
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new GenericCellRenderer());
        this.setDefaultRenderer(String.class, (TableCellRenderer)new GenericCellRenderer());
        this.setDefaultRenderer(ReportPreProcessor.class, this.reportPreProcessorCellRenderer);
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS", Locale.ENGLISH);
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH)));
        this.setDefaultRenderer(Time.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)new SimpleDateFormat("HH:mm:ss.SSSS", Locale.ENGLISH)));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        WorkspaceSettings.getInstance().addSettingsListener(new LocaleSettingsListener());
        this.applyLocaleSettings(WorkspaceSettings.getInstance());
    }

    private static SimpleDateFormat createSafely(String pattern, String defaultPattern, Locale locale) {
        try {
            if (!StringUtils.isEmpty((String)pattern)) {
                return new SimpleDateFormat(pattern, locale);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid format string found in locale settings", (Throwable)e);
        }
        return new SimpleDateFormat(defaultPattern, locale);
    }

    public void applyLocaleSettings(LocaleSettings localeSettings) {
        SimpleDateFormat isoDateFormat = ElementMetaDataTable.createSafely(localeSettings.getDatetimeFormatPattern(), "yyyy-MM-dd HH:mm:ss.SSSS", localeSettings.getLocale());
        TimeZone timeZone = localeSettings.getTimeZone();
        isoDateFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        DateCellEditor dateCellEditor = new DateCellEditor(java.util.Date.class);
        dateCellEditor.setDateFormat((DateFormat)isoDateFormat);
        this.setDefaultEditor(java.util.Date.class, (TableCellEditor)dateCellEditor);
        DateCellEditor timestampEditor = new DateCellEditor(Timestamp.class);
        timestampEditor.setDateFormat((DateFormat)isoDateFormat);
        this.setDefaultEditor(Timestamp.class, (TableCellEditor)timestampEditor);
        SimpleDateFormat dateFormat = ElementMetaDataTable.createSafely(localeSettings.getDateFormatPattern(), "yyyy-MM-dd", localeSettings.getLocale());
        dateFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)dateFormat));
        DateCellEditor sqlDateCellEditor = new DateCellEditor(Date.class);
        sqlDateCellEditor.setDateFormat((DateFormat)dateFormat);
        this.setDefaultEditor(Date.class, (TableCellEditor)sqlDateCellEditor);
        SimpleDateFormat timeFormat = ElementMetaDataTable.createSafely(localeSettings.getTimeFormatPattern(), "HH:mm:ss.SSSS", localeSettings.getLocale());
        timeFormat.setTimeZone(timeZone);
        this.setDefaultRenderer(Time.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)timeFormat));
        TimeCellEditor timeCellEditor = new TimeCellEditor(Time.class);
        timeCellEditor.setDateFormat((DateFormat)timeFormat);
        this.setDefaultEditor(Time.class, (TableCellEditor)timeCellEditor);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int columnIndex = this.convertColumnIndexToModel(column);
        if (this.getModel().isCellEditable(row, columnIndex)) {
            return this.getCellEditor(row, columnIndex) != null;
        }
        return false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int viewColumn) {
        int column = this.convertColumnIndexToModel(viewColumn);
        Object value = this.getModel().getValueAt(row, column);
        if (value instanceof GroupingHeader) {
            return this.groupingCellRenderer;
        }
        ElementMetaDataTableModel model = (ElementMetaDataTableModel)this.getModel();
        Class columnClass = model.getClassForCell(row, column);
        if (columnClass.isArray()) {
            return this.arrayCellRenderer;
        }
        PropertyEditor propertyEditor = model.getEditorForCell(row, column);
        if (propertyEditor != null) {
            this.propertyEditorCellRenderer.setPropertyEditor(propertyEditor);
            return this.propertyEditorCellRenderer;
        }
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer != null) {
            return renderer;
        }
        TableCellRenderer defaultRenderer = this.getDefaultRenderer(columnClass);
        if (defaultRenderer != null) {
            return defaultRenderer;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("No renderer for column class " + columnClass));
        }
        return this.getDefaultRenderer(Object.class);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int viewColumn) {
        TableColumn tableColumn;
        TableCellEditor renderer;
        int column = this.convertColumnIndexToModel(viewColumn);
        Object value = this.getModel().getValueAt(row, column);
        if (value instanceof GroupingHeader) {
            return this.getDefaultEditor(GroupingHeader.class);
        }
        ElementMetaDataTableModel model = (ElementMetaDataTableModel)this.getModel();
        PropertyEditor propertyEditor = model.getEditorForCell(row, column);
        Class columnClass = model.getClassForCell(row, column);
        if (propertyEditor != null) {
            String[] tags = propertyEditor.getTags();
            if (columnClass.isArray()) {
                this.arrayCellEditor.setPropertyEditorType(propertyEditor.getClass());
            } else {
                if (tags == null || tags.length == 0) {
                    this.propertyEditorCellEditor.setPropertyEditor(propertyEditor);
                    return this.propertyEditorCellEditor;
                }
                this.taggedPropertyEditorCellEditor.setPropertyEditor(propertyEditor);
                return this.taggedPropertyEditorCellEditor;
            }
        }
        if ((renderer = (tableColumn = this.getColumnModel().getColumn(column)).getCellEditor()) != null) {
            return renderer;
        }
        if (columnClass.isArray()) {
            return this.arrayCellEditor;
        }
        TableCellEditor editor = this.getDefaultEditor(columnClass);
        if (editor != null && logger.isTraceEnabled()) {
            logger.trace((Object)("Using preconfigured default editor for column class " + columnClass + ": " + editor));
        }
        return editor;
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext newContext) {
        ReportDesignerContext oldContext = this.arrayCellEditor.getReportDesignerContext();
        if (oldContext != null) {
            oldContext.removePropertyChangeListener(this.changeHandler);
            ReportDocumentContext oldActiveContext = this.getReportRenderContext();
            this.updateActiveContext(oldActiveContext, null);
        }
        this.arrayCellEditor.setReportDesignerContext(newContext);
        this.stringValueCellEditor.setReportDesignerContext(newContext);
        this.expressionsCellRenderer.setReportDesignerContext(newContext);
        this.expressionsCellEditor.setReportDesignerContext(newContext);
        this.structureFunctionCellEditor.setReportDesignerContext(newContext);
        if (newContext != null) {
            newContext.addPropertyChangeListener("activeContext", this.changeHandler);
            this.updateActiveContext(null, newContext.getActiveContext());
        }
    }

    protected void updateActiveContext(ReportDocumentContext oldContext, ReportDocumentContext activeContext) {
        this.structureFunctionCellEditor.setRenderContext(activeContext);
        this.reportPreProcessorCellEditor.setRenderContext(activeContext);
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.arrayCellEditor.getReportDesignerContext();
    }

    public ReportDocumentContext getReportRenderContext() {
        ReportDesignerContext reportDesignerContext = this.getReportDesignerContext();
        if (reportDesignerContext == null) {
            return null;
        }
        return reportDesignerContext.getActiveContext();
    }

    public boolean isFormulaFragment() {
        return this.stringValueCellEditor.isFormulaFragment();
    }

    public void setFormulaFragment(boolean formulaFragment) {
        this.stringValueCellEditor.setFormulaFragment(formulaFragment);
    }

    public void stopEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private class ActiveContextChangeHandler
    implements PropertyChangeListener {
        private ActiveContextChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportRenderContext oldContext = (ReportRenderContext)evt.getOldValue();
            ReportRenderContext activeContext = (ReportRenderContext)evt.getNewValue();
            ElementMetaDataTable.this.updateActiveContext(oldContext, activeContext);
        }
    }

    private class LocaleSettingsListener
    implements SettingsListener {
        private LocaleSettingsListener() {
        }

        @Override
        public void settingsChanged() {
            ElementMetaDataTable.this.applyLocaleSettings(WorkspaceSettings.getInstance());
        }
    }
}

