/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.table.SortableTableModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;

public class SortHeaderPanel
extends JPanel {
    private SortableTableModel dataModel;
    private ShowGroupedAction groupedAction;
    private ShowSortedAscendingAction ascendingAction;
    private ShowSortedDescendingAction descendingAction;

    public SortHeaderPanel() {
        this.setLayout(new FlowLayout(3));
        this.groupedAction = new ShowGroupedAction();
        this.ascendingAction = new ShowSortedAscendingAction();
        this.descendingAction = new ShowSortedDescendingAction();
        JToggleButton groupButton = new JToggleButton(this.groupedAction);
        JToggleButton sortAscendingButton = new JToggleButton(this.ascendingAction);
        JToggleButton sortDescendingButton = new JToggleButton(this.descendingAction);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(groupButton);
        buttonGroup.add(sortAscendingButton);
        buttonGroup.add(sortDescendingButton);
        groupButton.setSelected(true);
        this.add(groupButton);
        this.add(sortAscendingButton);
        this.add(sortDescendingButton);
    }

    public SortHeaderPanel(SortableTableModel dataModel) {
        this();
        this.dataModel = dataModel;
    }

    public SortableTableModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(SortableTableModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.ascendingAction.setEnabled(enabled);
        this.descendingAction.setEnabled(enabled);
        this.groupedAction.setEnabled(enabled);
    }

    private class ShowSortedDescendingAction
    extends AbstractAction {
        private ShowSortedDescendingAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getSortDescendingIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SortHeaderPanel.this.dataModel != null) {
                SortHeaderPanel.this.dataModel.setTableStyle(TableStyle.DESCENDING);
            }
        }
    }

    private class ShowSortedAscendingAction
    extends AbstractAction {
        private ShowSortedAscendingAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getSortAscendingIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SortHeaderPanel.this.dataModel != null) {
                SortHeaderPanel.this.dataModel.setTableStyle(TableStyle.ASCENDING);
            }
        }
    }

    private class ShowGroupedAction
    extends AbstractAction {
        private ShowGroupedAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getGroupIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SortHeaderPanel.this.dataModel != null) {
                SortHeaderPanel.this.dataModel.setTableStyle(TableStyle.GROUPED);
            }
        }
    }
}

