/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.BasicTextPropertyEditorDialog;

public class TextAreaPropertyEditorDialog
extends BasicTextPropertyEditorDialog {
    private KeyedComboBoxModel<String, String> syntaxModel;

    public TextAreaPropertyEditorDialog() throws HeadlessException {
        this.init();
    }

    public TextAreaPropertyEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public TextAreaPropertyEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.syntaxModel = new KeyedComboBoxModel();
        this.syntaxModel.add((Object)"text/plain", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.None"));
        this.syntaxModel.add((Object)"text/java", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Java"));
        this.syntaxModel.add((Object)"text/javascript", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.JavaScript"));
        this.syntaxModel.add((Object)"text/groovy", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Groovy"));
        this.syntaxModel.add((Object)"text/html", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Html"));
        this.syntaxModel.add((Object)"text/css", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.CSS"));
        this.syntaxModel.add((Object)"text/sql", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.SQL"));
        this.syntaxModel.add((Object)"text/xml", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.XML"));
        this.syntaxModel.add((Object)"text/python", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.Python"));
        this.syntaxModel.add((Object)"text/tcl", (Object)UtilMessages.getInstance().getString("RSyntaxAreaLanguages.TCL"));
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.TextAreaPropertyEditor";
    }

    protected JTextArea createTextArea() {
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        textArea.setBracketMatchingEnabled(true);
        textArea.setSyntaxEditingStyle("text/java");
        textArea.setColumns(60);
        textArea.setRows(20);
        textArea.getDocument().addDocumentListener((DocumentListener)new BasicTextPropertyEditorDialog.DocumentUpdateHandler((BasicTextPropertyEditorDialog)this));
        return textArea;
    }

    protected Component createContentPane() {
        JComboBox syntaxBox = new JComboBox(this.syntaxModel);
        syntaxBox.addActionListener(new SyntaxHighlightAction());
        JPanel syntaxSelectionPane = new JPanel();
        syntaxSelectionPane.setLayout(new FlowLayout());
        syntaxSelectionPane.add(syntaxBox);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new RTextScrollPane(500, 300, (RTextArea)((RSyntaxTextArea)this.getTextArea()), true), "Center");
        contentPane.add(syntaxBox, "North");
        return contentPane;
    }

    private class SyntaxHighlightAction
    implements ActionListener {
        private SyntaxHighlightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = TextAreaPropertyEditorDialog.this.syntaxModel.getSelectedKey();
            if (o instanceof String) {
                RSyntaxTextArea textArea = (RSyntaxTextArea)TextAreaPropertyEditorDialog.this.getTextArea();
                textArea.setSyntaxEditingStyle((String)o);
            }
        }
    }
}

