/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.expressions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionEditorDialog;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class ExpressionCellHandler
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private JButton editButton = new JButton(new EditorAction());
    private ImageIcon addIcon;
    private ImageIcon editIcon;
    private JTable table;
    private ReportDesignerContext reportDesignerContext;
    private Expression value;

    public ExpressionCellHandler() {
        this.editButton.setHorizontalAlignment(0);
        this.editButton.setBorderPainted(false);
        this.addIcon = new ImageIcon(ExpressionCellHandler.class.getResource("/org/pentaho/reporting/designer/core/icons/Add.png"));
        this.editIcon = new ImageIcon(ExpressionCellHandler.class.getResource("/org/pentaho/reporting/designer/core/icons/Edit.png"));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.configureEditButton(table, value, isSelected);
        return this.editButton;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.configureEditButton(table, value, isSelected);
        return this.editButton;
    }

    private void configureEditButton(JTable table, Object value, boolean isSelected) {
        this.table = table;
        this.value = value instanceof Expression ? (Expression)value : null;
        if (this.value == null) {
            this.editButton.setIcon(this.addIcon);
        } else {
            this.editButton.setIcon(this.editIcon);
        }
        if (isSelected) {
            this.editButton.setBackground(table.getSelectionBackground());
        } else {
            this.editButton.setBackground(table.getBackground());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 1 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setReportDesignerContext(ReportDesignerContext reportDesignerContext) {
        this.reportDesignerContext = reportDesignerContext;
    }

    private class EditorAction
    extends AbstractAction {
        private EditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExpressionCellHandler.this.table == null) {
                return;
            }
            Window o = LibSwingUtil.getWindowAncestor((Component)ExpressionCellHandler.this.table);
            ExpressionEditorDialog editorDialog = o instanceof Dialog ? new ExpressionEditorDialog((Dialog)o) : (o instanceof Frame ? new ExpressionEditorDialog((Frame)o) : new ExpressionEditorDialog());
            Expression expression = editorDialog.performEditExpression(ExpressionCellHandler.this.reportDesignerContext, ExpressionCellHandler.this.value);
            if (!editorDialog.isConfirmed()) {
                ExpressionCellHandler.this.cancelCellEditing();
                return;
            }
            ExpressionCellHandler.this.value = expression;
            ExpressionCellHandler.this.stopCellEditing();
        }
    }
}

