/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table.expressions;

import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.util.FastPropertyEditorManager;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupingHeader;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.PlainMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ReportPreProcessorPropertiesTableModel
extends AbstractTableModel
implements ElementMetaDataTableModel,
GroupingModel {
    private static final Log logger = LogFactory.getLog(ReportPreProcessorPropertiesTableModel.class);
    private static final GroupingHeader[] EMPTY_GROUPINGS = new GroupingHeader[0];
    private static final ReportPreProcessorPropertyMetaData[] EMPTY_METADATA = new ReportPreProcessorPropertyMetaData[0];
    private ReportPreProcessorPropertyMetaData[] metaData;
    private GroupingHeader[] groupings;
    private TableStyle tableStyle = TableStyle.GROUPED;
    private ReportPreProcessor elements = null;
    private BeanUtility editors = null;

    public ReportPreProcessorPropertiesTableModel() {
        this.metaData = EMPTY_METADATA;
        this.groupings = EMPTY_GROUPINGS;
    }

    @Override
    public int getRowCount() {
        return this.metaData.length;
    }

    protected ReportPreProcessorPropertyMetaData getMetaData(int row) {
        return this.metaData[row];
    }

    protected GroupingHeader getGroupings(int row) {
        return this.groupings[row];
    }

    @Override
    public TableStyle getTableStyle() {
        return this.tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle tableStyle) {
        if (tableStyle == null) {
            throw new NullPointerException();
        }
        this.tableStyle = tableStyle;
        try {
            this.updateData(this.getData());
        }
        catch (IntrospectionException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            try {
                this.updateData(null);
            }
            catch (IntrospectionException e1) {
                UncaughtExceptionsModel.getInstance().addException(e);
            }
        }
    }

    protected void updateData(ReportPreProcessor elements) throws IntrospectionException {
        this.elements = elements;
        this.editors = elements == null ? null : new BeanUtility((Object)elements);
        ReportPreProcessorPropertyMetaData[] metaData = this.selectCommonAttributes();
        if (this.tableStyle == TableStyle.ASCENDING) {
            Arrays.sort(metaData, new PlainMetaDataComparator());
            this.groupings = new GroupingHeader[metaData.length];
            this.metaData = metaData;
        } else if (this.tableStyle == TableStyle.DESCENDING) {
            Arrays.sort(metaData, Collections.reverseOrder(new PlainMetaDataComparator()));
            this.groupings = new GroupingHeader[metaData.length];
            this.metaData = metaData;
        } else {
            Arrays.sort(metaData, new GroupedMetaDataComparator());
            int groupCount = 0;
            Locale locale = Locale.getDefault();
            if (metaData.length > 0) {
                String oldValue = null;
                for (int i = 0; i < metaData.length; ++i) {
                    if (groupCount == 0) {
                        groupCount = 1;
                        ReportPreProcessorPropertyMetaData firstdata = metaData[i];
                        oldValue = firstdata.getGrouping(locale);
                        continue;
                    }
                    ReportPreProcessorPropertyMetaData data = metaData[i];
                    String grouping = data.getGrouping(locale);
                    if (ObjectUtilities.equal((Object)oldValue, (Object)grouping)) continue;
                    oldValue = grouping;
                    ++groupCount;
                }
            }
            ReportPreProcessorPropertyMetaData[] groupedMetaData = new ReportPreProcessorPropertyMetaData[metaData.length + groupCount];
            this.groupings = new GroupingHeader[groupedMetaData.length];
            int targetIdx = 0;
            GroupingHeader group = null;
            for (int sourceIdx = 0; sourceIdx < metaData.length; ++sourceIdx) {
                ReportPreProcessorPropertyMetaData data = metaData[sourceIdx];
                if (sourceIdx == 0) {
                    this.groupings[targetIdx] = group = new GroupingHeader(data.getGrouping(locale));
                    ++targetIdx;
                } else {
                    String newgroup = data.getGrouping(locale);
                    if (!ObjectUtilities.equal((Object)newgroup, (Object)group.getHeaderText())) {
                        this.groupings[targetIdx] = group = new GroupingHeader(newgroup);
                        ++targetIdx;
                    }
                }
                this.groupings[targetIdx] = group;
                groupedMetaData[targetIdx] = data;
                ++targetIdx;
            }
            this.metaData = groupedMetaData;
        }
        this.fireTableDataChanged();
    }

    private ReportPreProcessorPropertyMetaData[] selectCommonAttributes() {
        if (this.elements == null) {
            return EMPTY_METADATA;
        }
        String name = this.elements.getClass().getName();
        if (!ReportPreProcessorRegistry.getInstance().isReportPreProcessorRegistered(name)) {
            return EMPTY_METADATA;
        }
        ReportPreProcessorMetaData preProcessorMetaData = ReportPreProcessorRegistry.getInstance().getReportPreProcessorMetaData(name);
        return preProcessorMetaData.getPropertyDescriptions();
    }

    public void setData(ReportPreProcessor elements) {
        try {
            this.updateData(elements);
        }
        catch (Exception e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            try {
                this.updateData(null);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }

    public ReportPreProcessor getData() {
        return this.elements;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return UtilMessages.getInstance().getString("ReportPreProcessorPropertiesTableModel.NameColumn");
            }
            case 1: {
                return UtilMessages.getInstance().getString("ReportPreProcessorPropertiesTableModel.ValueColumn");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return this.getGroupings(rowIndex);
        }
        switch (columnIndex) {
            case 0: {
                return metaData.getDisplayName(Locale.getDefault());
            }
            case 1: {
                return this.computeFullValue(metaData);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return false;
        }
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                return;
            }
            case 1: {
                if (!this.defineFullValue(metaData, aValue)) break;
                this.fireTableDataChanged();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    private boolean defineFullValue(ReportPreProcessorPropertyMetaData metaData, Object value) {
        boolean changed = false;
        try {
            BeanUtility element = this.editors;
            Object attribute = element.getProperty(metaData.getName());
            if (!ObjectUtilities.equal((Object)attribute, (Object)value)) {
                changed = true;
            }
            if (changed) {
                String name = metaData.getName();
                element.setProperty(name, value);
            }
        }
        catch (BeanException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
        }
        return changed;
    }

    private Object computeFullValue(ReportPreProcessorPropertyMetaData metaData) {
        if (this.elements == null) {
            return null;
        }
        try {
            BeanUtility element = this.editors;
            return element.getProperty(metaData.getName());
        }
        catch (BeanException e) {
            UncaughtExceptionsModel.getInstance().addException(e);
            return null;
        }
    }

    public Class getClassForCell(int rowIndex, int columnIndex) {
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(rowIndex);
        if (metaData == null) {
            return GroupingHeader.class;
        }
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return metaData.getPropertyType();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public PropertyEditor getEditorForCell(int aRowIndex, int aColumnIndex) {
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(aRowIndex);
        if (metaData == null) {
            return null;
        }
        try {
            switch (aColumnIndex) {
                case 0: {
                    return null;
                }
                case 1: {
                    PropertyEditor editor = metaData.getEditor();
                    if (editor != null) {
                        return editor;
                    }
                    Class<?> editorClass = metaData.getBeanDescriptor().getPropertyEditorClass();
                    if (editorClass != null) {
                        return (PropertyEditor)editorClass.newInstance();
                    }
                    if (String.class.equals((Object)metaData.getPropertyType())) {
                        return null;
                    }
                    return FastPropertyEditorManager.findEditor(metaData.getPropertyType());
                }
            }
            throw new IndexOutOfBoundsException();
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Failed to create property-editor", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getValueRole(int row, int column) {
        if (column != 1) {
            return null;
        }
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getPropertyRole();
    }

    @Override
    public String[] getExtraFields(int row, int column) {
        if (column == 0) {
            return null;
        }
        ReportPreProcessorPropertyMetaData metaData = this.getMetaData(row);
        if (metaData == null) {
            return null;
        }
        return metaData.getExtraCalculationFields();
    }

    @Override
    public GroupingHeader getGroupHeader(int index) {
        return this.getGroupings(index);
    }

    @Override
    public boolean isHeaderRow(int index) {
        return this.metaData[index] == null;
    }
}

