/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AttributeEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private String attributeNamespace;
    private String attributeName;
    private Object oldValue;
    private Object newValue;

    public AttributeEditUndoEntry(InstanceID target, String attributeNamespace, String attributeName, Object oldValue, Object newValue) {
        this.target = target;
        this.attributeNamespace = attributeNamespace;
        this.attributeName = attributeName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setAttribute(this.attributeNamespace, this.attributeName, this.oldValue);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setAttribute(this.attributeNamespace, this.attributeName, this.newValue);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        if (!(newEntry instanceof AttributeEditUndoEntry)) {
            return null;
        }
        AttributeEditUndoEntry entry = (AttributeEditUndoEntry)newEntry;
        if (entry.target == this.target && ObjectUtilities.equal((Object)entry.attributeNamespace, (Object)this.attributeNamespace) && ObjectUtilities.equal((Object)entry.attributeName, (Object)this.attributeName)) {
            return newEntry;
        }
        return null;
    }
}

