/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;

public class EditReportConfigUndoEntry
implements UndoEntry {
    private HashMap oldConfig;
    private HashMap newConfig;

    public EditReportConfigUndoEntry(HashMap oldConfig, HashMap newConfig) {
        this.oldConfig = oldConfig;
        this.newConfig = newConfig;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        HierarchicalConfiguration configuration = (HierarchicalConfiguration)((MasterReport)renderContext.getContextRoot()).getConfiguration();
        for (Map.Entry entry : this.newConfig.entrySet()) {
            String o = (String)entry.getKey();
            configuration.setConfigProperty(o, null);
        }
        for (Map.Entry entry : this.oldConfig.entrySet()) {
            String o = (String)entry.getKey();
            configuration.setConfigProperty(o, (String)entry.getValue());
        }
        ((MasterReport)renderContext.getContextRoot()).notifyNodePropertiesChanged();
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        HierarchicalConfiguration configuration = (HierarchicalConfiguration)((MasterReport)renderContext.getContextRoot()).getConfiguration();
        for (Map.Entry entry : this.oldConfig.entrySet()) {
            String o = (String)entry.getKey();
            configuration.setConfigProperty(o, null);
        }
        for (Map.Entry entry : this.newConfig.entrySet()) {
            String o = (String)entry.getKey();
            configuration.setConfigProperty(o, (String)entry.getValue());
        }
        ((MasterReport)renderContext.getContextRoot()).notifyNodePropertiesChanged();
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

