/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class ElementEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private int position;
    private Element oldElement;
    private Element newElement;

    public ElementEditUndoEntry(InstanceID target, int position, Element oldElement, Element newElement) {
        if (position < 0) {
            throw new IllegalArgumentException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        this.target = target;
        this.position = position;
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        Band elementById = (Band)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        if (this.newElement != null) {
            elementById.removeElement(this.newElement);
        }
        if (this.oldElement != null) {
            elementById.addElement(this.position, this.oldElement);
        }
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        Band elementById = (Band)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        if (this.oldElement != null) {
            elementById.removeElement(this.oldElement);
        }
        if (this.newElement != null) {
            elementById.addElement(this.position, this.newElement);
        }
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

