/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import java.util.List;
import org.pentaho.reporting.designer.core.util.undo.MassElementStyleUndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class MassElementStyleUndoEntryBuilder {
    private ReportElement[] visualElements;
    private Object[][] styleProperties;

    public MassElementStyleUndoEntryBuilder(List<? extends Element> visualElements) {
        this.visualElements = visualElements.toArray(new ReportElement[visualElements.size()]);
        this.styleProperties = new Object[visualElements.size()][];
        for (int i = 0; i < visualElements.size(); ++i) {
            ReportElement visualElement = (ReportElement)visualElements.get(i);
            this.styleProperties[i] = MassElementStyleUndoEntryBuilder.computeStyleChangeSet(visualElement);
        }
    }

    public MassElementStyleUndoEntry finish() {
        Object[][] currentStyle = new Object[this.visualElements.length][];
        InstanceID[] targets = new InstanceID[this.visualElements.length];
        for (int i = 0; i < this.visualElements.length; ++i) {
            ReportElement visualElement = this.visualElements[i];
            currentStyle[i] = MassElementStyleUndoEntryBuilder.computeStyleChangeSet(visualElement);
            targets[i] = visualElement.getObjectID();
        }
        return new MassElementStyleUndoEntry(targets, this.styleProperties, currentStyle);
    }

    public static Object[] computeStyleChangeSet(ReportElement visualElement) {
        ElementStyleSheet styleSheet = visualElement.getStyle();
        StyleKey[] definedPropertyNamesArray = styleSheet.getDefinedPropertyNamesArray();
        Object[] retval = new Object[StyleKey.getDefinedStyleKeyCount()];
        for (int i = 0; i < definedPropertyNamesArray.length; ++i) {
            StyleKey styleKey = definedPropertyNamesArray[i];
            if (styleKey == null || !styleSheet.isLocalKey(styleKey)) continue;
            retval[styleKey.identifier] = styleSheet.getStyleProperty(styleKey);
        }
        return retval;
    }
}

