/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class SectionEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private int position;
    private Element oldElement;
    private Element newElement;

    public SectionEditUndoEntry(InstanceID target, int position, Element oldElement, Element newElement) {
        this.target = target;
        this.position = position;
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        Section elementById = (Section)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setElementAt(this.position, this.oldElement);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        Section elementById = (Section)ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.setElementAt(this.position, this.newElement);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        return null;
    }
}

