/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.undo;

import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.model.ModelUtility;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StyleEditUndoEntry
implements UndoEntry {
    private InstanceID target;
    private StyleKey styleKey;
    private Object oldValue;
    private Object newValue;

    public StyleEditUndoEntry(InstanceID target, StyleKey styleKey, Object oldValue, Object newValue) {
        this.target = target;
        this.styleKey = styleKey;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void undo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.getStyle().setStyleProperty(this.styleKey, this.oldValue);
    }

    @Override
    public void redo(ReportDocumentContext renderContext) {
        ReportElement elementById = ModelUtility.findElementById(renderContext.getReportDefinition(), this.target);
        elementById.getStyle().setStyleProperty(this.styleKey, this.newValue);
    }

    @Override
    public UndoEntry merge(UndoEntry newEntry) {
        if (!(newEntry instanceof StyleEditUndoEntry)) {
            return null;
        }
        StyleEditUndoEntry entry = (StyleEditUndoEntry)newEntry;
        if (entry.target == this.target && ObjectUtilities.equal((Object)entry.styleKey, (Object)this.styleKey)) {
            return newEntry;
        }
        return null;
    }

    public static StyleEditUndoEntry createConditional(ReportElement element, StyleKey key, Object newValue) {
        ElementStyleSheet styleSheet = element.getStyle();
        Object oldValue = styleSheet.isLocalKey(key) ? styleSheet.getStyleProperty(key) : null;
        return new StyleEditUndoEntry(element.getObjectID(), key, oldValue, newValue);
    }
}

