/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.widgets;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.Messages;
import org.pentaho.reporting.designer.core.util.ExternalToolLauncher;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;

public class HyperlinkHandler
extends MouseAdapter {
    private String url;
    private Component parent;

    public HyperlinkHandler(String url, Component parent) {
        this.url = url;
        this.parent = parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            ExternalToolLauncher.openURL(this.url);
        }
        catch (IOException ioe) {
            SwingUtilities.invokeLater(new ShowErrorMessageTask(this.parent, ioe));
        }
    }

    private static class ShowErrorMessageTask
    implements Runnable {
        private Component parent;
        private Exception exception;

        private ShowErrorMessageTask(Component parent, Exception exception) {
            this.parent = parent;
            this.exception = exception;
        }

        @Override
        public void run() {
            ExceptionDialog.showExceptionDialog((Component)this.parent, (String)Messages.getString("HyperlinkHandler.Error.Title", new Object[0]), (String)Messages.getString("HyperlinkHandler.errBrowser", this.exception.getLocalizedMessage()), (Exception)this.exception);
        }
    }
}

