/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.xul;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.DesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ToggleStateAction;
import org.pentaho.reporting.designer.core.xul.ActionSwingMenuitem;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.tags.SwingButton;

public class ActionSwingButton
extends SwingButton
implements DesignerContextComponent {
    private static final Log logger = LogFactory.getLog(ActionSwingMenuitem.class);
    private Action action;
    private String actionClass;
    private ActionChangeHandler actionChangeHandler = new ActionChangeHandler();
    private ReportDesignerContext reportDesignerContext;
    private boolean parentIsToolbar;

    public ActionSwingButton(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super(self, parent, domContainer, tagName);
        AbstractButton button = this.getButton();
        this.parentIsToolbar = this.computeParentToolbar(parent);
        if (this.parentIsToolbar) {
            button.putClientProperty("hideActionText", Boolean.TRUE);
        }
    }

    private boolean computeParentToolbar(XulComponent parent) {
        while (parent != null) {
            if (parent.getManagedObject() instanceof JToolBar) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    protected void setButton(AbstractButton button) {
        AbstractButton oldButton = this.getButton();
        oldButton.setAction(null);
        super.setButton(button);
        if (this.parentIsToolbar) {
            button.putClientProperty("hideActionText", Boolean.TRUE);
        }
        button.setAction(this.action);
    }

    protected Action getActionImpl() {
        return this.action;
    }

    public String getAction() {
        return this.actionClass;
    }

    public void setAction(String action) {
        if (this.action != null) {
            this.uninstallAction(this.action);
        }
        this.actionClass = action;
        if (this.actionClass != null) {
            this.action = (Action)ObjectUtilities.loadAndInstantiate((String)this.actionClass, ActionSwingMenuitem.class, Action.class);
        }
        if (this.action != null) {
            this.installAction(this.action);
        }
    }

    protected void setIcon(Icon icon) {
        this.getButton().setIcon(icon);
    }

    protected void uninstallAction(Action oldAction) {
        if (oldAction != null) {
            this.getButton().setAction(null);
            Object o = oldAction.getValue("AcceleratorKey");
            if (o instanceof KeyStroke) {
                KeyStroke k = (KeyStroke)o;
                this.getButton().unregisterKeyboardAction(k);
            }
            oldAction.removePropertyChangeListener(this.actionChangeHandler);
        }
    }

    protected void installAction(Action newAction) {
        if (newAction != null) {
            this.setTooltiptext((String)this.action.getValue("ShortDescription"));
            this.setLabel((String)this.action.getValue("Name"));
            this.setDisabled(!this.action.isEnabled());
            this.setIcon((Icon)this.action.getValue("SmallIcon"));
            this.getButton().setAction(newAction);
            newAction.addPropertyChangeListener(this.actionChangeHandler);
            Object o = newAction.getValue("AcceleratorKey");
            if (o instanceof KeyStroke) {
                KeyStroke k = (KeyStroke)o;
                this.getButton().registerKeyboardAction(newAction, k, 2);
            }
            if (newAction instanceof ToggleStateAction) {
                ToggleStateAction tsa = (ToggleStateAction)this.action;
                this.setSelected(tsa.isSelected());
            }
        }
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        this.reportDesignerContext = context;
        if (this.action instanceof DesignerContextAction) {
            DesignerContextAction dca = (DesignerContextAction)this.action;
            dca.setReportDesignerContext(this.reportDesignerContext);
        }
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public void setLabel(String label) {
        if (!this.parentIsToolbar) {
            super.setLabel(label);
        }
    }

    private class ActionChangeHandler
    implements PropertyChangeListener {
        private static final String ENABLED = "enabled";
        private static final String SELECTED = "selected";

        private ActionChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            try {
                String propertyName = event.getPropertyName();
                Action actionImpl = ActionSwingButton.this.getActionImpl();
                if (ENABLED.equals(propertyName)) {
                    ActionSwingButton.this.setDisabled(!actionImpl.isEnabled());
                } else if (SELECTED.equals(propertyName)) {
                    ActionSwingButton.this.setSelected(Boolean.TRUE.equals(event.getNewValue()));
                } else if (propertyName.equals("SmallIcon")) {
                    ActionSwingButton.this.setIcon((Icon)actionImpl.getValue("SmallIcon"));
                } else if (propertyName.equals("Name")) {
                    ActionSwingButton.this.setLabel((String)actionImpl.getValue("Name"));
                } else if (propertyName.equals("ShortDescription")) {
                    ActionSwingButton.this.setTooltiptext((String)actionImpl.getValue("ShortDescription"));
                }
                if (propertyName.equals("AcceleratorKey")) {
                    Object o;
                    KeyStroke oldVal = (KeyStroke)event.getOldValue();
                    if (oldVal != null) {
                        ActionSwingButton.this.getButton().unregisterKeyboardAction(oldVal);
                    }
                    if ((o = actionImpl.getValue("AcceleratorKey")) instanceof KeyStroke) {
                        KeyStroke k = (KeyStroke)o;
                        ActionSwingButton.this.getButton().registerKeyboardAction(actionImpl, k, 2);
                    }
                } else if (propertyName.equals("MnemonicKey")) {
                    Object o = actionImpl.getValue("MnemonicKey");
                    if (o != null) {
                        if (o instanceof Character) {
                            Character c = (Character)o;
                            ActionSwingButton.this.getButton().setMnemonic(c.charValue());
                        } else if (o instanceof Integer) {
                            Integer c = (Integer)o;
                            ActionSwingButton.this.getButton().setMnemonic(c);
                        }
                    } else {
                        ActionSwingButton.this.getButton().setMnemonic(-1);
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error on PropertyChange in ActionButton: ", (Throwable)e);
            }
        }
    }
}

