/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.xul;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.designer.core.DesignerContextComponent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.DesignerContextAction;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulComponent;
import org.pentaho.ui.xul.swing.SwingElement;

public class ActionSwingMenuitem
extends SwingElement
implements DesignerContextComponent,
XulMenuitem {
    private static final Log logger = LogFactory.getLog(ActionSwingMenuitem.class);
    private String image;
    private String onCommand;
    private JMenuItem menuitem;
    private Action action;
    private String actionClass;
    private ActionChangeHandler actionChangeHandler = new ActionChangeHandler();
    private ReportDesignerContext reportDesignerContext;
    public static final String RADIO_MENUITEM = "radio-menuitem";
    public static final String CHECKBOX_MENUITEM = "checkbox-menuitem";
    public static final String MENUITEM = "menuitem";

    public ActionSwingMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        this(tagName);
    }

    public ActionSwingMenuitem(String tagName) {
        super(tagName);
        this.menuitem = this.createComponent(tagName);
        this.menuitem.addActionListener(new InlineActionForward());
        this.setManagedObject(this.menuitem);
    }

    protected ActionChangeHandler getActionChangeHandler() {
        return this.actionChangeHandler;
    }

    protected void setActionChangeHandler(ActionChangeHandler actionChangeHandler) {
        this.actionChangeHandler = actionChangeHandler;
    }

    protected JMenuItem createComponent(String tagName) {
        if (RADIO_MENUITEM.equalsIgnoreCase(tagName)) {
            return new JRadioButtonMenuItem();
        }
        if (CHECKBOX_MENUITEM.equalsIgnoreCase(tagName)) {
            return new JCheckBoxMenuItem();
        }
        return new JMenuItem();
    }

    public String getAcceltext() {
        return String.valueOf(this.menuitem.getAccelerator().getKeyChar());
    }

    public String getAccesskey() {
        if (this.menuitem.getDisplayedMnemonicIndex() == -1) {
            return null;
        }
        return String.valueOf(this.menuitem.getText().charAt(this.menuitem.getDisplayedMnemonicIndex()));
    }

    public Action getActionImpl() {
        return this.action;
    }

    public String getAction() {
        return this.actionClass;
    }

    public void setAction(Action action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionChangeHandler);
            this.uninstallAction(this.action);
        }
        if (action != null) {
            this.actionClass = action.getClass().getName();
            this.action = action;
        } else {
            this.actionClass = null;
            this.action = null;
        }
        if (this.action != null) {
            this.action.addPropertyChangeListener(this.actionChangeHandler);
            this.installAction(this.action);
        }
    }

    public void setAction(String action) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionChangeHandler);
            this.uninstallAction(this.action);
        }
        this.actionClass = action;
        if (this.actionClass != null) {
            this.action = (Action)ObjectUtilities.loadAndInstantiate((String)this.actionClass, ActionSwingMenuitem.class, Action.class);
        }
        if (this.action != null) {
            this.action.addPropertyChangeListener(this.actionChangeHandler);
            this.installAction(this.action);
        }
    }

    protected void uninstallAction(Action oldAction) {
        if (oldAction != null) {
            this.menuitem.removeActionListener(oldAction);
            oldAction.removePropertyChangeListener(this.actionChangeHandler);
            Object o = oldAction.getValue("AcceleratorKey");
            if (o instanceof KeyStroke) {
                KeyStroke k = (KeyStroke)o;
                this.menuitem.unregisterKeyboardAction(k);
            }
        }
    }

    protected void installAction(Action newAction) {
        if (newAction != null) {
            this.menuitem.addActionListener(newAction);
            newAction.addPropertyChangeListener(this.actionChangeHandler);
            this.setLabel((String)newAction.getValue("Name"));
            this.setTooltiptext((String)newAction.getValue("ShortDescription"));
            this.setDisabled(!this.action.isEnabled());
            this.refreshMnemonic(newAction);
            this.refreshKeystroke(newAction);
            Object rawSelectedSwing = this.action.getValue("SwingSelectedKey");
            if (rawSelectedSwing != null) {
                this.setSelected(Boolean.TRUE.equals(rawSelectedSwing));
            } else {
                Object rawSelectedPrd = this.action.getValue("selected");
                this.setSelected(Boolean.TRUE.equals(rawSelectedPrd));
            }
            Object rawVisible = this.action.getValue("visible");
            if (rawVisible != null) {
                this.setVisible(Boolean.TRUE.equals(rawVisible));
            }
        }
    }

    @Override
    public void setReportDesignerContext(ReportDesignerContext context) {
        this.reportDesignerContext = context;
        if (this.action instanceof DesignerContextAction) {
            DesignerContextAction dca = (DesignerContextAction)this.action;
            dca.setReportDesignerContext(this.reportDesignerContext);
        }
    }

    @Override
    public ReportDesignerContext getReportDesignerContext() {
        return this.reportDesignerContext;
    }

    public boolean isDisabled() {
        return !this.menuitem.isEnabled();
    }

    public String getLabel() {
        return this.menuitem.getText();
    }

    public void setAcceltext(String accel) {
        this.menuitem.setAccelerator(KeyStroke.getKeyStroke(accel));
    }

    public void setAccesskey(String accessKey) {
        if (accessKey == null || accessKey.length() == 0) {
            this.menuitem.setMnemonic(0);
        } else {
            this.menuitem.setMnemonic(accessKey.charAt(0));
        }
    }

    public void setDisabled(boolean disabled) {
        this.menuitem.setEnabled(!disabled);
    }

    public void setDisabled(String disabled) {
        this.menuitem.setEnabled(!Boolean.parseBoolean(disabled));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.menuitem.setVisible(visible);
        XulComponent parent = this.getParent();
        if (parent instanceof AbstractXulComponent) {
            AbstractXulComponent parentComp = (AbstractXulComponent)parent;
            parentComp.layout();
        }
    }

    public void setLabel(String label) {
        this.menuitem.setText(label);
    }

    public String getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.menuitem.isSelected();
    }

    public void setSelected(boolean selected) {
        this.menuitem.setSelected(selected);
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getCommand() {
        return this.onCommand;
    }

    public void setCommand(String command) {
        this.onCommand = command;
    }

    public String toString() {
        return this.getLabel();
    }

    private void refreshKeystroke(Action actionImpl) {
        Object keyStroke = actionImpl.getValue("AcceleratorKey");
        if (!(keyStroke instanceof KeyStroke)) {
            this.setAcceltext(null);
        } else {
            this.setAcceltext(keyStroke.toString());
        }
    }

    private void refreshMnemonic(Action actionImpl) {
        Object o = actionImpl.getValue("MnemonicKey");
        if (o != null) {
            if (o instanceof Character) {
                Character c = (Character)o;
                this.setAccesskey(String.valueOf(c.charValue()));
            } else if (o instanceof Integer) {
                Integer c = (Integer)o;
                this.setAccesskey(String.valueOf(c));
            }
        } else {
            this.setAccesskey("\u0000");
        }
    }

    protected class ActionChangeHandler
    implements PropertyChangeListener {
        protected ActionChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            try {
                String propertyName = event.getPropertyName();
                Action actionImpl = ActionSwingMenuitem.this.getActionImpl();
                if ("selected".equals(propertyName) || "SwingSelectedKey".equals(propertyName)) {
                    ActionSwingMenuitem.this.setSelected(Boolean.TRUE.equals(event.getNewValue()));
                } else if ("enabled".equals(propertyName)) {
                    ActionSwingMenuitem.this.setDisabled(!actionImpl.isEnabled());
                } else if ("visible".equals(propertyName)) {
                    ActionSwingMenuitem.this.setVisible(Boolean.TRUE.equals(event.getNewValue()));
                } else if (propertyName.equals("Name")) {
                    ActionSwingMenuitem.this.setLabel((String)actionImpl.getValue("Name"));
                } else if (propertyName.equals("ShortDescription")) {
                    ActionSwingMenuitem.this.setTooltiptext((String)actionImpl.getValue("ShortDescription"));
                }
                if (propertyName.equals("AcceleratorKey")) {
                    ActionSwingMenuitem.this.refreshKeystroke(actionImpl);
                } else if (propertyName.equals("MnemonicKey")) {
                    ActionSwingMenuitem.this.refreshMnemonic(actionImpl);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Error on PropertyChange in ActionSwingMenuItem: ", (Throwable)e);
            }
        }
    }

    private class InlineActionForward
    implements ActionListener {
        protected InlineActionForward() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String command = ActionSwingMenuitem.this.getCommand();
            if (command != null) {
                ActionSwingMenuitem.this.invoke(command);
            }
        }
    }
}

