/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import javax.cache.configuration.CompleteConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;
import net.sf.ehcache.Element;
import org.ehcache.jcache.JCache;

class JCacheEntryEventAdapter<K, V>
extends CacheEntryEvent<K, V> {
    private final Element element;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public JCacheEntryEventAdapter(JCache<K, V> source, Element element, EventType eventType) {
        super(source, eventType);
        this.element = element;
        CompleteConfiguration cfg = source.getConfiguration(CompleteConfiguration.class);
        this.keyType = cfg.getKeyType();
        this.valueType = cfg.getValueType();
    }

    public K getKey() {
        return this.keyType.cast(this.element.getObjectKey());
    }

    public V getValue() {
        return this.valueType.cast(this.element.getObjectValue());
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return clazz.cast((Object)this);
        }
        if (clazz.isAssignableFrom(Element.class)) {
            return clazz.cast(this.element);
        }
        return null;
    }

    public V getOldValue() {
        if (this.isOldValueAvailable()) {
            return null;
        }
        throw new UnsupportedOperationException("The old value is not available for key " + this.getKey());
    }

    public boolean isOldValueAvailable() {
        return false;
    }
}

