/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorCopyRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableLoader;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedCreateHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinCommonOperator
extends MapJoinOperator
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinCommonOperator.class.getName());
    protected boolean isOuterJoin;
    protected byte posSingleVectorMapJoinSmallTable;
    protected VectorizationContext vContext;
    protected VectorizationContext vOutContext;
    protected int[] outputProjection;
    protected String[] outputTypeNames;
    protected VectorExpression[] bigTableFilterExpressions;
    protected VectorExpression[] bigTableKeyExpressions;
    protected VectorExpression[] bigTableValueExpressions;
    protected int[] bigTableKeyColumnMap;
    protected ArrayList<String> bigTableKeyTypeNames;
    protected int[] bigTableValueColumnMap;
    protected ArrayList<String> bigTableValueTypeNames;
    protected VectorColumnOutputMapping bigTableRetainedMapping;
    protected VectorColumnOutputMapping bigTableOuterKeyMapping;
    protected VectorColumnSourceMapping smallTableMapping;
    protected int[] smallTableOutputVectorColumns;
    protected int[] bigTableOuterKeyOutputVectorColumns;
    protected int[] bigTableByteColumnVectorColumns;
    protected int[] smallTableByteColumnVectorColumns;
    protected transient String taskName;
    protected transient boolean useOverflowRepeatedThreshold;
    protected transient int overflowRepeatedThreshold;
    protected transient VectorCopyRow bigTableRetainedVectorCopy;
    protected transient VectorCopyRow bigTableVectorCopyOuterKeys;
    protected transient VectorDeserializeRow<LazyBinaryDeserializeRead> smallTableVectorDeserializeRow;
    protected transient VectorizedRowBatch overflowBatch;
    protected transient VectorizedRowBatch spillReplayBatch;
    protected transient boolean needCommonSetup;
    protected transient boolean needHashTableSetup;
    protected transient VectorMapJoinHashTable vectorMapJoinHashTable;

    protected VectorMapJoinCommonOperator() {
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx);
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
        this.vOutContext = new VectorizationContext(this.getName(), this.vContext);
        this.order = desc.getTagOrder();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.posSingleVectorMapJoinSmallTable = this.order[0] == this.posBigTable ? this.order[1] : this.order[0];
        this.isOuterJoin = !desc.getNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(this.posBigTable);
        this.bigTableKeyExpressions = vContext.getVectorExpressions(keyDesc);
        this.bigTableKeyColumnMap = new int[this.bigTableKeyExpressions.length];
        this.bigTableKeyTypeNames = new ArrayList();
        boolean onlyColumns = true;
        for (int i = 0; i < this.bigTableKeyColumnMap.length; ++i) {
            VectorExpression ve = this.bigTableKeyExpressions[i];
            if (!IdentityExpression.isColumnOnly(ve)) {
                onlyColumns = false;
            }
            this.bigTableKeyTypeNames.add(keyDesc.get(i).getTypeString());
            this.bigTableKeyColumnMap[i] = ve.getOutputColumn();
        }
        if (onlyColumns) {
            this.bigTableKeyExpressions = null;
        }
        List<ExprNodeDesc> bigTableExprs = desc.getExprs().get(this.posBigTable);
        this.bigTableValueExpressions = vContext.getVectorExpressions(bigTableExprs);
        this.bigTableValueColumnMap = new int[this.bigTableValueExpressions.length];
        this.bigTableValueTypeNames = new ArrayList();
        onlyColumns = true;
        for (int i = 0; i < this.bigTableValueColumnMap.length; ++i) {
            VectorExpression ve = this.bigTableValueExpressions[i];
            if (!IdentityExpression.isColumnOnly(ve)) {
                onlyColumns = false;
            }
            this.bigTableValueTypeNames.add(bigTableExprs.get(i).getTypeString());
            this.bigTableValueColumnMap[i] = ve.getOutputColumn();
        }
        if (onlyColumns) {
            this.bigTableValueExpressions = null;
        }
        this.determineCommonInfo(this.isOuterJoin);
    }

    protected void determineCommonInfo(boolean isOuter) throws HiveException {
        int i;
        int smallTableIndicesSize;
        int[] smallTableIndices;
        this.bigTableRetainedMapping = new VectorColumnOutputMapping("Big Table Retained Mapping");
        this.bigTableOuterKeyMapping = new VectorColumnOutputMapping("Big Table Outer Key Mapping");
        this.smallTableMapping = new VectorColumnSourceMapping("Small Table Mapping");
        VectorColumnSourceMapping projectionMapping = new VectorColumnSourceMapping("Projection Mapping");
        List<Integer> bigTableRetainList = ((MapJoinDesc)this.conf).getRetainList().get(this.posBigTable);
        int bigTableRetainSize = bigTableRetainList.size();
        List<ExprNodeDesc> smallTableExprs = ((MapJoinDesc)this.conf).getExprs().get(this.posSingleVectorMapJoinSmallTable);
        if (((MapJoinDesc)this.conf).getValueIndices() != null && ((MapJoinDesc)this.conf).getValueIndices().get(this.posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = ((MapJoinDesc)this.conf).getValueIndices().get(this.posSingleVectorMapJoinSmallTable);
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = ((MapJoinDesc)this.conf).getRetainList().get(this.posSingleVectorMapJoinSmallTable);
        int smallTableRetainSize = smallTableRetainList.size();
        int smallTableResultSize = 0;
        if (smallTableIndicesSize > 0) {
            smallTableResultSize = smallTableIndicesSize;
        } else if (smallTableRetainSize > 0) {
            smallTableResultSize = smallTableRetainSize;
        }
        int nextOutputColumn = this.order[0] == this.posBigTable ? 0 : smallTableResultSize;
        for (int i2 = 0; i2 < bigTableRetainSize; ++i2) {
            int retainColumn = bigTableRetainList.get(i2);
            int batchColumnIndex = this.bigTableValueColumnMap[retainColumn];
            String typeName = this.bigTableValueTypeNames.get(i2);
            projectionMapping.add(nextOutputColumn, batchColumnIndex, typeName);
            if (!this.bigTableRetainedMapping.containsOutputColumn(batchColumnIndex)) {
                this.bigTableRetainedMapping.add(batchColumnIndex, batchColumnIndex, typeName);
            }
            ++nextOutputColumn;
        }
        int firstSmallTableOutputColumn = this.order[0] == this.posBigTable ? bigTableRetainSize : 0;
        int smallTableOutputCount = 0;
        nextOutputColumn = firstSmallTableOutputColumn;
        if (smallTableIndicesSize > 0) {
            smallTableOutputCount = smallTableIndicesSize;
            for (i = 0; i < smallTableIndicesSize; ++i) {
                if (smallTableIndices[i] >= 0) {
                    int keyIndex = smallTableIndices[i];
                    int batchKeyColumn = this.bigTableKeyColumnMap[keyIndex];
                    String typeName = this.bigTableKeyTypeNames.get(keyIndex);
                    if (!isOuter) {
                        projectionMapping.add(nextOutputColumn, batchKeyColumn, typeName);
                        if (!this.bigTableRetainedMapping.containsOutputColumn(batchKeyColumn)) {
                            this.bigTableRetainedMapping.add(batchKeyColumn, batchKeyColumn, typeName);
                        }
                    } else {
                        int scratchColumn = this.vOutContext.allocateScratchColumn(typeName);
                        projectionMapping.add(nextOutputColumn, scratchColumn, typeName);
                        this.bigTableRetainedMapping.add(batchKeyColumn, scratchColumn, typeName);
                        this.bigTableOuterKeyMapping.add(batchKeyColumn, scratchColumn, typeName);
                    }
                } else {
                    int smallTableValueIndex = -smallTableIndices[i] - 1;
                    String typeName = smallTableExprs.get(i).getTypeString();
                    int scratchColumn = this.vOutContext.allocateScratchColumn(typeName);
                    projectionMapping.add(nextOutputColumn, scratchColumn, typeName);
                    this.smallTableMapping.add(smallTableValueIndex, scratchColumn, typeName);
                }
                ++nextOutputColumn;
            }
        } else if (smallTableRetainSize > 0) {
            smallTableOutputCount = smallTableRetainSize;
            for (i = 0; i < smallTableRetainSize; ++i) {
                int smallTableValueIndex = smallTableRetainList.get(i);
                String typeName = smallTableExprs.get(i).getTypeString();
                int scratchColumn = this.vOutContext.allocateScratchColumn(typeName);
                projectionMapping.add(nextOutputColumn, scratchColumn, typeName);
                this.smallTableMapping.add(smallTableValueIndex, scratchColumn, typeName);
                ++nextOutputColumn;
            }
        }
        this.bigTableRetainedMapping.finalize();
        this.bigTableOuterKeyMapping.finalize();
        this.smallTableMapping.finalize();
        this.bigTableOuterKeyOutputVectorColumns = this.bigTableOuterKeyMapping.getOutputColumns();
        this.smallTableOutputVectorColumns = this.smallTableMapping.getOutputColumns();
        this.bigTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.bigTableOuterKeyMapping);
        this.smallTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.smallTableMapping);
        projectionMapping.finalize();
        assert (projectionMapping.isSourceSequenceGood());
        this.outputProjection = projectionMapping.getOutputColumns();
        this.outputTypeNames = projectionMapping.getTypeNames();
        if (this.isLogDebugEnabled) {
            int[] orderDisplayable = new int[this.order.length];
            for (int i3 = 0; i3 < this.order.length; ++i3) {
                orderDisplayable[i3] = this.order[i3].byteValue();
            }
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor order " + Arrays.toString(orderDisplayable));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor posBigTable " + this.posBigTable);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor posSingleVectorMapJoinSmallTable " + this.posSingleVectorMapJoinSmallTable);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableKeyColumnMap " + Arrays.toString(this.bigTableKeyColumnMap));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableKeyTypeNames " + this.bigTableKeyTypeNames);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableValueColumnMap " + Arrays.toString(this.bigTableValueColumnMap));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableValueTypeNames " + this.bigTableValueTypeNames);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor smallTableIndices " + Arrays.toString(smallTableIndices));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor smallTableRetainList " + smallTableRetainList);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor firstSmallTableOutputColumn " + firstSmallTableOutputColumn);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor smallTableOutputCount " + smallTableOutputCount);
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableRetainedMapping " + this.bigTableRetainedMapping.toString());
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableOuterKeyMapping " + this.bigTableOuterKeyMapping.toString());
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor smallTableMapping " + this.smallTableMapping.toString());
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor bigTableByteColumnVectorColumns " + Arrays.toString(this.bigTableByteColumnVectorColumns));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor smallTableByteColumnVectorColumns " + Arrays.toString(this.smallTableByteColumnVectorColumns));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor outputProjection " + Arrays.toString(this.outputProjection));
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor outputTypeNames " + Arrays.toString(this.outputTypeNames));
        }
        this.setupVOutContext(((MapJoinDesc)this.conf).getOutputColumnNames());
    }

    private int[] getByteColumnVectorColumns(VectorColumnMapping mapping) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = mapping.getCount();
        int[] outputColumns = mapping.getOutputColumns();
        String[] typeNames = mapping.getTypeNames();
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            String typeName = typeNames[i];
            if (!VectorizationContext.isStringFamily(typeName)) continue;
            list.add(outputColumn);
        }
        return ArrayUtils.toPrimitive(list.toArray(new Integer[0]));
    }

    protected void setupVOutContext(List<String> outputColumnNames) {
        if (this.isLogDebugEnabled) {
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor outputColumnNames " + outputColumnNames);
        }
        if (outputColumnNames.size() != this.outputProjection.length) {
            throw new RuntimeException("Output column names " + outputColumnNames + " length and output projection " + Arrays.toString(this.outputProjection) + " / " + Arrays.toString(this.outputTypeNames) + " length mismatch");
        }
        this.vOutContext.resetProjectionColumns();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            String columnName = outputColumnNames.get(i);
            int outputColumn = this.outputProjection[i];
            this.vOutContext.addProjectionColumn(columnName, outputColumn);
            if (!this.isLogDebugEnabled) continue;
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator constructor addProjectionColumn " + i + " columnName " + columnName + " outputColumn " + outputColumn);
        }
    }

    @Override
    protected HashTableLoader getHashTableLoader(Configuration hconf) {
        HashTableLoader hashTableLoader;
        VectorMapJoinDesc vectorDesc = ((MapJoinDesc)this.conf).getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = vectorDesc.hashTableImplementationType();
        switch (vectorDesc.hashTableImplementationType()) {
            case OPTIMIZED: {
                hashTableLoader = HashTableLoaderFactory.getLoader(hconf);
                break;
            }
            case FAST: {
                hashTableLoader = HiveConf.getVar(hconf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark") ? HashTableLoaderFactory.getLoader(hconf) : new VectorMapJoinFastHashTableLoader();
                break;
            }
            default: {
                throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
            }
        }
        return hashTableLoader;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        if (this.isLogDebugEnabled) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        this.overflowRepeatedThreshold = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD);
        boolean bl = this.useOverflowRepeatedThreshold = this.overflowRepeatedThreshold >= 0;
        if (this.smallTableMapping.getCount() > 0) {
            this.smallTableVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(VectorizedBatchUtil.typeInfosFromTypeNames(this.smallTableMapping.getTypeNames())));
            this.smallTableVectorDeserializeRow.init(this.smallTableMapping.getOutputColumns());
        }
        if (this.bigTableRetainedMapping.getCount() > 0) {
            this.bigTableRetainedVectorCopy = new VectorCopyRow();
            this.bigTableRetainedVectorCopy.init(this.bigTableRetainedMapping);
        }
        if (this.bigTableOuterKeyMapping.getCount() > 0) {
            this.bigTableVectorCopyOuterKeys = new VectorCopyRow();
            this.bigTableVectorCopyOuterKeys.init(this.bigTableOuterKeyMapping);
        }
        this.overflowBatch = this.setupOverflowBatch();
        this.needCommonSetup = true;
        this.needHashTableSetup = true;
        if (this.isLogDebugEnabled) {
            int[] currentScratchColumns = this.vOutContext.currentScratchColumns();
            LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator initializeOp currentScratchColumns " + Arrays.toString(currentScratchColumns));
            StructObjectInspector structOutputObjectInspector = (StructObjectInspector)this.outputObjInspector;
            List<? extends StructField> fields = structOutputObjectInspector.getAllStructFieldRefs();
            int i = 0;
            for (StructField structField : fields) {
                LOG.debug("VectorMapJoinInnerBigOnlyCommonOperator initializeOp " + i + " field " + structField.getFieldName() + " type " + structField.getFieldObjectInspector().getTypeName());
                ++i;
            }
        }
    }

    @Override
    protected void completeInitializationOp(Object[] os) throws HiveException {
        super.completeInitializationOp(os);
        VectorMapJoinDesc vectorDesc = ((MapJoinDesc)this.conf).getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = vectorDesc.hashTableImplementationType();
        switch (vectorDesc.hashTableImplementationType()) {
            case OPTIMIZED: {
                this.vectorMapJoinHashTable = VectorMapJoinOptimizedCreateHashTable.createHashTable((MapJoinDesc)this.conf, this.mapJoinTables[this.posSingleVectorMapJoinSmallTable]);
                break;
            }
            case FAST: {
                VectorMapJoinTableContainer vectorMapJoinTableContainer = (VectorMapJoinTableContainer)this.mapJoinTables[this.posSingleVectorMapJoinSmallTable];
                this.vectorMapJoinHashTable = vectorMapJoinTableContainer.vectorMapJoinHashTable();
                break;
            }
            default: {
                throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
            }
        }
    }

    protected VectorizedRowBatch setupOverflowBatch() throws HiveException {
        int initialColumnCount = this.vContext.firstOutputColumnIndex();
        int totalNumColumns = initialColumnCount + this.vOutContext.getScratchColumnTypeNames().length;
        VectorizedRowBatch overflowBatch = new VectorizedRowBatch(totalNumColumns);
        for (int i = 0; i < this.outputProjection.length; ++i) {
            int outputColumn = this.outputProjection[i];
            String typeName = this.outputTypeNames[i];
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName);
        }
        int outputColumn = initialColumnCount;
        for (String typeName : this.vOutContext.getScratchColumnTypeNames()) {
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn++, typeName);
        }
        overflowBatch.projectedColumns = this.outputProjection;
        overflowBatch.projectionSize = this.outputProjection.length;
        overflowBatch.reset();
        return overflowBatch;
    }

    private void allocateOverflowBatchColumnVector(VectorizedRowBatch overflowBatch, int outputColumn, String typeName) throws HiveException {
        if (overflowBatch.cols[outputColumn] == null) {
            typeName = VectorizationContext.mapTypeNameSynonyms(typeName);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            overflowBatch.cols[outputColumn] = VectorizedBatchUtil.createColumnVector(typeInfo);
            if (this.isLogDebugEnabled) {
                LOG.debug(this.taskName + ", " + this.getOperatorId() + " VectorMapJoinCommonOperator initializeOp overflowBatch outputColumn " + outputColumn + " class " + overflowBatch.cols[outputColumn].getClass().getSimpleName());
            }
        }
    }

    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        BytesColumnVector bytesColumnVector;
        if (this.isLogDebugEnabled) {
            LOG.debug("VectorMapJoinInnerCommonOperator commonSetup begin...");
            this.displayBatchColumns(batch, "batch");
            this.displayBatchColumns(this.overflowBatch, "overflowBatch");
        }
        for (int column : this.bigTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        for (int column : this.smallTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)batch.cols[column];
            bytesColumnVector.initBuffer();
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        this.spillReplayBatch = VectorizedBatchUtil.makeLike(batch);
    }

    protected void displayBatchColumns(VectorizedRowBatch batch, String batchName) {
        LOG.debug("commonSetup " + batchName + " column count " + batch.numCols);
        for (int column = 0; column < batch.numCols; ++column) {
            LOG.debug("commonSetup " + batchName + "     column " + column + " type " + (batch.cols[column] == null ? "NULL" : batch.cols[column].getClass().getSimpleName()));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }
}

