/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinRowBytesContainer {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinRowBytesContainer.class);
    private File parentDir;
    private File tmpFile;
    private ByteStream.Output output = new ByteStream.Output();
    private int rowBeginPos;
    private static final int OUTPUT_SIZE = 4096;
    private static final int THRESHOLD = 3272;
    private static final int INPUT_SIZE = 4096;
    private FileOutputStream fileOutputStream;
    private boolean isOpen = false;
    private byte[] readBuffer = new byte[4096];
    private byte[] largeRowBuffer;
    private int readOffset;
    private int readLength;
    private int readNextCount;
    private int readNextIndex;
    private static final int MAX_READS = 256;
    private byte[][] readNextBytes = new byte[256][];
    private int[] readNextOffsets = new int[256];
    private int[] readNextLengths = new int[256];
    private byte[] currentBytes;
    private int currentOffset;
    private int currentLength;
    private long totalWriteLength = 0L;
    private long totalReadLength = 0L;
    private FileInputStream fileInputStream;
    private final String spillLocalDirs;

    public VectorMapJoinRowBytesContainer(String spillLocalDirs) {
        this.spillLocalDirs = spillLocalDirs;
    }

    private void setupOutputFileStreams() throws IOException {
        this.parentDir = FileUtils.createLocalDirsTempFile(this.spillLocalDirs, "bytes-container", "", true);
        this.parentDir.deleteOnExit();
        this.tmpFile = File.createTempFile("BytesContainer", ".tmp", this.parentDir);
        LOG.debug("BytesContainer created temp file " + this.tmpFile.getAbsolutePath());
        this.tmpFile.deleteOnExit();
        this.fileOutputStream = new FileOutputStream(this.tmpFile);
    }

    private void initFile() {
        try {
            this.setupOutputFileStreams();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary output file on disk", e);
        }
    }

    public ByteStream.Output getOuputForRowBytes() {
        if (!this.isOpen) {
            this.initFile();
            this.isOpen = true;
        }
        this.output.reserve(4);
        this.rowBeginPos = this.output.getLength();
        return this.output;
    }

    public void finishRow() throws IOException {
        int length = this.output.getLength() - this.rowBeginPos;
        this.output.writeInt(this.rowBeginPos - 4, length);
        if (this.output.getLength() > 3272) {
            this.fileOutputStream.write(this.output.getData(), 0, this.output.getLength());
            this.totalWriteLength += (long)this.output.getLength();
            this.output.reset();
        }
    }

    public void prepareForReading() throws IOException {
        if (!this.isOpen) {
            return;
        }
        if (this.output.getLength() > 0) {
            this.fileOutputStream.write(this.output.getData(), 0, this.output.getLength());
            this.totalWriteLength += (long)this.output.getLength();
            this.fileOutputStream.flush();
            this.output.reset();
        }
        if (this.fileInputStream != null) {
            this.fileInputStream.close();
        }
        this.fileInputStream = new FileInputStream(this.tmpFile);
        this.readNextIndex = 0;
        this.readNextCount = 0;
    }

    private int readInt() {
        int value = (this.readBuffer[this.readOffset] & 0xFF) << 24 | (this.readBuffer[this.readOffset + 1] & 0xFF) << 16 | (this.readBuffer[this.readOffset + 2] & 0xFF) << 8 | this.readBuffer[this.readOffset + 3] & 0xFF;
        this.readOffset += 4;
        return value;
    }

    private void bufferedRead() throws IOException {
        this.readNextIndex = 0;
        this.readNextCount = 0;
        if (this.readOffset < this.readLength) {
            int unprocessLength = this.readLength - this.readOffset;
            System.arraycopy(this.readBuffer, this.readOffset, this.readBuffer, 0, unprocessLength);
            int maxReadLength = this.readBuffer.length - unprocessLength;
            int partialReadLength = this.fileInputStream.read(this.readBuffer, unprocessLength, maxReadLength);
            if (partialReadLength == -1) {
                partialReadLength = 0;
            }
            this.totalReadLength += (long)partialReadLength;
            this.readLength = unprocessLength + partialReadLength;
            this.readOffset = 0;
        } else {
            this.readOffset = 0;
            this.readLength = this.fileInputStream.read(this.readBuffer, 0, this.readBuffer.length);
            if (this.readLength == -1) {
                this.readLength = 0;
            }
            this.totalReadLength += (long)this.readLength;
        }
        if (this.readLength == 0) {
            return;
        }
        if (this.readLength < 0) {
            throw new IOException("Negative read length");
        }
        if (this.readLength < 4) {
            throw new IOException("Expecting 4 byte length");
        }
        do {
            int saveReadOffset = this.readOffset;
            int rowLength = this.readInt();
            if (rowLength < 0) {
                throw new IOException("Negative row length");
            }
            int remainingLength = this.readLength - this.readOffset;
            if (remainingLength < rowLength) {
                if (this.readNextCount > 0) {
                    this.readOffset = saveReadOffset;
                } else {
                    if (this.largeRowBuffer == null || this.largeRowBuffer.length < rowLength) {
                        int newLargeBufferLength = Math.max(Integer.highestOneBit(rowLength) << 1, 4096);
                        this.largeRowBuffer = new byte[newLargeBufferLength];
                    }
                    System.arraycopy(this.readBuffer, this.readOffset, this.largeRowBuffer, 0, remainingLength);
                    int expectedPartialLength = rowLength - remainingLength;
                    int partialReadLength = this.fileInputStream.read(this.largeRowBuffer, remainingLength, expectedPartialLength);
                    if (partialReadLength == -1) {
                        throw new IOException("Unexpected EOF (total write length " + this.totalWriteLength + ", total read length " + this.totalReadLength + ", read length " + expectedPartialLength + ")");
                    }
                    if (expectedPartialLength != partialReadLength) {
                        throw new IOException("Unable to read a complete row of length " + rowLength + " (total write length " + this.totalWriteLength + ", total read length " + this.totalReadLength + ", read length " + expectedPartialLength + ", actual length " + partialReadLength + ")");
                    }
                    this.totalReadLength += (long)partialReadLength;
                    this.readNextBytes[this.readNextCount] = this.largeRowBuffer;
                    this.readNextOffsets[this.readNextCount] = 0;
                    this.readNextLengths[this.readNextCount] = rowLength;
                    this.readOffset = this.readLength;
                    ++this.readNextCount;
                }
                break;
            }
            this.readNextBytes[this.readNextCount] = this.readBuffer;
            this.readNextOffsets[this.readNextCount] = this.readOffset;
            this.readNextLengths[this.readNextCount] = rowLength;
            this.readOffset += rowLength;
            ++this.readNextCount;
        } while (this.readNextCount < this.readNextBytes.length && this.readLength - this.readOffset >= 4);
    }

    public boolean readNext() throws IOException {
        if (!this.isOpen) {
            return false;
        }
        if (this.readNextIndex >= this.readNextCount) {
            this.bufferedRead();
            if (this.readNextIndex >= this.readNextCount) {
                return false;
            }
        }
        this.currentBytes = this.readNextBytes[this.readNextIndex];
        this.currentOffset = this.readNextOffsets[this.readNextIndex];
        this.currentLength = this.readNextLengths[this.readNextIndex];
        ++this.readNextIndex;
        return true;
    }

    public byte[] currentBytes() {
        return this.currentBytes;
    }

    public int currentOffset() {
        return this.currentOffset;
    }

    public int currentLength() {
        return this.currentLength;
    }

    public void clear() {
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.fileInputStream = null;
        }
        if (this.fileOutputStream != null) {
            try {
                this.fileOutputStream.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.fileOutputStream = null;
        }
        if (this.parentDir != null) {
            try {
                FileUtil.fullyDelete((File)this.parentDir);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.parentDir = null;
        this.tmpFile = null;
        this.isOpen = false;
        this.totalWriteLength = 0L;
    }
}

