/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.orc.LocalCache;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.apache.orc.FileMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalCache
implements OrcInputFormat.FooterCache {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalCache.class);
    private static boolean isDebugEnabled = LOG.isDebugEnabled();
    private final LocalCache localCache;
    private final ExternalFooterCachesByConf externalCacheSrc;
    private boolean isWarnLogged = false;
    private HiveConf conf;
    private boolean isInTest;
    private SearchArgument sarg;
    private ByteBuffer sargIsOriginal;
    private ByteBuffer sargNotIsOriginal;
    private boolean isPpdEnabled;

    public ExternalCache(LocalCache lc, ExternalFooterCachesByConf efcf) {
        this.localCache = lc;
        this.externalCacheSrc = efcf;
    }

    @Override
    public void put(Long fileId, FileStatus file, FileMetaInfo fileMetaInfo, Reader orcReader) throws IOException {
        this.localCache.put(fileId, file, fileMetaInfo, orcReader);
        if (fileId != null) {
            try {
                this.externalCacheSrc.getCache(this.conf).putFileMetadata(Lists.newArrayList(fileId), Lists.newArrayList(((ReaderImpl)orcReader).getSerializedFileFooter()));
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public boolean hasPpd() {
        return this.isPpdEnabled;
    }

    public void configure(HiveConf queryConfig) {
        this.conf = queryConfig;
        this.sarg = ConvertAstToSearchArg.createFromConf(this.conf);
        this.isPpdEnabled = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEOPTINDEXFILTER) && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_ORC_MS_FOOTER_CACHE_PPD);
        this.isInTest = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST);
        this.sargNotIsOriginal = null;
        this.sargIsOriginal = null;
    }

    @Override
    public void getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files, boolean isOriginal, OrcInputFormat.FileInfo[] result, ByteBuffer[] ppdResult) throws IOException, HiveException {
        assert (result.length == files.size());
        assert (ppdResult == null || ppdResult.length == files.size());
        this.localCache.getAndValidate(files, isOriginal, result, ppdResult);
        HashMap<Long, Integer> posMap = new HashMap<Long, Integer>();
        List<Long> fileIds = this.determineFileIdsToQuery(files, result, posMap);
        ExternalFooterCachesByConf.Cache cache = this.externalCacheSrc.getCache(this.conf);
        ByteBuffer serializedSarg = null;
        if (this.isPpdEnabled) {
            serializedSarg = this.getSerializedSargForMetastore(isOriginal);
        }
        if (serializedSarg != null) {
            Iterator<Map.Entry<Long, MetadataPpdResult>> iter = cache.getFileMetadataByExpr(fileIds, serializedSarg, false);
            while (iter.hasNext()) {
                Map.Entry<Long, MetadataPpdResult> e = iter.next();
                int ix = this.getAndVerifyIndex(posMap, files, result, e.getKey());
                this.processPpdResult(e.getValue(), files.get(ix), ix, result, ppdResult);
            }
        } else {
            ArrayList<Long> corruptIds = null;
            Iterator<Map.Entry<Long, ByteBuffer>> iter = cache.getFileMetadata(fileIds);
            while (iter.hasNext()) {
                Map.Entry<Long, ByteBuffer> e = iter.next();
                int ix = this.getAndVerifyIndex(posMap, files, result, e.getKey());
                if (this.processBbResult(e.getValue(), ix, files.get(ix), result)) continue;
                if (corruptIds == null) {
                    corruptIds = new ArrayList<Long>();
                }
                corruptIds.add(e.getKey());
            }
            if (corruptIds != null) {
                cache.clearFileMetadata(corruptIds);
            }
        }
    }

    private int getAndVerifyIndex(HashMap<Long, Integer> posMap, List<HadoopShims.HdfsFileStatusWithId> files, OrcInputFormat.FileInfo[] result, Long fileId) {
        int ix = posMap.get(fileId);
        assert (result[ix] == null);
        assert (fileId != null && fileId.equals(files.get(ix).getFileId()));
        return ix;
    }

    private boolean processBbResult(ByteBuffer bb, int ix, HadoopShims.HdfsFileStatusWithId file, OrcInputFormat.FileInfo[] result) throws IOException {
        if (bb == null) {
            return true;
        }
        result[ix] = ExternalCache.createFileInfoFromMs(file, bb);
        if (result[ix] == null) {
            return false;
        }
        this.localCache.put(file.getFileStatus().getPath(), result[ix]);
        return true;
    }

    private void processPpdResult(MetadataPpdResult mpr, HadoopShims.HdfsFileStatusWithId file, int ix, OrcInputFormat.FileInfo[] result, ByteBuffer[] ppdResult) throws IOException {
        if (mpr == null) {
            return;
        }
        ByteBuffer byteBuffer = ppdResult[ix] = mpr.isSetIncludeBitset() ? mpr.bufferForIncludeBitset() : NO_SPLIT_AFTER_PPD;
        if (mpr.isSetMetadata()) {
            result[ix] = ExternalCache.createFileInfoFromMs(file, mpr.bufferForMetadata());
            if (result[ix] != null) {
                this.localCache.put(file.getFileStatus().getPath(), result[ix]);
            }
        }
    }

    private List<Long> determineFileIdsToQuery(List<HadoopShims.HdfsFileStatusWithId> files, OrcInputFormat.FileInfo[] result, HashMap<Long, Integer> posMap) {
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != null) continue;
            HadoopShims.HdfsFileStatusWithId file = files.get(i);
            FileStatus fs = file.getFileStatus();
            Long fileId = file.getFileId();
            if (fileId == null) {
                if (!this.isInTest) {
                    if (this.isWarnLogged && !isDebugEnabled) continue;
                    LOG.warn("Not using metastore cache because fileId is missing: " + fs.getPath());
                    this.isWarnLogged = true;
                    continue;
                }
                fileId = this.generateTestFileId(fs, files, i);
                LOG.info("Generated file ID " + fileId + " at " + i);
            }
            posMap.put(fileId, i);
        }
        return Lists.newArrayList(posMap.keySet());
    }

    private Long generateTestFileId(final FileStatus fs, List<HadoopShims.HdfsFileStatusWithId> files, int i) {
        final Long fileId = HdfsUtils.createFileId(fs.getPath().toUri().getPath(), fs, false, null);
        files.set(i, new HadoopShims.HdfsFileStatusWithId(){

            @Override
            public FileStatus getFileStatus() {
                return fs;
            }

            @Override
            public Long getFileId() {
                return fileId;
            }
        });
        return fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getSerializedSargForMetastore(boolean isOriginal) {
        ByteBuffer serializedSarg;
        if (this.sarg == null) {
            return null;
        }
        ByteBuffer byteBuffer = serializedSarg = isOriginal ? this.sargIsOriginal : this.sargNotIsOriginal;
        if (serializedSarg != null) {
            return serializedSarg;
        }
        SearchArgument sarg2 = this.sarg;
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            if ((isOriginal ? this.sargNotIsOriginal : this.sargIsOriginal) == null) {
                sarg2 = kryo.copy(sarg2);
            }
            ExternalCache.translateSargToTableColIndexes(sarg2, this.conf, OrcInputFormat.getRootColumn(isOriginal));
            Baos baos = new Baos();
            Output output = new Output(baos);
            kryo.writeObject(output, sarg2);
            output.flush();
            serializedSarg = baos.get();
            if (isOriginal) {
                this.sargIsOriginal = serializedSarg;
            } else {
                this.sargNotIsOriginal = serializedSarg;
            }
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        return serializedSarg;
    }

    public static void translateSargToTableColIndexes(SearchArgument sarg, Configuration conf, int rootColumn) {
        String[] idStrs;
        String nameStr = OrcInputFormat.getNeededColumnNamesString(conf);
        String idStr = OrcInputFormat.getSargColumnIDsString(conf);
        String[] knownNames = nameStr.split(",");
        String[] stringArray = idStrs = idStr == null ? null : idStr.split(",");
        assert (idStrs == null || knownNames.length == idStrs.length);
        HashMap<String, Integer> nameIdMap = new HashMap<String, Integer>();
        for (int i = 0; i < knownNames.length; ++i) {
            Integer newId = idStrs != null ? Integer.parseInt(idStrs[i]) : i;
            Integer oldId = nameIdMap.put(knownNames[i], newId);
            if (oldId == null || oldId.intValue() == newId.intValue()) continue;
            throw new RuntimeException("Multiple IDs for " + knownNames[i] + " in column strings: [" + idStr + "], [" + nameStr + "]");
        }
        List<PredicateLeaf> leaves = sarg.getLeaves();
        for (int i = 0; i < leaves.size(); ++i) {
            PredicateLeaf pl = leaves.get(i);
            Integer colId = (Integer)nameIdMap.get(pl.getColumnName());
            String newColName = RecordReaderImpl.encodeTranslatedSargColumn(rootColumn, colId);
            SearchArgumentFactory.setPredicateLeafColumn(pl, newColName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("SARG translated into " + sarg);
        }
    }

    private static OrcInputFormat.FileInfo createFileInfoFromMs(HadoopShims.HdfsFileStatusWithId file, ByteBuffer bb) throws IOException {
        if (bb == null) {
            return null;
        }
        FileStatus fs = file.getFileStatus();
        ReaderImpl.FooterInfo fi = null;
        ByteBuffer copy = bb.duplicate();
        try {
            fi = ReaderImpl.extractMetaInfoFromFooter(copy, fs.getPath());
        }
        catch (Exception ex) {
            byte[] data = new byte[bb.remaining()];
            System.arraycopy(bb.array(), bb.arrayOffset() + bb.position(), data, 0, data.length);
            String msg = "Failed to parse the footer stored in cache for file ID " + file.getFileId() + " " + bb + " [ " + Hex.encodeHexString((byte[])data) + " ]";
            LOG.error(msg, (Throwable)ex);
            return null;
        }
        return new OrcInputFormat.FileInfo(fs.getModificationTime(), fs.getLen(), fi.getStripes(), fi.getMetadata(), fi.getFooter().getTypesList(), fi.getFooter().getStatisticsList(), fi.getFileMetaInfo(), fi.getFileMetaInfo().writerVersion, file.getFileId());
    }

    public static interface ExternalFooterCachesByConf {
        public Cache getCache(HiveConf var1) throws IOException;

        public static interface Cache {
            public Iterator<Map.Entry<Long, MetadataPpdResult>> getFileMetadataByExpr(List<Long> var1, ByteBuffer var2, boolean var3) throws HiveException;

            public void clearFileMetadata(List<Long> var1) throws HiveException;

            public Iterator<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> var1) throws HiveException;

            public void putFileMetadata(ArrayList<Long> var1, ArrayList<ByteBuffer> var2) throws HiveException;
        }
    }

    private static final class Baos
    extends ByteArrayOutputStream {
        private Baos() {
        }

        public ByteBuffer get() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }
}

