/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.pcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.pcr.PcrExprProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartExprEvalUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcrExprProcFactory {
    public static final Logger LOG = LoggerFactory.getLogger((String)PcrExprProcFactory.class.getName());

    static Object evalExprWithPart(ExprNodeDesc expr, Partition p, List<VirtualColumn> vcs) throws SemanticException {
        StructObjectInspector rowObjectInspector;
        Table tbl = p.getTable();
        try {
            rowObjectInspector = (StructObjectInspector)tbl.getDeserializer().getObjectInspector();
        }
        catch (SerDeException e) {
            throw new SemanticException(e);
        }
        try {
            return PartExprEvalUtils.evalExprWithPart(expr, p, vcs, rowObjectInspector);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
    }

    static Boolean ifResultsAgree(Boolean[] resultVector) {
        Boolean result = null;
        for (Boolean b : resultVector) {
            if (b == null) {
                return null;
            }
            if (result == null) {
                result = b;
                continue;
            }
            if (result.equals(b)) continue;
            return null;
        }
        return result;
    }

    static Object ifResultsAgree(Object[] resultVector) {
        Object result = null;
        for (Object b : resultVector) {
            if (b == null) {
                return null;
            }
            if (result == null) {
                result = b;
                continue;
            }
            if (result.equals(b)) continue;
            return null;
        }
        return result;
    }

    static NodeInfoWrapper getResultWrapFromResults(Boolean[] results, ExprNodeGenericFuncDesc fd, Object[] nodeOutputs) {
        Boolean ifAgree = PcrExprProcFactory.ifResultsAgree(results);
        if (ifAgree == null) {
            return new NodeInfoWrapper(WalkState.DIVIDED, results, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
        }
        if (ifAgree.booleanValue()) {
            return new NodeInfoWrapper(WalkState.TRUE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.TRUE));
        }
        return new NodeInfoWrapper(WalkState.FALSE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.FALSE));
    }

    private PcrExprProcFactory() {
    }

    static Boolean opAnd(Boolean ... ops) {
        boolean anyNull = false;
        for (Boolean op : ops) {
            if (op == null) {
                anyNull = true;
                continue;
            }
            if (!op.equals(Boolean.FALSE)) continue;
            return Boolean.FALSE;
        }
        if (anyNull) {
            return null;
        }
        return Boolean.TRUE;
    }

    static Boolean opOr(Boolean ... ops) {
        boolean anyNull = false;
        for (Boolean op : ops) {
            if (op == null) {
                anyNull = true;
                continue;
            }
            if (!op.equals(Boolean.TRUE)) continue;
            return Boolean.TRUE;
        }
        if (anyNull) {
            return null;
        }
        return Boolean.FALSE;
    }

    static Boolean opNot(Boolean op) {
        if (op != null) {
            if (op.equals(Boolean.TRUE)) {
                return Boolean.FALSE;
            }
            if (op.equals(Boolean.FALSE)) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static ExprNodeGenericFuncDesc getOutExpr(ExprNodeGenericFuncDesc funcExpr, Object[] nodeOutputs) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        if (nodeOutputs != null) {
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                children.add(wrapper.outExpr);
            }
        }
        funcExpr.setChildren(children);
        return funcExpr;
    }

    public static NodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static NodeProcessor getGenericFuncProcessor() {
        return new GenericFuncExprProcessor();
    }

    public static NodeProcessor getFieldProcessor() {
        return new FieldExprProcessor();
    }

    public static NodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    public static NodeInfoWrapper walkExprTree(String tabAlias, ArrayList<Partition> parts, List<VirtualColumn> vcs, ExprNodeDesc pred) throws SemanticException {
        PcrExprProcCtx pprCtx = new PcrExprProcCtx(tabAlias, parts, vcs);
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeColumnDesc.class.getName() + "%"), PcrExprProcFactory.getColumnProcessor());
        exprRules.put(new RuleRegExp("R2", ExprNodeFieldDesc.class.getName() + "%"), PcrExprProcFactory.getFieldProcessor());
        exprRules.put(new RuleRegExp("R5", ExprNodeGenericFuncDesc.class.getName() + "%"), PcrExprProcFactory.getGenericFuncProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(PcrExprProcFactory.getDefaultExprProcessor(), exprRules, pprCtx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return (NodeInfoWrapper)outputMap.get(pred);
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (nd instanceof ExprNodeConstantDesc) {
                return new NodeInfoWrapper(WalkState.CONSTANT, null, (ExprNodeDesc)nd);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, (ExprNodeDesc)nd);
        }
    }

    public static class FieldExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeFieldDesc fnd = (ExprNodeFieldDesc)nd;
            boolean unknown = false;
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                if (wrapper.state != WalkState.UNKNOWN) continue;
                unknown = true;
                break;
            }
            if (unknown) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, fnd);
            }
            return new NodeInfoWrapper(WalkState.CONSTANT, null, fnd);
        }
    }

    public static class GenericFuncExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            PcrExprProcCtx ctx = (PcrExprProcCtx)procCtx;
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)nd;
            if (FunctionRegistry.isOpNot(fd)) {
                assert (nodeOutputs.length == 1);
                NodeInfoWrapper wrapper = (NodeInfoWrapper)nodeOutputs[0];
                if (wrapper.state == WalkState.TRUE) {
                    ExprNodeConstantDesc falseDesc = new ExprNodeConstantDesc(wrapper.outExpr.getTypeInfo(), Boolean.FALSE);
                    return new NodeInfoWrapper(WalkState.FALSE, null, falseDesc);
                }
                if (wrapper.state == WalkState.FALSE) {
                    ExprNodeConstantDesc trueDesc = new ExprNodeConstantDesc(wrapper.outExpr.getTypeInfo(), Boolean.TRUE);
                    return new NodeInfoWrapper(WalkState.TRUE, null, trueDesc);
                }
                if (wrapper.state == WalkState.DIVIDED) {
                    Boolean[] results = new Boolean[ctx.getPartList().size()];
                    for (int i = 0; i < ctx.getPartList().size(); ++i) {
                        results[i] = PcrExprProcFactory.opNot(wrapper.ResultVector[i]);
                    }
                    return new NodeInfoWrapper(WalkState.DIVIDED, results, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
                }
                return new NodeInfoWrapper(wrapper.state, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            if (FunctionRegistry.isOpAnd(fd)) {
                boolean anyUnknown = false;
                boolean allDivided = true;
                ArrayList<NodeInfoWrapper> newNodeOutputsList = new ArrayList<NodeInfoWrapper>(nodeOutputs.length);
                for (int i = 0; i < nodeOutputs.length; ++i) {
                    NodeInfoWrapper c = (NodeInfoWrapper)nodeOutputs[i];
                    if (c.state == WalkState.FALSE) {
                        return c;
                    }
                    if (c.state == WalkState.UNKNOWN) {
                        anyUnknown = true;
                    }
                    if (c.state != WalkState.DIVIDED) {
                        allDivided = false;
                    }
                    if (c.state == WalkState.TRUE) continue;
                    newNodeOutputsList.add(c);
                }
                if (newNodeOutputsList.size() == 0) {
                    return new NodeInfoWrapper(WalkState.TRUE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.TRUE));
                }
                if (newNodeOutputsList.size() == 1) {
                    return newNodeOutputsList.get(0);
                }
                Object[] newNodeOutputs = newNodeOutputsList.toArray();
                if (anyUnknown) {
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
                }
                if (allDivided) {
                    Boolean[] results = new Boolean[ctx.getPartList().size()];
                    for (int i = 0; i < ctx.getPartList().size(); ++i) {
                        Boolean[] andArray = new Boolean[newNodeOutputs.length];
                        for (int j = 0; j < newNodeOutputs.length; ++j) {
                            andArray[j] = ((NodeInfoWrapper)newNodeOutputs[j]).ResultVector[i];
                        }
                        results[i] = PcrExprProcFactory.opAnd(andArray);
                    }
                    return PcrExprProcFactory.getResultWrapFromResults(results, fd, newNodeOutputs);
                }
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
            }
            if (FunctionRegistry.isOpOr(fd)) {
                boolean anyUnknown = false;
                boolean allDivided = true;
                ArrayList<NodeInfoWrapper> newNodeOutputsList = new ArrayList<NodeInfoWrapper>(nodeOutputs.length);
                for (int i = 0; i < nodeOutputs.length; ++i) {
                    NodeInfoWrapper c = (NodeInfoWrapper)nodeOutputs[i];
                    if (c.state == WalkState.TRUE) {
                        return c;
                    }
                    if (c.state == WalkState.UNKNOWN) {
                        anyUnknown = true;
                    }
                    if (c.state != WalkState.DIVIDED) {
                        allDivided = false;
                    }
                    if (c.state == WalkState.FALSE) continue;
                    newNodeOutputsList.add(c);
                }
                if (newNodeOutputsList.size() == 0) {
                    return new NodeInfoWrapper(WalkState.FALSE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.FALSE));
                }
                if (newNodeOutputsList.size() == 1) {
                    return newNodeOutputsList.get(0);
                }
                Object[] newNodeOutputs = newNodeOutputsList.toArray();
                if (anyUnknown) {
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
                }
                if (allDivided) {
                    Boolean[] results = new Boolean[ctx.getPartList().size()];
                    for (int i = 0; i < ctx.getPartList().size(); ++i) {
                        Boolean[] orArray = new Boolean[newNodeOutputs.length];
                        for (int j = 0; j < newNodeOutputs.length; ++j) {
                            orArray[j] = ((NodeInfoWrapper)newNodeOutputs[j]).ResultVector[i];
                        }
                        results[i] = PcrExprProcFactory.opOr(orArray);
                    }
                    return PcrExprProcFactory.getResultWrapFromResults(results, fd, newNodeOutputs);
                }
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
            }
            if (FunctionRegistry.isIn(fd)) {
                List<ExprNodeDesc> children = fd.getChildren();
                boolean removePredElem = false;
                ExprNodeDesc lhs = children.get(0);
                if (lhs instanceof ExprNodeColumnDesc) {
                    if (((ExprNodeColumnDesc)lhs).getIsPartitionColOrVirtualCol()) {
                        removePredElem = true;
                    }
                    if (removePredElem) {
                        for (int i = 1; i < children.size(); ++i) {
                            if (!(children.get(i) instanceof ExprNodeDynamicListDesc)) continue;
                            removePredElem = false;
                            break;
                        }
                    }
                } else if (lhs instanceof ExprNodeGenericFuncDesc && FunctionRegistry.isDeterministic(((ExprNodeGenericFuncDesc)lhs).getGenericUDF())) {
                    boolean hasOnlyPartCols = true;
                    boolean hasDynamicListDesc = false;
                    for (ExprNodeDesc ed : ((ExprNodeGenericFuncDesc)lhs).getChildren()) {
                        if (ed instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)ed).getIsPartitionColOrVirtualCol()) continue;
                        hasOnlyPartCols = false;
                        break;
                    }
                    if (hasOnlyPartCols) {
                        for (int i = 1; i < children.size(); ++i) {
                            if (!(children.get(i) instanceof ExprNodeDynamicListDesc)) continue;
                            hasDynamicListDesc = true;
                            break;
                        }
                    }
                    removePredElem = hasOnlyPartCols && !hasDynamicListDesc;
                }
                return removePredElem ? new NodeInfoWrapper(WalkState.TRUE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.TRUE)) : new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            if (!FunctionRegistry.isDeterministic(fd.getGenericUDF())) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            boolean has_part_col = false;
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                if (wrapper.state == WalkState.UNKNOWN) {
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
                }
                if (wrapper.state != WalkState.PART_COL) continue;
                has_part_col = true;
            }
            if (has_part_col && fd.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                int i;
                Object[] results;
                if (fd.getTypeInfo().equals(TypeInfoFactory.booleanTypeInfo)) {
                    results = new Boolean[ctx.getPartList().size()];
                    for (i = 0; i < ctx.getPartList().size(); ++i) {
                        results[i] = (Boolean)PcrExprProcFactory.evalExprWithPart(fd, ctx.getPartList().get(i), ctx.getVirtualColumns());
                    }
                    return PcrExprProcFactory.getResultWrapFromResults((Boolean[])results, fd, nodeOutputs);
                }
                results = new Object[ctx.getPartList().size()];
                for (i = 0; i < ctx.getPartList().size(); ++i) {
                    results[i] = PcrExprProcFactory.evalExprWithPart(fd, ctx.getPartList().get(i), ctx.getVirtualColumns());
                }
                Object result = PcrExprProcFactory.ifResultsAgree(results);
                if (result == null) {
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
                }
                return new NodeInfoWrapper(WalkState.CONSTANT, null, new ExprNodeConstantDesc(fd.getTypeInfo(), result));
            }
            ExprNodeGenericFuncDesc desc = PcrExprProcFactory.getOutExpr(fd, nodeOutputs);
            ExprNodeDesc foldedDesc = ConstantPropagateProcFactory.foldExpr(desc);
            if (foldedDesc != null && foldedDesc instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)foldedDesc;
                if (Boolean.TRUE.equals(constant.getValue())) {
                    return new NodeInfoWrapper(WalkState.TRUE, null, constant);
                }
                if (Boolean.FALSE.equals(constant.getValue())) {
                    return new NodeInfoWrapper(WalkState.FALSE, null, constant);
                }
                return new NodeInfoWrapper(WalkState.CONSTANT, null, constant);
            }
            return new NodeInfoWrapper(WalkState.CONSTANT, null, desc);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeColumnDesc cd = (ExprNodeColumnDesc)nd;
            PcrExprProcCtx epc = (PcrExprProcCtx)procCtx;
            if (cd.getTabAlias().equalsIgnoreCase(epc.getTabAlias()) && cd.getIsPartitionColOrVirtualCol()) {
                return new NodeInfoWrapper(WalkState.PART_COL, null, cd);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, cd);
        }
    }

    public static class NodeInfoWrapper {
        WalkState state;
        public Boolean[] ResultVector;
        public ExprNodeDesc outExpr;

        public NodeInfoWrapper(WalkState state, Boolean[] resultVector, ExprNodeDesc outExpr) {
            this.state = state;
            this.ResultVector = resultVector;
            this.outExpr = outExpr;
        }
    }

    public static enum WalkState {
        PART_COL,
        TRUE,
        FALSE,
        CONSTANT,
        UNKNOWN,
        DIVIDED;

    }
}

