/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ColumnStatsAutoGatherContext {
    public BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    private final List<LoadFileDesc> loadFileWork = new ArrayList<LoadFileDesc>();
    private final SemanticAnalyzer sa;
    private final HiveConf conf;
    private final Operator<? extends OperatorDesc> op;
    private final List<FieldSchema> columns;
    private final List<FieldSchema> partitionColumns;
    private boolean isInsertInto;
    private Table tbl;
    private Map<String, String> partSpec;

    public ColumnStatsAutoGatherContext(SemanticAnalyzer sa, HiveConf conf, Operator<? extends OperatorDesc> op, Table tbl, Map<String, String> partSpec, boolean isInsertInto) throws SemanticException {
        this.sa = sa;
        this.conf = conf;
        this.op = op;
        this.tbl = tbl;
        this.partSpec = partSpec;
        this.isInsertInto = isInsertInto;
        this.columns = tbl.getCols();
        this.partitionColumns = tbl.getPartCols();
    }

    public List<LoadFileDesc> getLoadFileWork() {
        return this.loadFileWork;
    }

    public BaseSemanticAnalyzer.AnalyzeRewriteContext getAnalyzeRewrite() {
        return this.analyzeRewrite;
    }

    public void setAnalyzeRewrite(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite) {
        this.analyzeRewrite = analyzeRewrite;
    }

    public void insertAnalyzePipeline() throws SemanticException {
        String analyzeCommand = "analyze table `" + this.tbl.getDbName() + "`.`" + this.tbl.getTableName() + "`" + " compute statistics for columns ";
        Operator selOp = null;
        try {
            selOp = this.genSelOpForAnalyze(analyzeCommand);
        }
        catch (IOException | ParseException e) {
            throw new SemanticException(e);
        }
        this.op.getChildOperators().add(selOp);
        selOp.getParentOperators().clear();
        selOp.getParentOperators().add(this.op);
        try {
            this.replaceSelectOperatorProcess((SelectOperator)selOp, this.op);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
    }

    private Operator genSelOpForAnalyze(String analyzeCommand) throws IOException, ParseException, SemanticException {
        Context ctx = new Context(this.conf);
        ParseDriver pd = new ParseDriver();
        ASTNode tree = pd.parse(analyzeCommand, ctx);
        tree = ParseUtils.findRootNonNullToken(tree);
        BaseSemanticAnalyzer baseSem = SemanticAnalyzerFactory.get(new QueryState(this.conf), tree);
        ColumnStatsSemanticAnalyzer colSem = (ColumnStatsSemanticAnalyzer)baseSem;
        ASTNode ast = colSem.rewriteAST(tree, this);
        baseSem = SemanticAnalyzerFactory.get(new QueryState(this.conf), ast);
        SemanticAnalyzer sem = (SemanticAnalyzer)baseSem;
        QB qb = new QB(null, null, false);
        ASTNode child = ast;
        ParseContext subPCtx = sem.getParseContext();
        subPCtx.setContext(ctx);
        sem.initParseCtx(subPCtx);
        sem.doPhase1(child, qb, sem.initPhase1Ctx(), null);
        sem.getMetaData(qb);
        Operator<OperatorDesc> operator = sem.genPlan(qb);
        this.loadFileWork.addAll(sem.getLoadFileWork());
        if (sem.topOps.values().size() != 1) {
            throw new SemanticException("ColumnStatsAutoGatherContext is expecting exactly one TS, but finds " + sem.topOps.values().size());
        }
        operator = sem.topOps.values().iterator().next();
        while (!(operator instanceof SelectOperator)) {
            operator = operator.getChildOperators().get(0);
        }
        return operator;
    }

    private void replaceSelectOperatorProcess(SelectOperator operator, Operator<? extends OperatorDesc> input) throws HiveException {
        ExprNodeDesc exprNodeDesc;
        RowSchema selRS = operator.getSchema();
        ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>();
        OpParseContext inputCtx = this.sa.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        ArrayList<ColumnInfo> columns = inputRR.getColumnInfos();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnInfo col = columns.get(i);
            exprNodeDesc = new ExprNodeColumnDesc(col);
            colList.add(exprNodeDesc);
            String internalName = selRS.getColumnNames().get(i);
            columnNames.add(internalName);
            columnExprMap.put(internalName, exprNodeDesc);
            signature.add(selRS.getSignature().get(i));
        }
        int dynamicPartBegin = -1;
        for (int i = 0; i < this.partitionColumns.size(); ++i) {
            exprNodeDesc = null;
            String partColName = this.partitionColumns.get(i).getName();
            if (this.partSpec != null && this.partSpec.containsKey(partColName) && this.partSpec.get(partColName) != null) {
                TypeInfo destType;
                if (dynamicPartBegin > 0) {
                    throw new SemanticException("Dynamic partition columns should not come before static partition columns.");
                }
                exprNodeDesc = new ExprNodeConstantDesc(this.partSpec.get(partColName));
                TypeInfo srcType = exprNodeDesc.getTypeInfo();
                if (!srcType.equals(destType = selRS.getSignature().get(this.columns.size() + i).getType())) {
                    exprNodeDesc = ParseUtils.createConversionCast(exprNodeDesc, (PrimitiveTypeInfo)destType);
                }
            } else {
                ColumnInfo col = columns.get(this.columns.size() + ++dynamicPartBegin);
                TypeInfo srcType = col.getType();
                TypeInfo destType = selRS.getSignature().get(this.columns.size() + i).getType();
                exprNodeDesc = new ExprNodeColumnDesc(col);
                if (!srcType.equals(destType)) {
                    exprNodeDesc = ParseUtils.createConversionCast(exprNodeDesc, (PrimitiveTypeInfo)destType);
                }
            }
            colList.add(exprNodeDesc);
            String internalName = selRS.getColumnNames().get(this.columns.size() + i);
            columnNames.add(internalName);
            columnExprMap.put(internalName, exprNodeDesc);
            signature.add(selRS.getSignature().get(this.columns.size() + i));
        }
        operator.setConf(new SelectDesc(colList, columnNames));
        operator.setColumnExprMap(columnExprMap);
        selRS.setSignature(signature);
        operator.setSchema(selRS);
    }

    public String getCompleteName() {
        return this.tbl.getDbName() + "." + this.tbl.getTableName();
    }

    public boolean isInsertInto() {
        return this.isInsertInto;
    }

    public static boolean canRunAutogatherStats(Operator curr) {
        block3: for (ColumnInfo cinfo : curr.getSchema().getSignature()) {
            if (cinfo.getIsVirtualCol()) {
                return false;
            }
            if (cinfo.getObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) {
                return false;
            }
            switch (((PrimitiveTypeInfo)cinfo.getType()).getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case TIMESTAMP: 
                case FLOAT: 
                case DOUBLE: 
                case STRING: 
                case CHAR: 
                case VARCHAR: 
                case BINARY: 
                case DECIMAL: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }
}

