/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.fast;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.sql.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.TimestampParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazySimpleDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazySimpleDeserializeRead.class.getName());
    private int[] startPosition;
    private byte separator;
    private boolean isEscaped;
    private byte escapeChar;
    private byte[] nullSequenceBytes;
    private boolean isExtendedBooleanLiteral;
    private boolean lastColumnTakesRest;
    private byte[] bytes;
    private int start;
    private int offset;
    private int end;
    private int fieldCount;
    private int fieldIndex;
    private int fieldStart;
    private int fieldLength;
    private Text tempText;
    private TimestampParser timestampParser;
    private boolean extraFieldWarned;
    private boolean missingFieldWarned;
    private static byte[] maxLongBytes = Long.valueOf(Long.MAX_VALUE).toString().getBytes();
    private static int maxLongDigitsCount = maxLongBytes.length;
    private static byte[] minLongNoSignBytes = Long.valueOf(Long.MIN_VALUE).toString().substring(1).getBytes();

    public LazySimpleDeserializeRead(TypeInfo[] typeInfos, byte separator, LazySerDeParameters lazyParams) {
        super(typeInfos);
        this.startPosition = new int[typeInfos.length + 1];
        this.separator = separator;
        this.isEscaped = lazyParams.isEscaped();
        this.escapeChar = lazyParams.getEscapeChar();
        this.nullSequenceBytes = lazyParams.getNullSequence().getBytes();
        this.isExtendedBooleanLiteral = lazyParams.isExtendedBooleanLiteral();
        this.lastColumnTakesRest = lazyParams.isLastColumnTakesRest();
        this.fieldCount = typeInfos.length;
        this.tempText = new Text();
        this.extraFieldWarned = false;
        this.missingFieldWarned = false;
    }

    public LazySimpleDeserializeRead(TypeInfo[] typeInfos, LazySerDeParameters lazyParams) {
        this(typeInfos, lazyParams.getSeparators()[0], lazyParams);
    }

    private LazySimpleDeserializeRead() {
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.start = offset;
        this.end = offset + length;
        this.fieldIndex = -1;
    }

    private void parse() {
        int structByteEnd = this.end;
        int fieldId = 0;
        int fieldByteBegin = this.start;
        int fieldByteEnd = this.start;
        while (fieldByteEnd <= structByteEnd) {
            if (fieldByteEnd == structByteEnd || this.bytes[fieldByteEnd] == this.separator) {
                if (this.lastColumnTakesRest && fieldId == this.fieldCount - 1) {
                    fieldByteEnd = structByteEnd;
                }
                this.startPosition[fieldId] = fieldByteBegin;
                if (++fieldId == this.fieldCount || fieldByteEnd == structByteEnd) {
                    for (int i = fieldId; i <= this.fieldCount; ++i) {
                        this.startPosition[i] = fieldByteEnd + 1;
                    }
                    break;
                }
                fieldByteBegin = fieldByteEnd + 1;
                ++fieldByteEnd;
                continue;
            }
            if (this.isEscaped && this.bytes[fieldByteEnd] == this.escapeChar && fieldByteEnd + 1 < structByteEnd) {
                fieldByteEnd += 2;
                continue;
            }
            ++fieldByteEnd;
        }
        if (!this.extraFieldWarned && fieldByteEnd < structByteEnd) {
            this.doExtraFieldWarned();
        }
        if (!this.missingFieldWarned && fieldId < this.fieldCount) {
            this.doMissingFieldWarned(fieldId);
        }
    }

    @Override
    public boolean readCheckNull() {
        int i;
        if (this.fieldIndex == -1) {
            this.parse();
            this.fieldIndex = 0;
        } else {
            if (this.fieldIndex + 1 >= this.fieldCount) {
                return true;
            }
            ++this.fieldIndex;
        }
        if (this.columnsToInclude != null && !this.columnsToInclude[this.fieldIndex]) {
            return true;
        }
        this.fieldStart = this.startPosition[this.fieldIndex];
        this.fieldLength = this.startPosition[this.fieldIndex + 1] - this.startPosition[this.fieldIndex] - 1;
        if (this.fieldLength < 0) {
            return true;
        }
        if (this.nullSequenceBytes != null && this.fieldLength == this.nullSequenceBytes.length) {
            i = 0;
            while (this.bytes[this.fieldStart + i] == this.nullSequenceBytes[i]) {
                if (++i < this.fieldLength) continue;
                return true;
            }
        }
        switch (this.primitiveCategories[this.fieldIndex]) {
            case BOOLEAN: {
                i = this.fieldStart;
                if (this.fieldLength == 4) {
                    if (!(this.bytes[i] != 84 && this.bytes[i] != 116 || this.bytes[i + 1] != 82 && this.bytes[i + 1] != 114 || this.bytes[i + 2] != 85 && this.bytes[i + 1] != 117 || this.bytes[i + 3] != 69 && this.bytes[i + 3] != 101)) {
                        this.currentBoolean = true;
                        break;
                    }
                    return true;
                }
                if (this.fieldLength == 5) {
                    if (!(this.bytes[i] != 70 && this.bytes[i] != 102 || this.bytes[i + 1] != 65 && this.bytes[i + 1] != 97 || this.bytes[i + 2] != 76 && this.bytes[i + 2] != 108 || this.bytes[i + 3] != 83 && this.bytes[i + 3] != 115 || this.bytes[i + 4] != 69 && this.bytes[i + 4] != 101)) {
                        this.currentBoolean = false;
                        break;
                    }
                    return true;
                }
                if (this.isExtendedBooleanLiteral && this.fieldLength == 1) {
                    byte b = this.bytes[this.fieldStart];
                    if (b == 49 || b == 116 || b == 84) {
                        this.currentBoolean = true;
                        break;
                    }
                    if (b == 48 || b == 102 || b == 70) {
                        this.currentBoolean = false;
                        break;
                    }
                    return true;
                }
                return true;
            }
            case BYTE: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                try {
                    this.currentByte = LazyByte.parseByte(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TINYINT");
                    return true;
                }
            }
            case SHORT: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                try {
                    this.currentShort = LazyShort.parseShort(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "SMALLINT");
                    return true;
                }
            }
            case INT: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                try {
                    this.currentInt = LazyInteger.parseInt(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INT");
                    return true;
                }
            }
            case LONG: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                try {
                    this.currentLong = LazyLong.parseLong(this.bytes, this.fieldStart, this.fieldLength, 10);
                    break;
                }
                catch (NumberFormatException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "BIGINT");
                    return true;
                }
            }
            case FLOAT: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.currentFloat = Float.parseFloat(byteData);
                    break;
                }
                catch (NumberFormatException e) {
                    LOG.debug("Data not in the Float data type range so converted to null. Given data is :" + byteData, (Throwable)e);
                    return true;
                }
                catch (CharacterCodingException e) {
                    LOG.debug("Data not in the Float data type range so converted to null.", (Throwable)e);
                    return true;
                }
            }
            case DOUBLE: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.currentDouble = Double.parseDouble(byteData);
                    break;
                }
                catch (NumberFormatException e) {
                    LOG.debug("Data not in the Double data type range so converted to null. Given data is :" + byteData, (Throwable)e);
                    return true;
                }
                catch (CharacterCodingException e) {
                    LOG.debug("Data not in the Double data type range so converted to null.", (Throwable)e);
                    return true;
                }
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (this.isEscaped) {
                    LazyUtils.copyAndEscapeStringDataToText(this.bytes, this.fieldStart, this.fieldLength, this.escapeChar, this.tempText);
                    this.currentBytes = this.tempText.getBytes();
                    this.currentBytesStart = 0;
                    this.currentBytesLength = this.tempText.getLength();
                    break;
                }
                this.currentBytes = this.bytes;
                this.currentBytesStart = this.fieldStart;
                this.currentBytesLength = this.fieldLength;
                break;
            }
            case BINARY: {
                byte[] recv = new byte[this.fieldLength];
                System.arraycopy(this.bytes, this.fieldStart, recv, 0, this.fieldLength);
                byte[] decoded = LazyBinary.decodeIfNeeded(recv);
                decoded = decoded.length > 0 ? decoded : recv;
                this.currentBytes = decoded;
                this.currentBytesStart = 0;
                this.currentBytesLength = decoded.length;
                break;
            }
            case DATE: {
                if (this.fieldLength == 0) {
                    return true;
                }
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.currentDateWritable.set(Date.valueOf(s));
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "DATE");
                    return true;
                }
            }
            case TIMESTAMP: {
                if (this.fieldLength == 0) {
                    return true;
                }
                String s = null;
                try {
                    s = new String(this.bytes, this.fieldStart, this.fieldLength, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error("Unsupported encoding found ", (Throwable)e);
                    s = "";
                }
                if (s.compareTo("NULL") == 0) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TIMESTAMP");
                    return true;
                }
                try {
                    if (this.timestampParser == null) {
                        this.timestampParser = new TimestampParser();
                    }
                    this.currentTimestampWritable.set(this.timestampParser.parseTimestamp(s));
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "TIMESTAMP");
                    return true;
                }
            }
            case INTERVAL_YEAR_MONTH: {
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.currentHiveIntervalYearMonthWritable.set(HiveIntervalYearMonth.valueOf(s));
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INTERVAL_YEAR_MONTH");
                    return true;
                }
            }
            case INTERVAL_DAY_TIME: {
                String s = null;
                try {
                    s = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                    this.currentHiveIntervalDayTimeWritable.set(HiveIntervalDayTime.valueOf(s));
                    break;
                }
                catch (Exception e) {
                    this.logExceptionMessage(this.bytes, this.fieldStart, this.fieldLength, "INTERVAL_DAY_TIME");
                    return true;
                }
            }
            case DECIMAL: {
                if (!LazyUtils.isNumberMaybe(this.bytes, this.fieldStart, this.fieldLength)) {
                    return true;
                }
                String byteData = null;
                try {
                    byteData = Text.decode((byte[])this.bytes, (int)this.fieldStart, (int)this.fieldLength);
                }
                catch (CharacterCodingException e) {
                    LOG.debug("Data not in the HiveDecimal data type range so converted to null.", (Throwable)e);
                    return true;
                }
                HiveDecimal decimal = HiveDecimal.create(byteData);
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.typeInfos[this.fieldIndex];
                int precision = decimalTypeInfo.getPrecision();
                int scale = decimalTypeInfo.getScale();
                decimal = HiveDecimal.enforcePrecisionScale(decimal, precision, scale);
                if (decimal == null) {
                    LOG.debug("Data not in the HiveDecimal data type range so converted to null. Given data is :" + byteData);
                    return true;
                }
                this.currentHiveDecimalWritable.set(decimal);
                break;
            }
            default: {
                throw new Error("Unexpected primitive category " + this.primitiveCategories[this.fieldIndex].name());
            }
        }
        return false;
    }

    public void logExceptionMessage(byte[] bytes, int bytesStart, int bytesLength, String dataType) {
        try {
            if (LOG.isDebugEnabled()) {
                String byteData = Text.decode((byte[])bytes, (int)bytesStart, (int)bytesLength);
                LOG.debug("Data not in the " + dataType + " data type range so converted to null. Given data is :" + byteData, (Throwable)new Exception("For debugging purposes"));
            }
        }
        catch (CharacterCodingException e1) {
            LOG.debug("Data not in the " + dataType + " data type range so converted to null.", (Throwable)e1);
        }
    }

    @Override
    public void extraFieldsCheck() {
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.missingFieldWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.extraFieldWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return false;
    }

    private void doExtraFieldWarned() {
        this.extraFieldWarned = true;
        LOG.warn("Extra bytes detected at the end of the row! Ignoring similar problems.");
    }

    private void doMissingFieldWarned(int fieldId) {
        this.missingFieldWarned = true;
        LOG.info("Missing fields! Expected " + this.fieldCount + " fields but " + "only got " + fieldId + "! Ignoring similar problems.");
    }

    public static int byteArrayCompareRanges(byte[] arg1, int start1, byte[] arg2, int start2, int len) {
        for (int i = 0; i < len; ++i) {
            int b1 = arg1[i + start1] & 0xFF;
            int b2 = arg2[i + start2] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }
}

