/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.wizard;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.AbstractReportContextAction;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.util.ReportDesignerDesignTimeContext;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.wizard.Messages;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.EmbeddedWizard;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class EditWizardReportAction
extends AbstractReportContextAction {
    public EditWizardReportAction() {
        this.putValue("Name", Messages.getString("EditWizardReportAction.MenuText", new Object[0]));
    }

    public void actionPerformed(ActionEvent e) {
        ReportDesignerContext reportDesignerContext1 = this.getReportDesignerContext();
        if (reportDesignerContext1 == null) {
            return;
        }
        ReportDocumentContext activeContext = reportDesignerContext1.getActiveContext();
        if (activeContext == null) {
            return;
        }
        Component parent = reportDesignerContext1.getView().getParent();
        Window window = this.getWindowAncestor(parent);
        EmbeddedWizard dialog = this.createDialog(window, new ReportDesignerDesignTimeContext(reportDesignerContext1));
        try {
            AbstractReportDefinition realOriginal = activeContext.getReportDefinition();
            AbstractReportDefinition original = (AbstractReportDefinition)realOriginal.derive();
            AbstractReportDefinition def = dialog.run(original);
            if (def == null) {
                return;
            }
            if (def instanceof MasterReport) {
                reportDesignerContext1.addMasterReport((MasterReport)def);
            } else if (def instanceof SubReport) {
                SubReport report;
                int i;
                Section parentSection = this.getParentSection(realOriginal);
                if (parentSection instanceof AbstractRootLevelBand) {
                    AbstractRootLevelBand rlb = (AbstractRootLevelBand)parentSection;
                    SubReport[] reports = rlb.getSubReports();
                    for (i = 0; i < reports.length; ++i) {
                        report = reports[i];
                        if (report != realOriginal) continue;
                        rlb.removeSubreport(report);
                        rlb.addSubReport(i, (SubReport)def);
                        return;
                    }
                }
                if (parentSection instanceof Band) {
                    Band b = (Band)parentSection;
                    Element[] elementArray = b.getElementArray();
                    for (i = 0; i < elementArray.length; ++i) {
                        report = elementArray[i];
                        if (report != realOriginal) continue;
                        b.removeElement((Element)report);
                        b.addElement(i, (Element)def);
                        return;
                    }
                }
            }
        }
        catch (ReportProcessingException e1) {
            UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
        }
    }

    Window getWindowAncestor(Component parent) {
        return LibSwingUtil.getWindowAncestor((Component)parent);
    }

    EmbeddedWizard createDialog(Window window, ReportDesignerDesignTimeContext rddtc) {
        return new EmbeddedWizard(window, (DesignTimeContext)rddtc);
    }

    Section getParentSection(AbstractReportDefinition reportDefinition) {
        return reportDefinition.getParentSection();
    }
}

