/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.engine;

import org.pentaho.platform.api.engine.IServerStatusChangeListener;
import org.pentaho.platform.api.engine.ServerStatusProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IServerStatusProvider {
    public static final Locator LOCATOR = new Locator();

    public ServerStatus getStatus();

    public void setStatus(ServerStatus var1);

    public String[] getStatusMessages();

    public void setStatusMessages(String[] var1);

    public void registerServerStatusChangeListener(IServerStatusChangeListener var1);

    public void removeServerStatusChangeListener(IServerStatusChangeListener var1);

    public static class Locator {
        private static final String PROVIDER_CLASS = "org.pentaho.platform.api.engine.IServerStatusProvider.class";
        IServerStatusProvider instance;
        private static Logger logger = LoggerFactory.getLogger(Locator.class);

        public IServerStatusProvider getProvider() {
            if (this.instance == null) {
                if (System.getProperty(PROVIDER_CLASS) != null) {
                    try {
                        this.instance = (IServerStatusProvider)Class.forName(System.getProperty(PROVIDER_CLASS)).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("ServerStatusProvider class not found", (Throwable)e);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        logger.error("ServerStatusProvider class could not be instantiated", (Throwable)e);
                    }
                }
                if (this.instance == null) {
                    this.instance = new ServerStatusProvider();
                }
            }
            return this.instance;
        }
    }

    public static enum ServerStatus {
        DOWN,
        STARTING,
        STARTED,
        STOPPING,
        ERROR;

    }
}

