/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.api.repository2.unified;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class VersionSummary
implements Serializable {
    private static final long serialVersionUID = -6452375912236787125L;
    private final String message;
    private final Date date;
    private final String author;
    private final Serializable id;
    private final Serializable versionedFileId;
    private final boolean aclOnlyChange;
    private final List<String> labels;

    public VersionSummary(Serializable id, Serializable versionedFileId, boolean aclOnlyChange, Date date, String author, String message, List<String> labels) {
        this.notNull(id);
        this.notNull(versionedFileId);
        this.notNull(date);
        this.hasText(author);
        this.notNull(labels);
        this.id = id;
        this.versionedFileId = versionedFileId;
        this.date = new Date(date.getTime());
        this.author = author;
        this.message = message;
        this.labels = Collections.unmodifiableList(labels);
        this.aclOnlyChange = aclOnlyChange;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public String getAuthor() {
        return this.author;
    }

    public Serializable getId() {
        return this.id;
    }

    public Serializable getVersionedFileId() {
        return this.versionedFileId;
    }

    protected void hasText(String in) {
        if (in == null || in.length() == 0 || in.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    private void notNull(Object in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
    }

    public List<String> getLabels() {
        return Collections.unmodifiableList(this.labels);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionSummary other = (VersionSummary)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public boolean isAclOnlyChange() {
        return this.aclOnlyChange;
    }

    public String toString() {
        return "VersionSummary [id=" + this.id + ", versionedFileId=" + this.versionedFileId + ", aclOnlyChange=" + this.aclOnlyChange + ", date=" + this.date + ", author=" + this.author + ", message=" + this.message + ", labels=" + this.labels + "]";
    }
}

