/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.security.Credentials;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface JobContext
extends MRJobConfig {
    public Configuration getConfiguration();

    public Credentials getCredentials();

    public JobID getJobID();

    public int getNumReduceTasks();

    public Path getWorkingDirectory() throws IOException;

    public Class<?> getOutputKeyClass();

    public Class<?> getOutputValueClass();

    public Class<?> getMapOutputKeyClass();

    public Class<?> getMapOutputValueClass();

    public String getJobName();

    public boolean userClassesTakesPrecedence();

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException;

    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException;

    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException;

    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException;

    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException;

    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException;

    public RawComparator<?> getSortComparator();

    public String getJar();

    public RawComparator<?> getCombinerKeyGroupingComparator();

    public RawComparator<?> getGroupingComparator();

    public boolean getJobSetupCleanupNeeded();

    public boolean getTaskCleanupNeeded();

    public boolean getProfileEnabled();

    public String getProfileParams();

    public Configuration.IntegerRanges getProfileTaskRange(boolean var1);

    public String getUser();

    @Deprecated
    public boolean getSymlink();

    public Path[] getArchiveClassPaths();

    public URI[] getCacheArchives() throws IOException;

    public URI[] getCacheFiles() throws IOException;

    @Deprecated
    public Path[] getLocalCacheArchives() throws IOException;

    @Deprecated
    public Path[] getLocalCacheFiles() throws IOException;

    public Path[] getFileClassPaths();

    public String[] getArchiveTimestamps();

    public String[] getFileTimestamps();

    public int getMaxMapAttempts();

    public int getMaxReduceAttempts();
}

