/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import com.google.common.annotations.VisibleForTesting;
import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class CredentialShell
extends Configured
implements Tool {
    private static final String USAGE_PREFIX = "Usage: hadoop credential [generic options]\n";
    private static final String COMMANDS = "   [-help]\n   [create <alias> [-value alias-value] [-provider provider-path] [-strict]]\n   [delete <alias> [-f] [-provider provider-path] [-strict]]\n   [list [-provider provider-path] [-strict]]\n";
    @VisibleForTesting
    public static final String NO_VALID_PROVIDERS = "There are no valid (non-transient) providers configured.\nNo action has been taken. Use the -provider option to specify\na provider. If you want to use a transient provider then you\nMUST use the -provider argument.";
    private boolean interactive = true;
    private Command command = null;
    private boolean strict = false;
    @VisibleForTesting
    public PrintStream out = System.out;
    @VisibleForTesting
    public PrintStream err = System.err;
    private boolean userSuppliedProvider = false;
    private String value = null;
    private PasswordReader passwordReader;
    private boolean isHelp = false;

    @Override
    public int run(String[] args) throws Exception {
        int exitCode = 0;
        try {
            exitCode = this.init(args);
            if (exitCode != 0) {
                return exitCode;
            }
            if (!this.isHelp) {
                if (this.command.validate()) {
                    this.command.execute();
                } else {
                    exitCode = 1;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.err);
            return 1;
        }
        return exitCode;
    }

    protected int init(String[] args) throws IOException {
        if (0 == args.length) {
            this.printCredShellUsage();
            ToolRunner.printGenericCommandUsage(System.err);
            return 1;
        }
        for (int i = 0; i < args.length; ++i) {
            String alias;
            if (args[i].equals("create")) {
                alias = args[++i];
                this.command = new CreateCommand(alias);
                if (!alias.equals("-help")) continue;
                this.printCredShellUsage();
                return 0;
            }
            if (args[i].equals("delete")) {
                alias = args[++i];
                this.command = new DeleteCommand(alias);
                if (!alias.equals("-help")) continue;
                this.printCredShellUsage();
                return 0;
            }
            if (args[i].equals("list")) {
                this.command = new ListCommand();
                continue;
            }
            if (args[i].equals("-provider")) {
                this.userSuppliedProvider = true;
                this.getConf().set("hadoop.security.credential.provider.path", args[++i]);
                continue;
            }
            if (args[i].equals("-f") || args[i].equals("-force")) {
                this.interactive = false;
                continue;
            }
            if (args[i].equals("-strict")) {
                this.strict = true;
                continue;
            }
            if (args[i].equals("-v") || args[i].equals("-value")) {
                this.value = args[++i];
                continue;
            }
            if (args[i].equals("-help")) {
                this.printCredShellUsage();
                return 0;
            }
            this.printCredShellUsage();
            ToolRunner.printGenericCommandUsage(System.err);
            return 1;
        }
        return 0;
    }

    private void printCredShellUsage() {
        this.isHelp = true;
        this.out.println("Usage: hadoop credential [generic options]\n   [-help]\n   [create <alias> [-value alias-value] [-provider provider-path] [-strict]]\n   [delete <alias> [-f] [-provider provider-path] [-strict]]\n   [list [-provider provider-path] [-strict]]\n");
        if (this.command != null) {
            this.out.println(this.command.getUsage());
        } else {
            this.out.println("===============================================================");
            this.out.println("create <alias> [-value alias-value] [-provider provider-path] [-strict]:\n\nThe create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.");
            this.out.println("===============================================================");
            this.out.println("delete <alias> [-f] [-provider provider-path] [-strict]:\n\nThe delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.");
            this.out.println("===============================================================");
            this.out.println("list [-provider provider-path] [-strict]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.");
        }
    }

    protected char[] promptForCredential() throws IOException {
        boolean noMatch;
        PasswordReader c = this.getPasswordReader();
        if (c == null) {
            throw new IOException("No console available for prompting user.");
        }
        char[] cred = null;
        do {
            char[] newPassword2;
            char[] newPassword1;
            boolean bl = noMatch = !Arrays.equals(newPassword1 = c.readPassword("Enter alias password: "), newPassword2 = c.readPassword("Enter alias password again: "));
            if (noMatch) {
                if (newPassword1 != null) {
                    Arrays.fill(newPassword1, ' ');
                }
                c.format("Passwords don't match. Try again.%n");
            } else {
                cred = newPassword1;
            }
            if (newPassword2 == null) continue;
            Arrays.fill(newPassword2, ' ');
        } while (noMatch);
        return cred;
    }

    public PasswordReader getPasswordReader() {
        if (this.passwordReader == null) {
            this.passwordReader = new PasswordReader();
        }
        return this.passwordReader;
    }

    public void setPasswordReader(PasswordReader reader) {
        this.passwordReader = reader;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run(new Configuration(), new CredentialShell(), args);
        System.exit(res);
    }

    public static class PasswordReader {
        public char[] readPassword(String prompt) {
            Console console = System.console();
            char[] pass = console.readPassword(prompt, new Object[0]);
            return pass;
        }

        public void format(String message) {
            Console console = System.console();
            console.format(message, new Object[0]);
        }
    }

    private class CreateCommand
    extends Command {
        public static final String USAGE = "create <alias> [-value alias-value] [-provider provider-path] [-strict]";
        public static final String DESC = "The create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        private String alias;

        public CreateCommand(String alias) {
            this.alias = null;
            this.alias = alias;
        }

        @Override
        public boolean validate() {
            boolean rc = true;
            try {
                this.provider = this.getCredentialProvider();
                if (this.provider == null) {
                    rc = false;
                } else if (this.provider.needsPassword()) {
                    if (CredentialShell.this.strict) {
                        CredentialShell.this.out.println(this.provider.noPasswordError());
                        rc = false;
                    } else {
                        CredentialShell.this.out.println(this.provider.noPasswordWarning());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(CredentialShell.this.err);
            }
            if (this.alias == null) {
                CredentialShell.this.out.println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                rc = false;
            }
            return rc;
        }

        @Override
        public void execute() throws IOException, NoSuchAlgorithmException {
            this.warnIfTransientProvider();
            try {
                char[] credential = null;
                credential = CredentialShell.this.value != null ? CredentialShell.this.value.toCharArray() : CredentialShell.this.promptForCredential();
                this.provider.createCredentialEntry(this.alias, credential);
                this.provider.flush();
                CredentialShell.this.out.println(this.alias + " has been successfully created.");
                this.printProviderWritten();
            }
            catch (InvalidParameterException e) {
                CredentialShell.this.out.println("Credential " + this.alias + " has NOT been created. " + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                CredentialShell.this.out.println("Credential " + this.alias + " has NOT been created. " + e.getMessage());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "create <alias> [-value alias-value] [-provider provider-path] [-strict]:\n\nThe create subcommand creates a new credential for the name\nspecified as the <alias> argument within the provider indicated\nthrough the -provider argument. If -strict is supplied, fail\nimmediately if the provider requires a password and none is given.\nIf -value is provided, use that for the value of the credential\ninstead of prompting the user.";
        }
    }

    private class DeleteCommand
    extends Command {
        public static final String USAGE = "delete <alias> [-f] [-provider provider-path] [-strict]";
        public static final String DESC = "The delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.";
        private String alias;
        private boolean cont;

        public DeleteCommand(String alias) {
            this.alias = null;
            this.cont = true;
            this.alias = alias;
        }

        @Override
        public boolean validate() {
            this.provider = this.getCredentialProvider();
            if (this.provider == null) {
                return false;
            }
            if (this.alias == null) {
                CredentialShell.this.out.println("There is no alias specified. Please provide themandatory <alias>. See the usage description with -help.");
                return false;
            }
            if (CredentialShell.this.interactive) {
                try {
                    this.cont = ToolRunner.confirmPrompt("You are about to DELETE the credential " + this.alias + " from CredentialProvider " + this.provider.toString() + ". Continue? ");
                    if (!this.cont) {
                        CredentialShell.this.out.println("Nothing has been be deleted.");
                    }
                    return this.cont;
                }
                catch (IOException e) {
                    CredentialShell.this.out.println(this.alias + " will not be deleted.");
                    e.printStackTrace(CredentialShell.this.err);
                }
            }
            return true;
        }

        @Override
        public void execute() throws IOException {
            this.warnIfTransientProvider();
            CredentialShell.this.out.println("Deleting credential: " + this.alias + " from CredentialProvider: " + this.provider.toString());
            if (this.cont) {
                try {
                    this.provider.deleteCredentialEntry(this.alias);
                    CredentialShell.this.out.println("Credential " + this.alias + " has been successfully deleted.");
                    this.provider.flush();
                    this.printProviderWritten();
                }
                catch (IOException e) {
                    CredentialShell.this.out.println("Credential " + this.alias + " has NOT been deleted.");
                    throw e;
                }
            }
        }

        @Override
        public String getUsage() {
            return "delete <alias> [-f] [-provider provider-path] [-strict]:\n\nThe delete subcommand deletes the credential\nspecified as the <alias> argument from within the provider\nindicated through the -provider argument. The command asks for\nconfirmation unless the -f option is specified. If -strict is\nsupplied, fail immediately if the provider requires a password\nand none is given.";
        }
    }

    private class ListCommand
    extends Command {
        public static final String USAGE = "list [-provider provider-path] [-strict]";
        public static final String DESC = "The list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.";

        private ListCommand() {
        }

        @Override
        public boolean validate() {
            this.provider = this.getCredentialProvider();
            return this.provider != null;
        }

        @Override
        public void execute() throws IOException {
            try {
                List<String> aliases = this.provider.getAliases();
                CredentialShell.this.out.println("Listing aliases for CredentialProvider: " + this.provider.toString());
                for (String alias : aliases) {
                    CredentialShell.this.out.println(alias);
                }
            }
            catch (IOException e) {
                CredentialShell.this.out.println("Cannot list aliases for CredentialProvider: " + this.provider.toString() + ": " + e.getMessage());
                throw e;
            }
        }

        @Override
        public String getUsage() {
            return "list [-provider provider-path] [-strict]:\n\nThe list subcommand displays the aliases contained within \na particular provider - as configured in core-site.xml or\nindicated through the -provider argument. If -strict is supplied,\nfail immediately if the provider requires a password and none is\nprovided.";
        }
    }

    private abstract class Command {
        protected CredentialProvider provider = null;

        private Command() {
        }

        public boolean validate() {
            return true;
        }

        protected CredentialProvider getCredentialProvider() {
            CredentialProvider prov;
            block5: {
                prov = null;
                try {
                    List<CredentialProvider> providers = CredentialProviderFactory.getProviders(CredentialShell.this.getConf());
                    if (CredentialShell.this.userSuppliedProvider) {
                        prov = providers.get(0);
                        break block5;
                    }
                    for (CredentialProvider p : providers) {
                        if (p.isTransient()) continue;
                        prov = p;
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(CredentialShell.this.err);
                }
            }
            if (prov == null) {
                CredentialShell.this.out.println(CredentialShell.NO_VALID_PROVIDERS);
            }
            return prov;
        }

        protected void printProviderWritten() {
            CredentialShell.this.out.println("Provider " + this.provider.toString() + " has been updated.");
        }

        protected void warnIfTransientProvider() {
            if (this.provider.isTransient()) {
                CredentialShell.this.out.println("WARNING: you are modifying a transient provider.");
            }
        }

        public abstract void execute() throws Exception;

        public abstract String getUsage();
    }
}

