/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundlesMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlesMBeanImpl
extends StandardMBean
implements BundlesMBean {
    private Logger LOG = LoggerFactory.getLogger(BundlesMBeanImpl.class);
    private BundleContext bundleContext;
    private final BundleService bundleService;

    public BundlesMBeanImpl(BundleContext bundleContext, BundleService bundleService) throws NotCompliantMBeanException {
        super(BundlesMBean.class);
        this.bundleContext = bundleContext;
        this.bundleService = bundleService;
    }

    private List<Bundle> selectBundles(String id) throws Exception {
        List<String> ids = Collections.singletonList(id);
        return this.bundleService.selectBundles(ids, false);
    }

    @Override
    public TabularData getBundles() throws MBeanException {
        try {
            CompositeType bundleType = new CompositeType("Bundle", "OSGi Bundle", new String[]{"ID", "Name", "Version", "Start Level", "State"}, new String[]{"ID of the Bundle", "Name of the Bundle", "Version of the Bundle", "Start Level of the Bundle", "Current State of the Bundle"}, new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING});
            TabularType tableType = new TabularType("BundlesMBeanImpl", "Tables of all BundlesMBeanImpl", bundleType, new String[]{"ID"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            Bundle[] bundles = this.bundleContext.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                try {
                    Bundle bundle = bundles[i];
                    BundleInfo info = this.bundleService.getInfo(bundle);
                    String bundleStateString = info.getState().toString();
                    CompositeDataSupport data = new CompositeDataSupport(bundleType, new String[]{"ID", "Name", "Version", "Start Level", "State"}, new Object[]{info.getBundleId(), info.getSymbolicName(), info.getVersion(), info.getStartLevel(), bundleStateString});
                    table.put(data);
                    continue;
                }
                catch (Exception e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public int getStartLevel(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            if (bundles.size() != 1) {
                throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
            }
            return this.getBundleStartLevel(bundles.get(0)).getStartLevel();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void setStartLevel(String bundleId, int bundleStartLevel) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            for (Bundle bundle : bundles) {
                this.getBundleStartLevel(bundle).setStartLevel(bundleStartLevel);
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    private BundleStartLevel getBundleStartLevel(Bundle bundle) {
        return (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
    }

    @Override
    public void refresh() throws MBeanException {
        this.getFrameworkWiring().refreshBundles(null, new FrameworkListener[0]);
    }

    @Override
    public void refresh(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            if (bundles.isEmpty()) {
                this.getFrameworkWiring().refreshBundles(bundles, new FrameworkListener[0]);
            } else {
                this.getFrameworkWiring().refreshBundles(bundles, new FrameworkListener[0]);
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void update(String bundleId) throws MBeanException {
        this.update(bundleId, null);
    }

    @Override
    public void update(String bundleId, String location) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            if (location == null) {
                for (Bundle bundle : bundles) {
                    bundle.update();
                }
                return;
            }
            if (bundles.size() != 1) {
                throw new IllegalArgumentException("Provided bundle Id doesn't return any bundle or more than one bundle selected");
            }
            InputStream is = new URL(location).openStream();
            bundles.get(0).update(is);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void resolve() throws MBeanException {
        this.getFrameworkWiring().resolveBundles(null);
    }

    @Override
    public void resolve(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            this.getFrameworkWiring().resolveBundles(bundles);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    private FrameworkWiring getFrameworkWiring() {
        return (FrameworkWiring)this.getBundleContext().getBundle(0L).adapt(FrameworkWiring.class);
    }

    @Override
    public void restart(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            for (Bundle bundle : bundles) {
                bundle.stop();
                bundle.start();
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public long install(String url) throws MBeanException {
        return this.install(url, false);
    }

    @Override
    public long install(String url, boolean start) throws MBeanException {
        try {
            Bundle bundle = this.bundleContext.installBundle(url, null);
            if (start) {
                bundle.start();
            }
            return bundle.getBundleId();
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void start(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            for (Bundle bundle : bundles) {
                bundle.start();
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void stop(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            for (Bundle bundle : bundles) {
                bundle.stop();
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void uninstall(String bundleId) throws MBeanException {
        try {
            List<Bundle> bundles = this.selectBundles(bundleId);
            for (Bundle bundle : bundles) {
                bundle.uninstall();
            }
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public String getDiag(long bundleId) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            throw new RuntimeException("Bundle with id " + bundleId + " not found");
        }
        return this.bundleService.getDiag(bundle);
    }
}

