/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractNode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataData;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.di.trans.steps.getxmldata.IgnoreDTDEntityResolver;
import org.xml.sax.EntityResolver;

public class GetXMLData
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetXMLDataMeta.class;
    private GetXMLDataMeta meta;
    private GetXMLDataData data;
    private Object[] prevRow = null;

    public GetXMLData(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setDocument(String StringXML, FileObject file, boolean IsInXMLField, boolean readurl) throws KettleException {
        this.prevRow = this.buildEmptyRow();
        try {
            SAXReader reader = XMLParserFactoryProducer.getSAXReader(null);
            this.data.stopPruning = false;
            if (this.meta.isValidating()) {
                reader.setValidation(true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            } else {
                reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            }
            if (this.meta.isIgnoreComments()) {
                reader.setIgnoreComments(true);
            }
            if (this.data.prunePath != null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.Activated", (String[])new String[0]));
                }
                if (this.data.PathValue.equals(this.data.prunePath)) {
                    this.data.an = new ArrayList<AbstractNode>(1);
                    this.data.an.add(null);
                }
                reader.addHandler(this.data.prunePath, new ElementHandler(){

                    public void onStart(ElementPath path) {
                    }

                    public void onEnd(ElementPath path) {
                        if (GetXMLData.this.isStopped()) {
                            if (GetXMLData.this.log.isBasic()) {
                                GetXMLData.this.logBasic(BaseMessages.getString((Class)PKG, (String)"GetXMLData.Log.StreamingMode.Stopped", (String[])new String[0]));
                            }
                            ((GetXMLData)GetXMLData.this).data.stopPruning = true;
                            path.getCurrent().getDocument().detach();
                            return;
                        }
                        if (GetXMLData.this.log.isDebug()) {
                            GetXMLData.this.logDebug(BaseMessages.getString((Class)PKG, (String)"GetXMLData.Log.StreamingMode.StartProcessing", (String[])new String[0]));
                        }
                        Element row = path.getCurrent();
                        try {
                            GetXMLData.this.processStreaming(row);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        row.detach();
                        if (GetXMLData.this.log.isDebug()) {
                            GetXMLData.this.logDebug(BaseMessages.getString((Class)PKG, (String)"GetXMLData.Log.StreamingMode.EndProcessing", (String[])new String[0]));
                        }
                    }
                });
            }
            if (IsInXMLField) {
                this.data.document = reader.read((Reader)new StringReader(StringXML));
            } else if (readurl) {
                HttpClient client = new HttpClient();
                GetMethod method = new GetMethod(StringXML);
                method.addRequestHeader("Accept-Encoding", "gzip");
                client.executeMethod((HttpMethod)method);
                Header contentEncoding = method.getResponseHeader("Content-Encoding");
                if (contentEncoding != null) {
                    String acceptEncodingValue = contentEncoding.getValue();
                    if (acceptEncodingValue.indexOf("gzip") != -1) {
                        GZIPInputStream in = new GZIPInputStream(method.getResponseBodyAsStream());
                        this.data.document = reader.read((InputStream)in);
                    }
                } else {
                    this.data.document = reader.read(method.getResponseBodyAsStream());
                }
            } else {
                String encoding = "UTF-8";
                if (!Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                    encoding = this.meta.getEncoding();
                }
                InputStream is = KettleVFS.getInputStream((FileObject)file);
                try {
                    this.data.document = reader.read(is, encoding);
                }
                finally {
                    BaseStep.closeQuietly((Closeable)is);
                }
            }
            if (this.meta.isNamespaceAware()) {
                this.prepareNSMap(this.data.document.getRootElement());
            }
        }
        catch (Exception e) {
            if (this.data.stopPruning) {
                return false;
            }
            throw new KettleException((Throwable)e);
        }
        return true;
    }

    private void processStreaming(Element row) throws KettleException {
        this.data.document = row.getDocument();
        if (this.meta.isNamespaceAware()) {
            this.prepareNSMap(this.data.document.getRootElement());
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ApplyXPath", (String[])new String[0]));
        }
        if (this.data.PathValue.equals(this.data.prunePath)) {
            this.data.an.set(0, (AbstractNode)row);
            this.data.nodesize = 1;
            this.data.nodenr = 0;
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ProcessingRows", (String[])new String[0]));
            }
            Object[] r = this.getXMLRowPutRowWithErrorhandling();
            if (!this.data.errorInRowButContinue) {
                this.putRowOut(r);
            }
            this.data.nodesize = 0;
            this.data.nodenr = 0;
            return;
        }
        if (!this.applyXPath()) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.ProcessingRows", (String[])new String[0]));
        }
        boolean cont = true;
        while (this.data.nodenr < this.data.nodesize && cont && !this.isStopped()) {
            Object[] r = this.getXMLRowPutRowWithErrorhandling();
            if (this.data.errorInRowButContinue) continue;
            cont = this.putRowOut(r);
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetXMLData.Log.StreamingMode.FreeMemory", (String[])new String[0]));
        }
        this.data.an.clear();
        this.data.nodesize = this.data.an.size();
        this.data.nodenr = 0;
    }

    public void prepareNSMap(Element l) {
        List namespacesList = l.declaredNamespaces();
        for (Namespace ns : namespacesList) {
            if (ns.getPrefix().trim().length() == 0) {
                this.data.NAMESPACE.put("pre" + this.data.NSPath.size(), ns.getURI());
                String path = "";
                for (Element element = l; element != null; element = element.getParent()) {
                    path = element.getNamespacePrefix() != null && element.getNamespacePrefix().length() > 0 ? "/" + element.getNamespacePrefix() + ":" + element.getName() + path : "/" + element.getName() + path;
                }
                this.data.NSPath.add(path);
                continue;
            }
            this.data.NAMESPACE.put(ns.getPrefix(), ns.getURI());
        }
        List elementsList = l.elements();
        for (Element e : elementsList) {
            this.prepareNSMap(e);
        }
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ReadNextString() {
        try {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                if (!this.log.isDetailed()) return false;
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FinishedProcessing", (String[])new String[0]));
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.nrReadRow = this.getInputRowMeta().size();
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                this.data.totalpreviousfields = this.data.inputRowMeta.size();
                this.data.convertRowMeta = new RowMeta();
                for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                    this.data.convertRowMeta.addValueMeta(ValueMetaFactory.cloneValueMeta((ValueMetaInterface)valueMeta, (int)2));
                }
                this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
                if (Utils.isEmpty((CharSequence)this.meta.getXMLField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoField", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoField", (String[])new String[0]));
                }
                if (this.data.indexOfXmlField < 0) {
                    this.data.indexOfXmlField = this.getInputRowMeta().indexOfValue(this.meta.getXMLField());
                    if (this.data.indexOfXmlField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ErrorFindingField", (String[])new String[]{this.meta.getXMLField()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Exception.CouldnotFindField", (String[])new String[]{this.meta.getXMLField()}));
                    }
                }
            }
            if (!this.meta.isInFields()) return true;
            String Fieldvalue = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfXmlField);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.XMLStream", (String[])new String[]{this.meta.getXMLField(), Fieldvalue}));
            }
            if (this.meta.getIsAFile()) {
                FileObject file = null;
                try {
                    file = KettleVFS.getFileObject((String)Fieldvalue, (VariableSpace)this.getTransMeta());
                    if (this.meta.isIgnoreEmptyFile() && file.getContent().getSize() == 0L) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"GetXMLData.Error.FileSizeZero", (String[])new String[]{"" + file.getName()}));
                        boolean bl = this.ReadNextString();
                        return bl;
                    }
                    if (!this.setDocument(null, file, false, false)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
                    }
                    if (!this.applyXPath()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
                    }
                    this.addFileToResultFilesname(file);
                    if (!this.log.isDetailed()) return true;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + this.data.nodesize, file.getName().getBaseName()}));
                    return true;
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            boolean url = false;
            boolean xmltring = true;
            if (this.meta.isReadUrl()) {
                url = true;
                xmltring = false;
            }
            if (!this.setDocument(Fieldvalue, null, xmltring, url)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
            }
            if (!this.applyXPath()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
            }
            if (!this.log.isDetailed()) return true;
            this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + this.data.nodesize}));
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (this.meta.addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    public String addNSPrefix(String path, String loopPath) {
        if (this.data.NSPath.size() > 0) {
            String fullPath = loopPath;
            if (!path.equals(fullPath)) {
                for (String tmp : path.split("/")) {
                    fullPath = tmp.equals("..") ? fullPath.substring(0, fullPath.lastIndexOf("/")) : fullPath + "/" + tmp;
                }
            }
            int[] indexs = new int[fullPath.split("/").length - 1];
            Arrays.fill(indexs, -1);
            int length = 0;
            for (int i = 0; i < this.data.NSPath.size(); ++i) {
                if (this.data.NSPath.get(i).length() <= length || !fullPath.startsWith(this.data.NSPath.get(i))) continue;
                Arrays.fill(indexs, this.data.NSPath.get(i).split("/").length - 2, indexs.length, i);
                length = this.data.NSPath.get(i).length();
            }
            StringBuilder newPath = new StringBuilder();
            String[] pathStrs = path.split("/");
            for (int i = 0; i < pathStrs.length; ++i) {
                String tmp = pathStrs[i];
                if (newPath.length() > 0) {
                    newPath.append("/");
                }
                if (!(tmp.length() <= 0 || tmp.contains(":") || tmp.contains(".") || tmp.contains("@"))) {
                    int index = indexs[i + indexs.length - pathStrs.length];
                    if (index >= 0) {
                        newPath.append("pre").append(index).append(":").append(tmp);
                        continue;
                    }
                    newPath.append(tmp);
                    continue;
                }
                newPath.append(tmp);
            }
            return newPath.toString();
        }
        return path;
    }

    private boolean applyXPath() {
        try {
            XPath xpath = this.data.document.createXPath(this.data.PathValue);
            if (this.meta.isNamespaceAware()) {
                xpath = this.data.document.createXPath(this.addNSPrefix(this.data.PathValue, this.data.PathValue));
                xpath.setNamespaceURIs(this.data.NAMESPACE);
            }
            this.data.an = xpath.selectNodes((Object)this.data.document);
            this.data.nodesize = this.data.an.size();
            this.data.nodenr = 0;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ErrorApplyXPath", (String[])new String[]{e.getMessage()}));
            return false;
        }
        return true;
    }

    private boolean openNextFile() {
        try {
            long fileSize;
            if (this.data.filenr >= this.data.files.nrOfFiles()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            this.data.file = this.data.files.getFile(this.data.filenr);
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                this.data.hidden = this.data.file.isHidden();
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                this.data.extension = this.data.file.getName().getExtension();
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                this.data.uriName = this.data.file.getName().getURI();
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                this.data.rootUriName = this.data.file.getName().getRootURI();
            }
            try {
                fileSize = this.data.file.getContent().getSize();
            }
            catch (FileSystemException e) {
                fileSize = -1L;
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                this.data.size = fileSize;
            }
            ++this.data.filenr;
            if (this.meta.isIgnoreEmptyFile() && fileSize == 0L) {
                this.logBasic(BaseMessages.getString(PKG, (String)"GetXMLData.Error.FileSizeZero", (String[])new String[]{"" + this.data.file.getName()}));
                this.openNextFile();
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
                }
                if (!this.setDocument(null, this.data.file, false, false)) {
                    if (this.data.stopPruning) {
                        return false;
                    }
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableCreateDocument", (String[])new String[0]));
                }
                if (this.data.prunePath == null && !this.applyXPath()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableApplyXPath", (String[])new String[0]));
                }
                this.addFileToResultFilesname(this.data.file);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopFileOccurences", (String[])new String[]{"" + this.data.nodesize, this.data.file.getName().getBaseName()}));
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first && !this.meta.isInFields()) {
            this.first = false;
            this.data.files = this.meta.getFiles((VariableSpace)this);
            if (!this.meta.isdoNotFailIfNoFile() && this.data.files.nrOfFiles() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Log.NoFiles", (String[])new String[0]));
            }
            this.handleMissingFiles();
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
        }
        Object[] r = this.getXMLRow();
        if (this.data.errorInRowButContinue) {
            return true;
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        return this.putRowOut(r);
    }

    private boolean putRowOut(Object[] r) throws KettleException {
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetXMLData.Log.ReadRow", (String[])new String[]{this.data.outputRowMeta.getString(r)}));
        }
        this.incrementLinesInput();
        ++this.data.rownr;
        this.putRow(this.data.outputRowMeta, r);
        if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getXMLRow() throws KettleException {
        if (!this.meta.isInFields()) {
            while (this.data.nodenr >= this.data.nodesize || this.data.file == null) {
                if (this.openNextFile()) continue;
                this.data.errorInRowButContinue = false;
                return null;
            }
        }
        return this.getXMLRowPutRowWithErrorhandling();
    }

    private Object[] getXMLRowPutRowWithErrorhandling() throws KettleException {
        Object[] r;
        this.data.errorInRowButContinue = false;
        try {
            if (this.meta.isInFields()) {
                while (this.data.nodenr >= this.data.nodesize || this.data.readrow == null) {
                    if (!this.ReadNextString()) {
                        return null;
                    }
                    if (this.data.readrow != null) continue;
                    return null;
                }
            }
            r = this.processPutRow(this.data.an.get(this.data.nodenr));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GetXMLData.Error.UnableReadFile", (String[])new String[0]), (Throwable)e);
        }
        return r;
    }

    private Object[] processPutRow(AbstractNode node) throws KettleException {
        Object[] outputRowData = this.buildEmptyRow();
        if (this.meta.isInFields()) {
            System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.nrReadRow);
        }
        try {
            RowMetaInterface irow;
            ++this.data.nodenr;
            for (int i = 0; i < this.data.nrInputFields; ++i) {
                String nodevalue;
                GetXMLDataField xmlDataField = this.meta.getInputFields()[i];
                String XPathValue = xmlDataField.getXPath();
                XPathValue = this.environmentSubstitute(XPathValue);
                if (xmlDataField.getElementType() == 1) {
                    int last = XPathValue.lastIndexOf("/");
                    if (last > -1) {
                        String attribut;
                        if (!(attribut = XPathValue.substring(++last, XPathValue.length())).startsWith("@")) {
                            XPathValue = XPathValue.substring(0, last) + "@" + attribut;
                        }
                    } else if (!XPathValue.startsWith("@")) {
                        XPathValue = "@" + XPathValue;
                    }
                }
                if (this.meta.isuseToken()) {
                    XPathValue = this.substituteToken(XPathValue, outputRowData);
                    if (this.isDetailed()) {
                        this.logDetailed(XPathValue);
                    }
                }
                if (this.meta.isNamespaceAware()) {
                    Node n;
                    XPath xpathField = node.createXPath(this.addNSPrefix(XPathValue, this.data.PathValue));
                    xpathField.setNamespaceURIs(this.data.NAMESPACE);
                    nodevalue = xmlDataField.getResultType() == 0 ? xpathField.valueOf((Object)node) : ((n = xpathField.selectSingleNode((Object)node)) != null ? n.asXML() : "");
                } else {
                    Node n;
                    nodevalue = xmlDataField.getResultType() == 0 ? node.valueOf(XPathValue) : ((n = node.selectSingleNode(XPathValue)) != null ? n.asXML() : "");
                }
                switch (xmlDataField.getTrimType()) {
                    case 1: {
                        nodevalue = Const.ltrim((String)nodevalue);
                        break;
                    }
                    case 2: {
                        nodevalue = Const.rtrim((String)nodevalue);
                        break;
                    }
                    case 3: {
                        nodevalue = Const.trim((String)nodevalue);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                outputRowData[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)nodevalue);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Utils.isEmpty((CharSequence)nodevalue)) continue;
                outputRowData[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.data.totalpreviousfields + this.data.nrInputFields;
            if (this.meta.includeFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                outputRowData[rowIndex++] = this.data.filename;
            }
            if (this.meta.includeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                outputRowData[rowIndex++] = this.data.rownr;
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                outputRowData[rowIndex++] = this.data.shortFilename;
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                outputRowData[rowIndex++] = this.data.extension;
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                outputRowData[rowIndex++] = this.data.path;
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                outputRowData[rowIndex++] = this.data.size;
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                outputRowData[rowIndex++] = Boolean.valueOf(this.data.path);
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                outputRowData[rowIndex++] = this.data.lastModificationDateTime;
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                outputRowData[rowIndex++] = this.data.uriName;
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                outputRowData[rowIndex] = this.data.rootUriName;
            }
            if ((irow = this.getInputRowMeta()) == null) {
                this.data.previousRow = outputRowData;
            } else {
                System.arraycopy(outputRowData, 0, this.prevRow, 0, outputRowData.length);
                this.data.previousRow = irow.cloneRow(outputRowData, this.prevRow);
            }
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.data.outputRowMeta, outputRowData, 1L, e.toString(), null, "GetXMLData001");
                this.data.errorInRowButContinue = true;
                return null;
            }
            this.logError(e.toString());
            throw new KettleException(e.toString());
        }
        return outputRowData;
    }

    public String substituteToken(String aString, Object[] outputRowData) {
        if (aString == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String rest = aString;
        int i = rest.indexOf(this.data.tokenStart);
        while (i > -1) {
            int j = rest.indexOf(this.data.tokenEnd, i + this.data.tokenStart.length());
            if (j > -1) {
                String varName;
                String Value = varName = rest.substring(i + this.data.tokenStart.length(), j);
                for (int k = 0; k < this.data.nrInputFields; ++k) {
                    GetXMLDataField Tmp_xmlInputField = this.meta.getInputFields()[k];
                    if (!Tmp_xmlInputField.getName().equalsIgnoreCase(varName)) continue;
                    Value = "'" + outputRowData[this.data.totalpreviousfields + k] + "'";
                }
                buffer.append(rest.substring(0, i));
                buffer.append((Object)Value);
                rest = rest.substring(j + this.data.tokenEnd.length());
            } else {
                buffer.append(rest);
                rest = "";
            }
            i = rest.indexOf(this.data.tokenEnd);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetXMLDataMeta)smi;
        this.data = (GetXMLDataData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.nrInputFields = this.meta.getInputFields().length;
            this.data.PathValue = this.environmentSubstitute(this.meta.getLoopXPath());
            if (Utils.isEmpty((CharSequence)this.data.PathValue)) {
                this.logError(BaseMessages.getString(PKG, (String)"GetXMLData.Error.EmptyPath", (String[])new String[0]));
                return false;
            }
            if (!this.data.PathValue.substring(0, 1).equals("/")) {
                this.data.PathValue = "/" + this.data.PathValue;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetXMLData.Log.LoopXPath", (String[])new String[]{this.data.PathValue}));
            }
            this.data.prunePath = this.environmentSubstitute(this.meta.getPrunePath());
            if (this.data.prunePath != null) {
                if (Utils.isEmpty((CharSequence)this.data.prunePath.trim())) {
                    this.data.prunePath = null;
                } else {
                    if (!this.data.prunePath.startsWith("/")) {
                        this.data.prunePath = "/" + this.data.prunePath;
                    }
                    if (this.meta.isInFields()) {
                        this.data.prunePath = null;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetXMLDataMeta)smi;
        this.data = (GetXMLDataData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.an != null) {
            this.data.an.clear();
            this.data.an = null;
        }
        if (this.data.NAMESPACE != null) {
            this.data.NAMESPACE.clear();
            this.data.NAMESPACE = null;
        }
        if (this.data.NSPath != null) {
            this.data.NSPath.clear();
            this.data.NSPath = null;
        }
        if (this.data.readrow != null) {
            this.data.readrow = null;
        }
        if (this.data.document != null) {
            this.data.document = null;
        }
        if (this.data.fr != null) {
            BaseStep.closeQuietly((Closeable)this.data.fr);
        }
        if (this.data.is != null) {
            BaseStep.closeQuietly((Closeable)this.data.is);
        }
        if (this.data.files != null) {
            this.data.files = null;
        }
        super.dispose(smi, sdi);
    }
}

