/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputstream;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinputstream.XMLInputStream;
import org.pentaho.di.trans.steps.xmlinputstream.XMLInputStreamData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="XMLInputStream", image="xml_input_stream.svg", i18nPackageName="org.pentaho.di.trans.steps.xmlinputstream", name="XMLInputStream.name", description="XMLInputStream.description", categoryDescription="XMLInputStream.category", documentationUrl="0L0/0Y0/0K0/XML_Input_Stream_(StAX)")
public class XMLInputStreamMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final int DEFAULT_STRING_LEN_FILENAME = 256;
    private static final int DEFAULT_STRING_LEN_PATH = 1024;
    public static final String DEFAULT_STRING_LEN = "1024";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String filename;
    private boolean addResultFile;
    private String nrRowsToSkip;
    private String rowLimit;
    private String defaultStringLen;
    private String encoding;
    private boolean enableNamespaces;
    private boolean enableTrim;
    private boolean includeFilenameField;
    private String filenameField;
    private boolean includeRowNumberField;
    private String rowNumberField;
    private boolean includeXmlDataTypeNumericField;
    private String xmlDataTypeNumericField;
    private boolean includeXmlDataTypeDescriptionField;
    private String xmlDataTypeDescriptionField;
    private boolean includeXmlLocationLineField;
    private String xmlLocationLineField;
    private boolean includeXmlLocationColumnField;
    private String xmlLocationColumnField;
    private boolean includeXmlElementIDField;
    private String xmlElementIDField;
    private boolean includeXmlParentElementIDField;
    private String xmlParentElementIDField;
    private boolean includeXmlElementLevelField;
    private String xmlElementLevelField;
    private boolean includeXmlPathField;
    private String xmlPathField;
    private boolean includeXmlParentPathField;
    private String xmlParentPathField;
    private boolean includeXmlDataNameField;
    private String xmlDataNameField;
    private boolean includeXmlDataValueField;
    private String xmlDataValueField;
    public boolean sourceFromInput;
    public String sourceFieldName;

    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) {
        ValueMetaString v;
        int defaultStringLenNameValueElements = Const.toInt((String)space.environmentSubstitute(this.defaultStringLen), (int)new Integer(DEFAULT_STRING_LEN));
        if (this.includeFilenameField) {
            v = new ValueMetaString(space.environmentSubstitute(this.filenameField));
            v.setLength(256);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumberField) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.rowNumberField));
            v.setLength(10);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeXmlDataTypeNumericField) {
            ValueMetaInteger vdtn = new ValueMetaInteger(space.environmentSubstitute(this.xmlDataTypeNumericField));
            vdtn.setLength(10);
            vdtn.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdtn);
        }
        if (this.includeXmlDataTypeDescriptionField) {
            ValueMetaString vdtd = new ValueMetaString(space.environmentSubstitute(this.xmlDataTypeDescriptionField));
            vdtd.setLength(25);
            vdtd.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdtd);
        }
        if (this.includeXmlLocationLineField) {
            ValueMetaInteger vline = new ValueMetaInteger(space.environmentSubstitute(this.xmlLocationLineField));
            vline.setLength(10);
            vline.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vline);
        }
        if (this.includeXmlLocationColumnField) {
            ValueMetaInteger vcol = new ValueMetaInteger(space.environmentSubstitute(this.xmlLocationColumnField));
            vcol.setLength(10);
            vcol.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vcol);
        }
        if (this.includeXmlElementIDField) {
            ValueMetaInteger vdid = new ValueMetaInteger("xml_element_id");
            vdid.setLength(10);
            vdid.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdid);
        }
        if (this.includeXmlParentElementIDField) {
            ValueMetaInteger vdparentid = new ValueMetaInteger("xml_parent_element_id");
            vdparentid.setLength(10);
            vdparentid.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdparentid);
        }
        if (this.includeXmlElementLevelField) {
            ValueMetaInteger vdlevel = new ValueMetaInteger("xml_element_level");
            vdlevel.setLength(10);
            vdlevel.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdlevel);
        }
        if (this.includeXmlPathField) {
            ValueMetaString vdparentxp = new ValueMetaString("xml_path");
            vdparentxp.setLength(1024);
            vdparentxp.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdparentxp);
        }
        if (this.includeXmlParentPathField) {
            ValueMetaString vdparentpxp = new ValueMetaString("xml_parent_path");
            vdparentpxp.setLength(1024);
            vdparentpxp.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdparentpxp);
        }
        if (this.includeXmlDataNameField) {
            ValueMetaString vdname = new ValueMetaString("xml_data_name");
            vdname.setLength(defaultStringLenNameValueElements);
            vdname.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdname);
        }
        if (this.includeXmlDataValueField) {
            ValueMetaString vdval = new ValueMetaString("xml_data_value");
            vdval.setLength(defaultStringLenNameValueElements);
            vdval.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)vdval);
        }
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.sourceFromInput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"sourceFromInput"));
            this.sourceFieldName = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"sourceFieldName"), (String)"");
            this.filename = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"filename"), (String)"");
            this.addResultFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addResultFile"));
            this.nrRowsToSkip = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"nrRowsToSkip"), (String)"0");
            this.rowLimit = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowLimit"), (String)"0");
            this.defaultStringLen = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"defaultStringLen"), (String)DEFAULT_STRING_LEN);
            this.encoding = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"encoding"), (String)DEFAULT_ENCODING);
            this.enableNamespaces = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enableNamespaces"));
            this.enableTrim = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enableTrim"));
            this.includeFilenameField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeFilenameField"));
            this.filenameField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"filenameField"), (String)this.filenameField);
            this.includeRowNumberField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeRowNumberField"));
            this.rowNumberField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"rowNumberField"), (String)this.rowNumberField);
            this.includeXmlDataTypeNumericField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeDataTypeNumericField"));
            this.xmlDataTypeNumericField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"dataTypeNumericField"), (String)this.xmlDataTypeNumericField);
            this.includeXmlDataTypeDescriptionField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeDataTypeDescriptionField"));
            this.xmlDataTypeDescriptionField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"dataTypeDescriptionField"), (String)this.xmlDataTypeDescriptionField);
            this.includeXmlLocationLineField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlLocationLineField"));
            this.xmlLocationLineField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlLocationLineField"), (String)this.xmlLocationLineField);
            this.includeXmlLocationColumnField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlLocationColumnField"));
            this.xmlLocationColumnField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlLocationColumnField"), (String)this.xmlLocationColumnField);
            this.includeXmlElementIDField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlElementIDField"));
            this.xmlElementIDField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlElementIDField"), (String)this.xmlElementIDField);
            this.includeXmlParentElementIDField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlParentElementIDField"));
            this.xmlParentElementIDField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlParentElementIDField"), (String)this.xmlParentElementIDField);
            this.includeXmlElementLevelField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlElementLevelField"));
            this.xmlElementLevelField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlElementLevelField"), (String)this.xmlElementLevelField);
            this.includeXmlPathField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlPathField"));
            this.xmlPathField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlPathField"), (String)this.xmlPathField);
            this.includeXmlParentPathField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlParentPathField"));
            this.xmlParentPathField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlParentPathField"), (String)this.xmlParentPathField);
            this.includeXmlDataNameField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlDataNameField"));
            this.xmlDataNameField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlDataNameField"), (String)this.xmlDataNameField);
            this.includeXmlDataValueField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"includeXmlDataValueField"));
            this.xmlDataValueField = Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"xmlDataValueField"), (String)this.xmlDataValueField);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public Object clone() {
        XMLInputStreamMeta retval = (XMLInputStreamMeta)((Object)super.clone());
        return retval;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"sourceFromInput", (boolean)this.sourceFromInput));
        retval.append("    " + XMLHandler.addTagValue((String)"sourceFieldName", (String)this.sourceFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    " + XMLHandler.addTagValue((String)"addResultFile", (boolean)this.addResultFile));
        retval.append("    " + XMLHandler.addTagValue((String)"nrRowsToSkip", (String)this.nrRowsToSkip));
        retval.append("    " + XMLHandler.addTagValue((String)"rowLimit", (String)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"defaultStringLen", (String)this.defaultStringLen));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"enableNamespaces", (boolean)this.enableNamespaces));
        retval.append("    " + XMLHandler.addTagValue((String)"enableTrim", (boolean)this.enableTrim));
        retval.append("    " + XMLHandler.addTagValue((String)"includeFilenameField", (boolean)this.includeFilenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"filenameField", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeRowNumberField", (boolean)this.includeRowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"rowNumberField", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeDataTypeNumericField", (boolean)this.includeXmlDataTypeNumericField));
        retval.append("    " + XMLHandler.addTagValue((String)"dataTypeNumericField", (String)this.xmlDataTypeNumericField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeDataTypeDescriptionField", (boolean)this.includeXmlDataTypeDescriptionField));
        retval.append("    " + XMLHandler.addTagValue((String)"dataTypeDescriptionField", (String)this.xmlDataTypeDescriptionField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlLocationLineField", (boolean)this.includeXmlLocationLineField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlLocationLineField", (String)this.xmlLocationLineField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlLocationColumnField", (boolean)this.includeXmlLocationColumnField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlLocationColumnField", (String)this.xmlLocationColumnField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlElementIDField", (boolean)this.includeXmlElementIDField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlElementIDField", (String)this.xmlElementIDField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlParentElementIDField", (boolean)this.includeXmlParentElementIDField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlParentElementIDField", (String)this.xmlParentElementIDField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlElementLevelField", (boolean)this.includeXmlElementLevelField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlElementLevelField", (String)this.xmlElementLevelField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlPathField", (boolean)this.includeXmlPathField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlPathField", (String)this.xmlPathField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlParentPathField", (boolean)this.includeXmlParentPathField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlParentPathField", (String)this.xmlParentPathField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlDataNameField", (boolean)this.includeXmlDataNameField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlDataNameField", (String)this.xmlDataNameField));
        retval.append("    " + XMLHandler.addTagValue((String)"includeXmlDataValueField", (boolean)this.includeXmlDataValueField));
        retval.append("    " + XMLHandler.addTagValue((String)"xmlDataValueField", (String)this.xmlDataValueField));
        return retval.toString();
    }

    public void setDefault() {
        this.filename = "";
        this.addResultFile = false;
        this.nrRowsToSkip = "0";
        this.rowLimit = "0";
        this.defaultStringLen = DEFAULT_STRING_LEN;
        this.encoding = DEFAULT_ENCODING;
        this.enableNamespaces = false;
        this.enableTrim = true;
        this.includeFilenameField = false;
        this.filenameField = "xml_filename";
        this.includeRowNumberField = false;
        this.rowNumberField = "xml_row_number";
        this.includeXmlDataTypeNumericField = false;
        this.xmlDataTypeNumericField = "xml_data_type_numeric";
        this.includeXmlDataTypeDescriptionField = true;
        this.xmlDataTypeDescriptionField = "xml_data_type_description";
        this.includeXmlLocationLineField = false;
        this.xmlLocationLineField = "xml_location_line";
        this.includeXmlLocationColumnField = false;
        this.xmlLocationColumnField = "xml_location_column";
        this.includeXmlElementIDField = true;
        this.xmlElementIDField = "xml_element_id";
        this.includeXmlParentElementIDField = true;
        this.xmlParentElementIDField = "xml_parent_element_id";
        this.includeXmlElementLevelField = true;
        this.xmlElementLevelField = "xml_element_level";
        this.includeXmlPathField = true;
        this.xmlPathField = "xml_path";
        this.includeXmlParentPathField = true;
        this.xmlParentPathField = "xml_parent_path";
        this.includeXmlDataNameField = true;
        this.xmlDataNameField = "xml_data_name";
        this.includeXmlDataValueField = true;
        this.xmlDataValueField = "xml_data_value";
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.sourceFromInput = rep.getStepAttributeBoolean(id_step, "sourceFromInput");
            this.sourceFieldName = Const.NVL((String)rep.getStepAttributeString(id_step, "sourceFieldName"), (String)"");
            this.filename = Const.NVL((String)rep.getStepAttributeString(id_step, "filename"), (String)"");
            this.addResultFile = rep.getStepAttributeBoolean(id_step, "addResultFile");
            this.nrRowsToSkip = Const.NVL((String)rep.getStepAttributeString(id_step, "nrRowsToSkip"), (String)"0");
            this.rowLimit = Const.NVL((String)rep.getStepAttributeString(id_step, "rowLimit"), (String)"0");
            this.defaultStringLen = Const.NVL((String)rep.getStepAttributeString(id_step, "defaultStringLen"), (String)DEFAULT_STRING_LEN);
            this.encoding = Const.NVL((String)rep.getStepAttributeString(id_step, "encoding"), (String)DEFAULT_ENCODING);
            this.enableNamespaces = rep.getStepAttributeBoolean(id_step, "enableNamespaces");
            this.enableTrim = rep.getStepAttributeBoolean(id_step, "enableTrim");
            this.includeFilenameField = rep.getStepAttributeBoolean(id_step, "includeFilenameField");
            this.filenameField = Const.NVL((String)rep.getStepAttributeString(id_step, "filenameField"), (String)this.filenameField);
            this.includeRowNumberField = rep.getStepAttributeBoolean(id_step, "includeRowNumberField");
            this.rowNumberField = Const.NVL((String)rep.getStepAttributeString(id_step, "rowNumberField"), (String)this.rowNumberField);
            this.includeXmlDataTypeNumericField = rep.getStepAttributeBoolean(id_step, "includeDataTypeNumericField");
            this.xmlDataTypeNumericField = Const.NVL((String)rep.getStepAttributeString(id_step, "dataTypeNumericField"), (String)this.xmlDataTypeNumericField);
            this.includeXmlDataTypeDescriptionField = rep.getStepAttributeBoolean(id_step, "includeDataTypeDescriptionField");
            this.xmlDataTypeDescriptionField = Const.NVL((String)rep.getStepAttributeString(id_step, "dataTypeDescriptionField"), (String)this.xmlDataTypeDescriptionField);
            this.includeXmlLocationLineField = rep.getStepAttributeBoolean(id_step, "includeXmlLocationLineField");
            this.xmlLocationLineField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlLocationLineField"), (String)this.xmlLocationLineField);
            this.includeXmlLocationColumnField = rep.getStepAttributeBoolean(id_step, "includeXmlLocationColumnField");
            this.xmlLocationColumnField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlLocationColumnField"), (String)this.xmlLocationColumnField);
            this.includeXmlElementIDField = rep.getStepAttributeBoolean(id_step, "includeXmlElementIDField");
            this.xmlElementIDField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlElementIDField"), (String)this.xmlElementIDField);
            this.includeXmlParentElementIDField = rep.getStepAttributeBoolean(id_step, "includeXmlParentElementIDField");
            this.xmlParentElementIDField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlParentElementIDField"), (String)this.xmlParentElementIDField);
            this.includeXmlElementLevelField = rep.getStepAttributeBoolean(id_step, "includeXmlElementLevelField");
            this.xmlElementLevelField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlElementLevelField"), (String)this.xmlElementLevelField);
            this.includeXmlPathField = rep.getStepAttributeBoolean(id_step, "includeXmlPathField");
            this.xmlPathField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlPathField"), (String)this.xmlPathField);
            this.includeXmlParentPathField = rep.getStepAttributeBoolean(id_step, "includeXmlParentPathField");
            this.xmlParentPathField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlParentPathField"), (String)this.xmlParentPathField);
            this.includeXmlDataNameField = rep.getStepAttributeBoolean(id_step, "includeXmlDataNameField");
            this.xmlDataNameField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlDataNameField"), (String)this.xmlDataNameField);
            this.includeXmlDataValueField = rep.getStepAttributeBoolean(id_step, "includeXmlDataValueField");
            this.xmlDataValueField = Const.NVL((String)rep.getStepAttributeString(id_step, "xmlDataValueField"), (String)this.xmlDataValueField);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "sourceFromInput", this.sourceFromInput);
            rep.saveStepAttribute(id_transformation, id_step, "sourceFieldName", this.sourceFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "addResultFile", this.addResultFile);
            rep.saveStepAttribute(id_transformation, id_step, "nrRowsToSkip", this.nrRowsToSkip);
            rep.saveStepAttribute(id_transformation, id_step, "rowLimit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "defaultStringLen", this.defaultStringLen);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "enableNamespaces", this.enableNamespaces);
            rep.saveStepAttribute(id_transformation, id_step, "enableTrim", this.enableTrim);
            rep.saveStepAttribute(id_transformation, id_step, "includeFilenameField", this.includeFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "filenameField", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "includeRowNumberField", this.includeRowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "rowNumberField", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "includeDataTypeNumericField", this.includeXmlDataTypeNumericField);
            rep.saveStepAttribute(id_transformation, id_step, "dataTypeNumericField", this.xmlDataTypeNumericField);
            rep.saveStepAttribute(id_transformation, id_step, "includeDataTypeDescriptionField", this.includeXmlDataTypeDescriptionField);
            rep.saveStepAttribute(id_transformation, id_step, "dataTypeDescriptionField", this.xmlDataTypeDescriptionField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlLocationLineField", this.includeXmlLocationLineField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlLocationLineField", this.xmlLocationLineField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlLocationColumnField", this.includeXmlLocationColumnField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlLocationColumnField", this.xmlLocationColumnField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlElementIDField", this.includeXmlElementIDField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlElementIDField", this.xmlElementIDField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlParentElementIDField", this.includeXmlParentElementIDField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlParentElementIDField", this.xmlParentElementIDField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlElementLevelField", this.includeXmlElementLevelField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlElementLevelField", this.xmlElementLevelField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlPathField", this.includeXmlPathField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlPathField", this.xmlPathField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlParentPathField", this.includeXmlParentPathField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlParentPathField", this.xmlParentPathField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlDataNameField", this.includeXmlDataNameField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlDataNameField", this.xmlDataNameField);
            rep.saveStepAttribute(id_transformation, id_step, "includeXmlDataValueField", this.includeXmlDataValueField);
            rep.saveStepAttribute(id_transformation, id_step, "xmlDataValueField", this.xmlDataValueField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.filename) ? new CheckResult(4, "Filename is not given", (CheckResultSourceInterface)stepMeta) : new CheckResult(1, "Filename is given", (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (transMeta.findNrPrevSteps(stepMeta) > 0) {
            try {
                RowMetaInterface previousFields = transMeta.getPrevStepFields(stepMeta);
                cr = null == previousFields.searchValueMeta(this.filename) ? new CheckResult(4, "Field name is not in previous step", (CheckResultSourceInterface)stepMeta) : new CheckResult(1, "Field name is in previous step", (CheckResultSourceInterface)stepMeta);
            }
            catch (KettleStepException e) {
                cr = new CheckResult(4, "Could not find previous step", (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.includeXmlDataTypeNumericField || this.includeXmlDataTypeDescriptionField ? new CheckResult(2, "At least one Data Type field (numeric or description) is in the data stream", (CheckResultSourceInterface)stepMeta) : new CheckResult(3, "Data Type field (numeric or description) is missing in the data stream", (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.includeXmlDataValueField && this.includeXmlDataNameField ? new CheckResult(2, "Data Name and Data Value fields are in the data stream", (CheckResultSourceInterface)stepMeta) : new CheckResult(3, "Both Data Name and Data Value fields should be in the data stream", (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLInputStream(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new XMLInputStreamData();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isAddResultFile() {
        return this.addResultFile;
    }

    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    public String getNrRowsToSkip() {
        return this.nrRowsToSkip;
    }

    public void setNrRowsToSkip(String nrRowsToSkip) {
        this.nrRowsToSkip = nrRowsToSkip;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getDefaultStringLen() {
        return this.defaultStringLen;
    }

    public void setDefaultStringLen(String defaultStringLen) {
        this.defaultStringLen = defaultStringLen;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    public void setEnableNamespaces(boolean enableNamespaces) {
        this.enableNamespaces = enableNamespaces;
    }

    public boolean isEnableTrim() {
        return this.enableTrim;
    }

    public void setEnableTrim(boolean enableTrim) {
        this.enableTrim = enableTrim;
    }

    public boolean isIncludeFilenameField() {
        return this.includeFilenameField;
    }

    public void setIncludeFilenameField(boolean includeFilenameField) {
        this.includeFilenameField = includeFilenameField;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludeRowNumberField() {
        return this.includeRowNumberField;
    }

    public void setIncludeRowNumberField(boolean includeRowNumberField) {
        this.includeRowNumberField = includeRowNumberField;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean isIncludeXmlDataTypeNumericField() {
        return this.includeXmlDataTypeNumericField;
    }

    public void setIncludeXmlDataTypeNumericField(boolean includeXmlDataTypeNumericField) {
        this.includeXmlDataTypeNumericField = includeXmlDataTypeNumericField;
    }

    public String getXmlDataTypeNumericField() {
        return this.xmlDataTypeNumericField;
    }

    public void setXmlDataTypeNumericField(String xmlDataTypeNumericField) {
        this.xmlDataTypeNumericField = xmlDataTypeNumericField;
    }

    public boolean isIncludeXmlDataTypeDescriptionField() {
        return this.includeXmlDataTypeDescriptionField;
    }

    public void setIncludeXmlDataTypeDescriptionField(boolean includeXmlDataTypeDescriptionField) {
        this.includeXmlDataTypeDescriptionField = includeXmlDataTypeDescriptionField;
    }

    public String getXmlDataTypeDescriptionField() {
        return this.xmlDataTypeDescriptionField;
    }

    public void setXmlDataTypeDescriptionField(String xmlDataTypeDescriptionField) {
        this.xmlDataTypeDescriptionField = xmlDataTypeDescriptionField;
    }

    public boolean isIncludeXmlLocationLineField() {
        return this.includeXmlLocationLineField;
    }

    public void setIncludeXmlLocationLineField(boolean includeXmlLocationLineField) {
        this.includeXmlLocationLineField = includeXmlLocationLineField;
    }

    public String getXmlLocationLineField() {
        return this.xmlLocationLineField;
    }

    public void setXmlLocationLineField(String xmlLocationLineField) {
        this.xmlLocationLineField = xmlLocationLineField;
    }

    public boolean isIncludeXmlLocationColumnField() {
        return this.includeXmlLocationColumnField;
    }

    public void setIncludeXmlLocationColumnField(boolean includeXmlLocationColumnField) {
        this.includeXmlLocationColumnField = includeXmlLocationColumnField;
    }

    public String getXmlLocationColumnField() {
        return this.xmlLocationColumnField;
    }

    public void setXmlLocationColumnField(String xmlLocationColumnField) {
        this.xmlLocationColumnField = xmlLocationColumnField;
    }

    public boolean isIncludeXmlElementIDField() {
        return this.includeXmlElementIDField;
    }

    public void setIncludeXmlElementIDField(boolean includeXmlElementIDField) {
        this.includeXmlElementIDField = includeXmlElementIDField;
    }

    public String getXmlElementIDField() {
        return this.xmlElementIDField;
    }

    public void setXmlElementIDField(String xmlElementIDField) {
        this.xmlElementIDField = xmlElementIDField;
    }

    public boolean isIncludeXmlParentElementIDField() {
        return this.includeXmlParentElementIDField;
    }

    public void setIncludeXmlParentElementIDField(boolean includeXmlParentElementIDField) {
        this.includeXmlParentElementIDField = includeXmlParentElementIDField;
    }

    public String getXmlParentElementIDField() {
        return this.xmlParentElementIDField;
    }

    public void setXmlParentElementIDField(String xmlParentElementIDField) {
        this.xmlParentElementIDField = xmlParentElementIDField;
    }

    public boolean isIncludeXmlElementLevelField() {
        return this.includeXmlElementLevelField;
    }

    public void setIncludeXmlElementLevelField(boolean includeXmlElementLevelField) {
        this.includeXmlElementLevelField = includeXmlElementLevelField;
    }

    public String getXmlElementLevelField() {
        return this.xmlElementLevelField;
    }

    public void setXmlElementLevelField(String xmlElementLevelField) {
        this.xmlElementLevelField = xmlElementLevelField;
    }

    public boolean isIncludeXmlPathField() {
        return this.includeXmlPathField;
    }

    public void setIncludeXmlPathField(boolean includeXmlPathField) {
        this.includeXmlPathField = includeXmlPathField;
    }

    public String getXmlPathField() {
        return this.xmlPathField;
    }

    public void setXmlPathField(String xmlPathField) {
        this.xmlPathField = xmlPathField;
    }

    public boolean isIncludeXmlParentPathField() {
        return this.includeXmlParentPathField;
    }

    public void setIncludeXmlParentPathField(boolean includeXmlParentPathField) {
        this.includeXmlParentPathField = includeXmlParentPathField;
    }

    public String getXmlParentPathField() {
        return this.xmlParentPathField;
    }

    public void setXmlParentPathField(String xmlParentPathField) {
        this.xmlParentPathField = xmlParentPathField;
    }

    public boolean isIncludeXmlDataNameField() {
        return this.includeXmlDataNameField;
    }

    public void setIncludeXmlDataNameField(boolean includeXmlDataNameField) {
        this.includeXmlDataNameField = includeXmlDataNameField;
    }

    public String getXmlDataNameField() {
        return this.xmlDataNameField;
    }

    public void setXmlDataNameField(String xmlDataNameField) {
        this.xmlDataNameField = xmlDataNameField;
    }

    public boolean isIncludeXmlDataValueField() {
        return this.includeXmlDataValueField;
    }

    public void setIncludeXmlDataValueField(boolean includeXmlDataValueField) {
        this.includeXmlDataValueField = includeXmlDataValueField;
    }

    public String getXmlDataValueField() {
        return this.xmlDataValueField;
    }

    public void setXmlDataValueField(String xmlDataValueField) {
        this.xmlDataValueField = xmlDataValueField;
    }
}

