/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalDistinctBag;
import org.apache.pig.data.SingleTupleBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class Distinct
extends EvalFunc<DataBag>
implements Algebraic {
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private static boolean initialized = false;
    private static boolean useDefaultBag = false;

    @Override
    public DataBag exec(Tuple input) throws IOException {
        return this.getDistinct(input);
    }

    @Override
    public String getFinal() {
        return Final.class.getName();
    }

    @Override
    public String getInitial() {
        return Initial.class.getName();
    }

    @Override
    public String getIntermed() {
        return Intermediate.class.getName();
    }

    private static DataBag createDataBag() {
        if (!initialized) {
            String bagType;
            initialized = true;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.distinct.type")) != null && bagType.equalsIgnoreCase("default")) {
                useDefaultBag = true;
            }
        }
        return useDefaultBag ? BagFactory.getInstance().newDistinctBag() : new InternalDistinctBag(3);
    }

    private static DataBag getDistinctFromNestedBags(Tuple input, EvalFunc evalFunc) throws IOException {
        DataBag result = Distinct.createDataBag();
        long progressCounter = 0L;
        DataBag bg = (DataBag)input.get(0);
        if (bg == null) {
            return result;
        }
        for (Tuple tuple : bg) {
            for (Tuple t : (DataBag)tuple.get(0)) {
                result.add(t);
                if (++progressCounter % 1000L != 0L) continue;
                evalFunc.progress();
            }
        }
        return result;
    }

    protected DataBag getDistinct(Tuple input) throws IOException {
        DataBag inputBg = (DataBag)input.get(0);
        DataBag result = Distinct.createDataBag();
        if (inputBg == null) {
            return result;
        }
        long progressCounter = 0L;
        for (Tuple tuple : inputBg) {
            result.add(tuple);
            if (++progressCounter % 1000L != 0L) continue;
            this.progress();
        }
        return result;
    }

    public static class Final
    extends EvalFunc<DataBag> {
        @Override
        public DataBag exec(Tuple input) throws IOException {
            return Distinct.getDistinctFromNestedBags(input, this);
        }
    }

    public static class Intermediate
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            return tupleFactory.newTuple(Distinct.getDistinctFromNestedBags(input, this));
        }
    }

    public static class Initial
    extends EvalFunc<Tuple> {
        @Override
        public Tuple exec(Tuple input) throws IOException {
            Tuple single = (Tuple)input.get(0);
            DataBag bag = single == null ? Distinct.createDataBag() : new SingleTupleBag(single);
            return tupleFactory.newTuple(bag);
        }
    }
}

