/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanDumper;
import org.apache.pig.impl.util.MultiMap;

public class DotPlanDumper<E extends Operator, P extends OperatorPlan<E>, N extends Operator, S extends OperatorPlan<N>>
extends PlanDumper<E, P, S> {
    protected Set<Operator> mSubgraphs;
    protected Set<Operator> mMultiInputSubgraphs;
    protected Set<Operator> mMultiOutputSubgraphs;
    private boolean isSubGraph = false;

    public DotPlanDumper(P plan, PrintStream ps) {
        this(plan, ps, false, new HashSet<Operator>(), new HashSet<Operator>(), new HashSet<Operator>());
    }

    protected DotPlanDumper(P plan, PrintStream ps, boolean isSubGraph, Set<Operator> mSubgraphs, Set<Operator> mMultiInputSubgraphs, Set<Operator> mMultiOutputSubgraphs) {
        super(plan, ps);
        this.isSubGraph = isSubGraph;
        this.mSubgraphs = mSubgraphs;
        this.mMultiInputSubgraphs = mMultiInputSubgraphs;
        this.mMultiOutputSubgraphs = mMultiOutputSubgraphs;
    }

    @Override
    public void dump() {
        if (!this.isSubGraph) {
            this.ps.println("digraph plan {");
            this.ps.println("compound=true;");
            this.ps.println("node [shape=rect];");
        }
        super.dump();
        if (!this.isSubGraph) {
            this.ps.println("}");
        }
    }

    @Override
    protected void dumpMultiInputNestedOperator(E op, MultiMap<E, S> plans) {
        this.dumpInvisibleOutput(op);
        this.ps.print("subgraph ");
        this.ps.print(this.getClusterID((Operator)op));
        this.ps.println(" {");
        this.join("; ", this.getAttributes(op));
        this.ps.println("labelloc=b;");
        this.mMultiInputSubgraphs.add((Operator)op);
        for (Operator o : plans.keySet()) {
            this.ps.print("subgraph ");
            this.ps.print(this.getClusterID((Operator)op, o));
            this.ps.println(" {");
            this.ps.println("label=\"\";");
            this.dumpInvisibleInput(op, o);
            for (OperatorPlan plan : plans.get(o)) {
                PlanDumper dumper = this.makeDumper(plan, this.ps);
                dumper.dump();
                this.connectInvisibleInput(op, o, plan);
            }
            this.ps.println("};");
        }
        this.ps.println("};");
        for (Operator o : plans.keySet()) {
            for (OperatorPlan plan : plans.get(o)) {
                this.connectInvisibleOutput(op, plan);
            }
        }
    }

    @Override
    protected void dumpMultiOutputNestedOperator(E op, Collection<S> plans) {
        super.dumpMultiOutputNestedOperator(op, plans);
        this.mMultiOutputSubgraphs.add((Operator)op);
        this.dumpInvisibleOutput(op);
        for (OperatorPlan plan : plans) {
            this.connectInvisibleOutput(op, plan);
        }
    }

    @Override
    protected void dumpNestedOperator(E op, Collection<S> plans) {
        this.dumpInvisibleOperators(op);
        this.ps.print("subgraph ");
        this.ps.print(this.getClusterID((Operator)op));
        this.ps.println(" {");
        this.join("; ", this.getAttributes(op));
        this.ps.println("labelloc=b;");
        this.mSubgraphs.add((Operator)op);
        for (OperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
            this.connectInvisibleInput(op, plan);
        }
        this.ps.println("};");
        for (OperatorPlan plan : plans) {
            this.connectInvisibleOutput(op, plan);
        }
    }

    @Override
    protected void dumpOperator(E op) {
        this.ps.print(this.getID((Operator)op));
        this.ps.print(" [");
        this.join(", ", this.getAttributes(op));
        this.ps.println("];");
    }

    @Override
    protected void dumpEdge(Operator op, Operator suc) {
        String in = this.getID(op);
        String out = this.getID(suc);
        String attributes = "";
        if (this.mMultiInputSubgraphs.contains(op) || this.mSubgraphs.contains(op) || this.mMultiOutputSubgraphs.contains(op)) {
            in = this.getSubgraphID(op, false);
        }
        this.ps.print(in);
        if (this.mMultiInputSubgraphs.contains(suc)) {
            out = this.getSubgraphID(suc, op, true);
            attributes = " [lhead=" + this.getClusterID(suc, op) + "]";
        }
        if (this.mSubgraphs.contains(suc)) {
            out = this.getSubgraphID(suc, true);
            attributes = " [lhead=" + this.getClusterID(suc) + "]";
        }
        this.ps.print(" -> ");
        this.ps.print(out);
        this.ps.println(attributes);
    }

    @Override
    protected PlanDumper makeDumper(S plan, PrintStream ps) {
        return new DotPlanDumper<E, S, N, S>(plan, ps, true, this.mSubgraphs, this.mMultiInputSubgraphs, this.mMultiOutputSubgraphs);
    }

    protected String getName(E op) {
        return ((Operator)op).name();
    }

    protected String[] getAttributes(E op) {
        String[] attributes = new String[]{"label=\"" + this.getName(op) + "\""};
        return attributes;
    }

    private void connectInvisibleInput(E op1, E op2, S plan) {
        String in = this.getSubgraphID((Operator)op1, (Operator)op2, true);
        for (Operator l : ((OperatorPlan)plan).getRoots()) {
            this.dumpInvisibleEdge(in, this.getID(l));
        }
    }

    private void connectInvisibleInput(E op, S plan) {
        String in = this.getSubgraphID((Operator)op, true);
        for (Operator l : ((OperatorPlan)plan).getRoots()) {
            String out = this.mSubgraphs.contains(l) || this.mMultiInputSubgraphs.contains(l) ? this.getSubgraphID(l, true) : this.getID(l);
            this.dumpInvisibleEdge(in, out);
        }
    }

    private void connectInvisibleOutput(E op, OperatorPlan<? extends Operator> plan) {
        String out = this.getSubgraphID((Operator)op, false);
        for (Operator operator : plan.getLeaves()) {
            String in = this.mSubgraphs.contains(operator) || this.mMultiInputSubgraphs.contains(operator) || this.mMultiOutputSubgraphs.contains(operator) ? this.getSubgraphID(operator, false) : this.getID(operator);
            this.dumpInvisibleEdge(in, out);
        }
    }

    private void connectInvisible(E op, S plan) {
        this.connectInvisibleInput(op, plan);
        this.connectInvisibleOutput(op, (OperatorPlan<? extends Operator>)plan);
    }

    private void dumpInvisibleInput(E op1, E op2) {
        this.ps.print(this.getSubgraphID((Operator)op1, (Operator)op2, true));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes((Operator)op1));
        this.ps.println(";");
    }

    private void dumpInvisibleInput(E op) {
        this.ps.print(this.getSubgraphID((Operator)op, true));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes((Operator)op));
        this.ps.println(";");
    }

    private void dumpInvisibleOutput(E op) {
        this.ps.print(this.getSubgraphID((Operator)op, false));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes((Operator)op));
        this.ps.println(";");
    }

    protected void dumpInvisibleOperators(E op) {
        this.dumpInvisibleInput(op);
        this.dumpInvisibleOutput(op);
    }

    private String getClusterID(Operator op1, Operator op2) {
        return this.getClusterID(op1) + "_" + this.getID(op2);
    }

    private String getClusterID(Operator op) {
        return "cluster_" + this.getID(op);
    }

    private String getSubgraphID(Operator op1, Operator op2, boolean in) {
        String id = "s" + this.getID(op1) + "_" + this.getID(op2);
        id = in ? id + "_in" : id + "_out";
        return id;
    }

    private String getSubgraphID(Operator op, boolean in) {
        String id = "s" + this.getID(op);
        id = in ? id + "_in" : id + "_out";
        return id;
    }

    private String getID(Operator op) {
        return "" + Math.abs(op.hashCode());
    }

    private String getInvisibleAttributes(Operator op) {
        return "[label=\"\", style=invis, height=0, width=0]";
    }

    private void dumpInvisibleEdge(String op, String suc) {
        this.ps.print(op);
        this.ps.print(" -> ");
        this.ps.print(suc);
        this.ps.println(" [style=invis];");
    }
}

