/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.visitor.UDFExpFinder;

public class UDFFinder
extends LogicalRelationalNodesVisitor {
    private List<UserFuncExpression> mUDFList = new ArrayList<UserFuncExpression>();

    public UDFFinder(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    public void visit(LOForEach foreach) throws FrontendException {
        LogicalPlan innerPlan = foreach.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
    }

    @Override
    public void visit(LOGenerate generate) throws FrontendException {
        for (LogicalExpressionPlan plan : generate.getOutputPlans()) {
            UDFExpFinder udfExpFinder = new UDFExpFinder(plan);
            udfExpFinder.visit();
            this.mUDFList.addAll(udfExpFinder.getUDFList());
        }
    }

    public List<UserFuncExpression> getUDFList() {
        return this.mUDFList;
    }
}

