/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCondition {
    public final CFDefinition.Name column;
    private final Term collectionElement;
    private final Term value;

    private ColumnCondition(CFDefinition.Name column, Term collectionElement, Term value) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
    }

    public static ColumnCondition equal(CFDefinition.Name column, Term value) {
        return new ColumnCondition(column, null, value);
    }

    public static ColumnCondition equal(CFDefinition.Name column, Term collectionElement, Term value) {
        return new ColumnCondition(column, collectionElement, value);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        this.value.collectMarkerSpecification(boundNames);
    }

    public WithVariables with(List<ByteBuffer> variables) {
        return new WithVariables(variables);
    }

    public static class Raw {
        private final Term.Raw value;
        private final Term.Raw collectionElement;

        private Raw(Term.Raw value, Term.Raw collectionElement) {
            this.value = value;
            this.collectionElement = collectionElement;
        }

        public static Raw simpleEqual(Term.Raw value) {
            return new Raw(value, null);
        }

        public static Raw collectionEqual(Term.Raw value, Term.Raw collectionElement) {
            return new Raw(value, collectionElement);
        }

        public ColumnCondition prepare(CFDefinition.Name receiver) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Condtions on counters are not supported");
            }
            if (this.collectionElement == null) {
                return ColumnCondition.equal(receiver, this.value.prepare(receiver));
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(Lists.indexSpecOf(receiver)), this.value.prepare(Lists.valueSpecOf(receiver)));
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                case MAP: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(Maps.keySpecOf(receiver)), this.value.prepare(Maps.valueSpecOf(receiver)));
                }
            }
            throw new AssertionError();
        }
    }

    public class WithVariables {
        private final List<ByteBuffer> variables;

        private WithVariables(List<ByteBuffer> variables) {
            this.variables = variables;
        }

        public boolean equalsTo(WithVariables other) throws InvalidRequestException {
            if (!this.column().equals(other.column())) {
                return false;
            }
            if (this.collectionElement() == null != (other.collectionElement() == null)) {
                return false;
            }
            if (this.collectionElement() != null) {
                Int32Type comparator;
                assert (ColumnCondition.this.column.type instanceof ListType || ColumnCondition.this.column.type instanceof MapType);
                AbstractType abstractType = comparator = ColumnCondition.this.column.type instanceof ListType ? Int32Type.instance : ((MapType)ColumnCondition.this.column.type).keys;
                if (comparator.compare(this.collectionElement().bindAndGet(this.variables), other.collectionElement().bindAndGet(this.variables)) != 0) {
                    return false;
                }
            }
            return this.value().bindAndGet(this.variables).equals(other.value().bindAndGet(other.variables));
        }

        private CFDefinition.Name column() {
            return ColumnCondition.this.column;
        }

        private Term collectionElement() {
            return ColumnCondition.this.collectionElement;
        }

        private Term value() {
            return ColumnCondition.this.value;
        }

        public ByteBuffer getCollectionElementValue() throws InvalidRequestException {
            return ColumnCondition.this.collectionElement == null ? null : ColumnCondition.this.collectionElement.bindAndGet(this.variables);
        }

        private ColumnNameBuilder copyOrUpdatePrefix(CFMetaData cfm, ColumnNameBuilder rowPrefix) {
            return ColumnCondition.this.column.kind == CFDefinition.Name.Kind.STATIC ? cfm.getStaticColumnNameBuilder() : rowPrefix.copy();
        }

        public boolean appliesTo(ColumnNameBuilder rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (ColumnCondition.this.column.type instanceof CollectionType) {
                return this.collectionAppliesTo((CollectionType)ColumnCondition.this.column.type, rowPrefix, current, now);
            }
            assert (ColumnCondition.this.collectionElement == null);
            ColumnNameBuilder prefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix);
            ByteBuffer columnName = ColumnCondition.this.column.kind == CFDefinition.Name.Kind.VALUE_ALIAS ? prefix.build() : prefix.add(ColumnCondition.this.column.name.key).build();
            Column c = current.getColumn(columnName);
            ByteBuffer v = ColumnCondition.this.value.bindAndGet(this.variables);
            return v == null ? c == null || !c.isLive(now) : c != null && c.isLive(now) && ColumnCondition.this.column.type.compare(c.value(), v) == 0;
        }

        private boolean collectionAppliesTo(CollectionType type, ColumnNameBuilder rowPrefix, ColumnFamily current, final long now) throws InvalidRequestException {
            ColumnNameBuilder collectionPrefix = this.copyOrUpdatePrefix(current.metadata(), rowPrefix).add(ColumnCondition.this.column.name.key);
            Term.Terminal v = ColumnCondition.this.value.bind(this.variables);
            if (ColumnCondition.this.collectionElement != null && type instanceof MapType) {
                ByteBuffer e = ColumnCondition.this.collectionElement.bindAndGet(this.variables);
                if (e == null) {
                    throw new InvalidRequestException("Invalid null value for map access");
                }
                return this.mapElementAppliesTo((MapType)type, current, collectionPrefix, e, v.get(), now);
            }
            ColumnSlice[] collectionSlice = new ColumnSlice[]{new ColumnSlice(collectionPrefix.build(), collectionPrefix.buildAsEndOfRange())};
            UnmodifiableIterator iter = Iterators.filter(current.iterator(collectionSlice), (Predicate)new Predicate<Column>(){

                public boolean apply(Column c) {
                    return c.isLive(now);
                }
            });
            if (v == null) {
                return !iter.hasNext();
            }
            if (ColumnCondition.this.collectionElement != null) {
                assert (type instanceof ListType);
                ByteBuffer e = ColumnCondition.this.collectionElement.bindAndGet(this.variables);
                if (e == null) {
                    throw new InvalidRequestException("Invalid null value for list access");
                }
                return this.listElementAppliesTo((ListType)type, (Iterator<Column>)iter, e, v.get());
            }
            switch (type.kind) {
                case LIST: {
                    return this.listAppliesTo((ListType)type, current.metadata(), (Iterator<Column>)iter, ((Lists.Value)v).elements);
                }
                case SET: {
                    return this.setAppliesTo((SetType)type, current.metadata(), (Iterator<Column>)iter, ((Sets.Value)v).elements);
                }
                case MAP: {
                    return this.mapAppliesTo((MapType)type, current.metadata(), (Iterator<Column>)iter, ((Maps.Value)v).map);
                }
            }
            throw new AssertionError();
        }

        private ByteBuffer collectionKey(CFMetaData cfm, Column c) {
            ByteBuffer[] bbs = ((CompositeType)cfm.comparator).split(c.name());
            return bbs[bbs.length - 1];
        }

        private boolean listAppliesTo(ListType type, CFMetaData cfm, Iterator<Column> iter, List<ByteBuffer> elements) {
            for (ByteBuffer e : elements) {
                if (iter.hasNext() && type.elements.compare(iter.next().value(), e) == 0) continue;
                return false;
            }
            return !iter.hasNext();
        }

        private boolean listElementAppliesTo(ListType type, Iterator<Column> iter, ByteBuffer element, ByteBuffer value) throws InvalidRequestException {
            int idx = ByteBufferUtil.toInt(element);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            int adv = Iterators.advance(iter, (int)idx);
            if (adv != idx || !iter.hasNext()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, adv));
            }
            return type.elements.compare(iter.next().value(), value) == 0;
        }

        private boolean setAppliesTo(SetType type, CFMetaData cfm, Iterator<Column> iter, Set<ByteBuffer> elements) {
            TreeSet<ByteBuffer> remaining = new TreeSet<ByteBuffer>(type.elements);
            remaining.addAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                if (remaining.remove(this.collectionKey(cfm, iter.next()))) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapAppliesTo(MapType type, CFMetaData cfm, Iterator<Column> iter, Map<ByteBuffer, ByteBuffer> elements) {
            TreeMap<ByteBuffer, ByteBuffer> remaining = new TreeMap<ByteBuffer, ByteBuffer>(type.keys);
            remaining.putAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                Column c = iter.next();
                ByteBuffer previous = (ByteBuffer)remaining.remove(this.collectionKey(cfm, c));
                if (previous != null && type.values.compare(previous, c.value()) == 0) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapElementAppliesTo(MapType type, ColumnFamily current, ColumnNameBuilder collectionPrefix, ByteBuffer element, ByteBuffer value, long now) {
            ByteBuffer name = collectionPrefix.add(element).build();
            Column c = current.getColumn(name);
            return c != null && c.isLive(now) && type.values.compare(c.value(), value) == 0;
        }
    }
}

