/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXConfigurableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.repair.RepairFuture;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.SyncComplete;
import org.apache.cassandra.repair.messages.ValidationComplete;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class ActiveRepairService {
    public static final ActiveRepairService instance = new ActiveRepairService();
    private static final ThreadPoolExecutor executor = new JMXConfigurableThreadPoolExecutor(4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("AntiEntropySessions"), "internal");
    private final ConcurrentMap<UUID, RepairSession> sessions = new ConcurrentHashMap<UUID, RepairSession>();

    protected ActiveRepairService() {
    }

    public RepairFuture submitRepairSession(Range<Token> range, String keyspace, boolean isSequential, Collection<String> dataCenters, Collection<String> hosts, String ... cfnames) {
        RepairSession session = new RepairSession(range, keyspace, isSequential, dataCenters, hosts, cfnames);
        if (session.endpoints.isEmpty()) {
            return null;
        }
        RepairFuture futureTask = new RepairFuture(session);
        executor.execute(futureTask);
        return futureTask;
    }

    public void addToActiveSessions(RepairSession session) {
        this.sessions.put(session.getId(), session);
        Gossiper.instance.register(session);
        FailureDetector.instance.registerFailureDetectionEventListener(session);
    }

    public void removeFromActiveSessions(RepairSession session) {
        FailureDetector.instance.unregisterFailureDetectionEventListener(session);
        Gossiper.instance.unregister(session);
        this.sessions.remove(session.getId());
    }

    public void terminateSessions() {
        for (RepairSession session : this.sessions.values()) {
            session.forceShutdown();
        }
    }

    RepairFuture submitArtificialRepairSession(RepairJobDesc desc) {
        RepairSession session = new RepairSession(desc.sessionId, desc.range, desc.keyspace, false, null, null, new String[]{desc.columnFamily});
        this.sessions.put(session.getId(), session);
        RepairFuture futureTask = new RepairFuture(session);
        executor.execute(futureTask);
        return futureTask;
    }

    public static Set<InetAddress> getNeighbors(String keyspaceName, Range<Token> toRepair, Collection<String> dataCenters, Collection<String> hosts) {
        if (dataCenters != null && !dataCenters.contains(DatabaseDescriptor.getLocalDataCenter())) {
            throw new IllegalArgumentException("The local data center must be part of the repair");
        }
        StorageService ss = StorageService.instance;
        Map<Range<Token>, List<InetAddress>> replicaSets = ss.getRangeToAddressMap(keyspaceName);
        Range<Token> rangeSuperSet = null;
        for (Range<Token> range : ss.getLocalRanges(keyspaceName)) {
            if (range.contains((Token)((Object)toRepair))) {
                rangeSuperSet = range;
                break;
            }
            if (!range.intersects(toRepair)) continue;
            throw new IllegalArgumentException("Requested range intersects a local range but is not fully contained in one; this would lead to imprecise repair");
        }
        if (rangeSuperSet == null || !replicaSets.containsKey(rangeSuperSet)) {
            return Collections.emptySet();
        }
        HashSet<InetAddress> neighbors = new HashSet<InetAddress>((Collection)replicaSets.get(rangeSuperSet));
        neighbors.remove(FBUtilities.getBroadcastAddress());
        if (dataCenters != null) {
            TokenMetadata.Topology topology = ss.getTokenMetadata().cloneOnlyTokenMap().getTopology();
            HashSet dcEndpoints = Sets.newHashSet();
            Multimap<String, InetAddress> dcEndpointsMap = topology.getDatacenterEndpoints();
            for (String dc : dataCenters) {
                Collection c = dcEndpointsMap.get((Object)dc);
                if (c == null) continue;
                dcEndpoints.addAll(c);
            }
            return Sets.intersection(neighbors, (Set)dcEndpoints);
        }
        if (hosts != null) {
            HashSet<InetAddress> specifiedHost = new HashSet<InetAddress>();
            for (String host : hosts) {
                try {
                    InetAddress endpoint = InetAddress.getByName(host.trim());
                    if (!endpoint.equals(FBUtilities.getBroadcastAddress()) && !neighbors.contains(endpoint)) continue;
                    specifiedHost.add(endpoint);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Unknown host specified " + host, e);
                }
            }
            if (!specifiedHost.contains(FBUtilities.getBroadcastAddress())) {
                throw new IllegalArgumentException("The current host must be part of the repair");
            }
            if (specifiedHost.size() <= 1) {
                String msg = "Repair requires at least two endpoints that are neighbours before it can continue, the endpoint used for this repair is %s, other available neighbours are %s but these neighbours were not part of the supplied list of hosts to use during the repair (%s).";
                throw new IllegalArgumentException(String.format(msg, specifiedHost, neighbors, hosts));
            }
            specifiedHost.remove(FBUtilities.getBroadcastAddress());
            return specifiedHost;
        }
        return neighbors;
    }

    public void handleMessage(InetAddress endpoint, RepairMessage message) {
        RepairJobDesc desc = message.desc;
        RepairSession session = (RepairSession)this.sessions.get(desc.sessionId);
        if (session == null) {
            return;
        }
        switch (message.messageType) {
            case VALIDATION_COMPLETE: {
                ValidationComplete validation = (ValidationComplete)message;
                session.validationComplete(desc, endpoint, validation.tree);
                break;
            }
            case SYNC_COMPLETE: {
                SyncComplete sync = (SyncComplete)message;
                session.syncComplete(desc, sync.nodes, sync.success);
                break;
            }
        }
    }

    public static enum Status {
        STARTED,
        SESSION_SUCCESS,
        SESSION_FAILED,
        FINISHED;

    }
}

