/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle.embedded;

import java.util.ArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;

public class TransformationParameterHelper {
    private AbstractKettleTransformationProducer transformationProducer;
    private DataFactoryContext dataFactoryContext;
    private KettleParameterInfo[] parameters;

    public TransformationParameterHelper(AbstractKettleTransformationProducer transformationProducer, DataFactoryContext dataFactoryContext) {
        this.dataFactoryContext = dataFactoryContext;
        ArgumentNullException.validate((String)"transformationProducer", (Object)transformationProducer);
        this.transformationProducer = transformationProducer;
    }

    public KettleParameterInfo[] getDeclaredParameter() throws KettleException, ReportDataFactoryException {
        if (this.parameters == null) {
            TransMeta transMeta = this.transformationProducer.loadTransformation(this.dataFactoryContext);
            String[] parameterNames = transMeta.listParameters();
            ArrayList<KettleParameterInfo> infos = new ArrayList<KettleParameterInfo>();
            for (String parameterName : parameterNames) {
                String defaultValue = transMeta.getParameterDefault(parameterName);
                String description = transMeta.getParameterDescription(parameterName);
                infos.add(new KettleParameterInfo(parameterName, description, defaultValue));
            }
            this.parameters = infos.toArray(new KettleParameterInfo[infos.size()]);
        }
        return this.parameters;
    }
}

