/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle.embedded;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.trans.step.BaseStepGenericXulDialog;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.swing.tags.SwingDialog;

public class XulDialogHelper {
    private static final Log logger = LogFactory.getLog(XulDialogHelper.class);
    private BaseStepGenericXulDialog dialog;
    private TransMeta transformation;
    private ArrayList<ChangeListener> changeListeners;
    private JComponent editor;

    public XulDialogHelper(TransMeta transformation) {
        this.transformation = transformation;
        this.changeListeners = new ArrayList();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public JComponent createEditor() throws ReportDataFactoryException {
        if (this.editor != null) {
            return this.editor;
        }
        this.dialog = this.createDialog();
        if (this.dialog == null) {
            this.editor = new JPanel();
            return this.editor;
        }
        this.dialog.addPropertyChangeListener((PropertyChangeListener)new ChangeHandler());
        this.dialog.validate();
        XulComponent root = this.dialog.getXulDomContainer().getDocumentRoot().getElementById("root");
        SwingDialog parent = (SwingDialog)root.getParent();
        JComponent panel = parent.getContainer();
        this.dialog.setModalParent((Object)panel);
        this.editor = panel;
        return panel;
    }

    private BaseStepGenericXulDialog createDialog() throws ReportDataFactoryException {
        StepMeta step = this.findInputStep();
        if (step == null) {
            return null;
        }
        try {
            String dlgClassName = step.getStepMetaInterface().getDialogClassName().replace("Dialog", "XulDialog");
            ClassLoader pluginClassLoader = step.getStepMetaInterface().getClass().getClassLoader();
            Class<?> dialog = Class.forName(dlgClassName, true, pluginClassLoader);
            Constructor<?> constructor = dialog.getDeclaredConstructor(Object.class, BaseStepMeta.class, TransMeta.class, String.class);
            return (BaseStepGenericXulDialog)constructor.newInstance(null, step.getStepMetaInterface(), step.getParentTransMeta(), "input");
        }
        catch (Exception e) {
            logger.error((Object)"Critical error attempting to dynamically create dialog. This datasource will not be available.", (Throwable)e);
            throw new ReportDataFactoryException("Error attempting to dynamically create dialog. Abort dialog rendering.");
        }
    }

    private StepMeta findInputStep() {
        return this.transformation.findStep("input");
    }

    public boolean validate() {
        if (this.dialog != null) {
            return this.dialog.validate();
        }
        return true;
    }

    public void accept() {
        if (this.dialog != null) {
            this.dialog.onAccept();
        }
    }

    public byte[] getRawData() throws KettleException {
        this.accept();
        try {
            return this.transformation.getXML().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void clear() {
        if (this.dialog != null) {
            this.dialog.clear();
        }
    }

    private class ChangeHandler
    implements PropertyChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ChangeEvent event = new ChangeEvent(this);
            for (int i = 0; i < XulDialogHelper.this.changeListeners.size(); ++i) {
                ChangeListener listener = (ChangeListener)XulDialogHelper.this.changeListeners.get(i);
                listener.stateChanged(event);
            }
        }
    }
}

