/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle.parameter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.table.FormulaFragmentCellEditor;
import org.pentaho.openformula.ui.table.FormulaFragmentCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.icons.IconLoader;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTable;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.ui.datasources.kettle.parameter.ArgumentCountCellRenderer;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FilteringParameterTableModel;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterEntity;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterEntityCellEditor;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterFilterStrategy;
import org.pentaho.reporting.ui.datasources.kettle.parameter.FormulaParameterTableModel;
import org.pentaho.reporting.ui.datasources.kettle.parameter.Messages;

public class FormulaParameterEditor
extends JComponent {
    public static final String FORMULA_PARAMETER_PROPERTY = "formulaParameter";
    private FormulaParameterTableModel parameterTableModel;
    private FormulaFragmentCellEditor systemParameterEditor;
    private FormulaFragmentCellEditor argumentParameterEditor;
    private PropertyTable systemParameterTable;
    private PropertyTable argumentParameterTable;
    private RemoveParameterAction removeParameterAction;
    private RemoveParameterAction removeArgumentAction;
    private AddParameterAction addParameterAction;
    private AddArgumentAction addArgumentAction;

    public FormulaParameterEditor() {
        this.setLayout(new BorderLayout());
        this.parameterTableModel = new FormulaParameterTableModel();
        this.parameterTableModel.addTableModelListener(new ParameterChangeHandler());
        this.systemParameterEditor = new FormulaFragmentCellEditor();
        this.systemParameterTable = new PropertyTable();
        this.systemParameterTable.setDefaultEditor(String.class, (TableCellEditor)this.systemParameterEditor);
        this.systemParameterTable.setDefaultEditor(FormulaParameterEntity.class, (TableCellEditor)new FormulaParameterEntityCellEditor());
        this.systemParameterTable.setDefaultRenderer(String.class, (TableCellRenderer)new FormulaFragmentCellRenderer());
        this.systemParameterTable.setModel((TableModel)((Object)new FilteringParameterTableModel(new FormulaParameterFilterStrategy(FormulaParameterEntity.Type.PARAMETER), this.parameterTableModel)));
        FilteringParameterTableModel dataModel = new FilteringParameterTableModel(new FormulaParameterFilterStrategy(FormulaParameterEntity.Type.ARGUMENT), this.parameterTableModel);
        this.argumentParameterEditor = new FormulaFragmentCellEditor();
        this.argumentParameterTable = new PropertyTable();
        this.argumentParameterTable.setDefaultEditor(String.class, (TableCellEditor)this.argumentParameterEditor);
        this.argumentParameterTable.setDefaultRenderer(String.class, (TableCellRenderer)new FormulaFragmentCellRenderer());
        this.argumentParameterTable.setDefaultRenderer(FormulaParameterEntity.class, (TableCellRenderer)new ArgumentCountCellRenderer());
        this.argumentParameterTable.setModel((TableModel)((Object)dataModel));
        this.removeParameterAction = new RemoveParameterAction((JTable)this.systemParameterTable);
        this.removeArgumentAction = new RemoveParameterAction((JTable)this.argumentParameterTable);
        this.addParameterAction = new AddParameterAction();
        this.addArgumentAction = new AddArgumentAction();
        this.rebuildUi();
    }

    private void rebuildUi() {
        this.removeAll();
        JPanel systemTablePanel = new JPanel(new BorderLayout());
        systemTablePanel.add((Component)new JScrollPane((Component)this.systemParameterTable), "Center");
        systemTablePanel.add((Component)this.createButtonPanel(this.addParameterAction, this.removeParameterAction), "North");
        JPanel manualTablePanel = new JPanel(new BorderLayout());
        manualTablePanel.add((Component)new JScrollPane((Component)this.argumentParameterTable), "Center");
        manualTablePanel.add((Component)this.createButtonPanel(this.addArgumentAction, this.removeArgumentAction), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getInstance().getString("FormulaParameterEditor.Tab.Parameter"), systemTablePanel);
        tabbedPane.addTab(Messages.getInstance().getString("FormulaParameterEditor.Tab.Arguments"), manualTablePanel);
        this.add((Component)tabbedPane, "Center");
    }

    private JPanel createButtonPanel(Action addAction, Action removeAction) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add((Component)new BorderlessButton(addAction));
        buttonPanel.add((Component)new BorderlessButton(removeAction));
        return buttonPanel;
    }

    public void setFields(FieldDefinition[] fields) {
        this.systemParameterEditor.setFields(fields);
        this.argumentParameterEditor.setFields(fields);
    }

    public void setFormulaParameter(FormulaParameterEntity[] parameter) {
        Object[] oldParameter = this.parameterTableModel.getData();
        this.parameterTableModel.setData(parameter);
        if (!Arrays.equals(oldParameter, parameter)) {
            this.firePropertyChange(FORMULA_PARAMETER_PROPERTY, oldParameter, parameter);
        }
    }

    public FormulaParameterEntity[] getFormulaParameter() {
        return this.parameterTableModel.getData();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.systemParameterTable.setEnabled(enabled);
        this.argumentParameterTable.setEnabled(enabled);
        this.removeParameterAction.setEnabled(enabled);
        this.removeArgumentAction.setEnabled(enabled);
        this.addParameterAction.setEnabled(enabled);
        this.addArgumentAction.setEnabled(enabled);
    }

    public void setFormulaContext(FormulaContext context) {
        this.argumentParameterEditor.setFormulaContext(context);
    }

    protected void insertNewEntry(int idx, FormulaParameterEntity entity) {
        FormulaParameterEntity[] data = this.parameterTableModel.getData();
        ArrayList<FormulaParameterEntity> data2 = new ArrayList<FormulaParameterEntity>(Arrays.asList(data));
        if (idx == -1) {
            data2.add(entity);
        } else {
            data2.add(idx, entity);
        }
        this.parameterTableModel.setData(data2.toArray(new FormulaParameterEntity[data2.size()]));
    }

    private class ParameterChangeHandler
    implements TableModelListener {
        private FormulaParameterEntity[] oldData;

        private ParameterChangeHandler() {
            this.oldData = FormulaParameterEditor.this.parameterTableModel.getData();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            FormulaParameterEntity[] newParams = FormulaParameterEditor.this.getFormulaParameter();
            FormulaParameterEditor.this.firePropertyChange(FormulaParameterEditor.FORMULA_PARAMETER_PROPERTY, this.oldData, newParams);
            this.oldData = newParams;
        }
    }

    private class RemoveParameterAction
    extends AbstractAction
    implements ListSelectionListener {
        private FilteringParameterTableModel model;
        private JTable table;

        private RemoveParameterAction(JTable table) {
            this.model = (FilteringParameterTableModel)((Object)table.getModel());
            this.table = table;
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", Messages.getInstance().getString("FormulaParameterEditor.Remove"));
            this.setEnabled(false);
            table.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selectedRows = this.table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                FormulaParameterEntity.Type type = FormulaParameterEditor.this.parameterTableModel.getParameterType(this.model.mapToModel(row));
                if (FormulaParameterEntity.Type.ARGUMENT != type) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            FormulaParameterEntity[] data = FormulaParameterEditor.this.parameterTableModel.getData();
            ListSelectionModel listSelectionModel = this.table.getSelectionModel();
            ArrayList<FormulaParameterEntity> result = new ArrayList<FormulaParameterEntity>(data.length);
            for (int i = 0; i < data.length; ++i) {
                FormulaParameterEntity parameter = data[i];
                if (parameter == null || listSelectionModel.isSelectedIndex(this.model.mapFromModel(i))) continue;
                result.add(data[i]);
            }
            FormulaParameterEditor.this.parameterTableModel.setData(result.toArray(new FormulaParameterEntity[result.size()]));
        }
    }

    private class AddParameterAction
    extends AbstractAction {
        private AddParameterAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", Messages.getInstance().getString("FormulaParameterEditor.Add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String parameterName = "parameter";
            FormulaParameterEntity entity = new FormulaParameterEntity(FormulaParameterEntity.Type.PARAMETER, parameterName, null);
            int idx = FormulaParameterEditor.this.systemParameterTable.getSelectedRow();
            FormulaParameterEditor.this.insertNewEntry(idx, entity);
        }
    }

    private class AddArgumentAction
    extends AbstractAction {
        private AddArgumentAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getAddIcon());
            this.putValue("ShortDescription", Messages.getInstance().getString("FormulaParameterEditor.Add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormulaParameterEntity entity = new FormulaParameterEntity(FormulaParameterEntity.Type.ARGUMENT, String.format("ZZZ%012d", System.currentTimeMillis()), null);
            int idx = FormulaParameterEditor.this.argumentParameterTable.getSelectedRow();
            FormulaParameterEditor.this.insertNewEntry(idx, entity);
        }
    }
}

