/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hive;

import com.pentaho.big.data.bundles.impl.shim.hive.HiveDriver;
import com.pentaho.big.data.bundles.impl.shim.hive.HiveSimbaDriver;
import com.pentaho.big.data.bundles.impl.shim.hive.ImpalaDriver;
import com.pentaho.big.data.bundles.impl.shim.hive.ImpalaSimbaDriver;
import com.pentaho.big.data.bundles.impl.shim.hive.SparkSimbaDriver;
import java.sql.Driver;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.pentaho.big.data.api.jdbc.JdbcUrlParser;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.hadoop.HadoopConfigurationListener;
import org.pentaho.hadoop.shim.ConfigurationException;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShimDriverLoader
implements HadoopConfigurationListener {
    public static final String HIVE = "hive";
    public static final String HIVE_2 = "hive2";
    public static final String HIVE_2_SIMBA = "hive2Simba";
    public static final String IMPALA = "Impala";
    public static final String IMPALA_SIMBA = "ImpalaSimba";
    public static final String SPARK_SIMBA = "SparkSqlSimba";
    private final Logger LOGGER = LoggerFactory.getLogger(ShimDriverLoader.class);
    private final JdbcUrlParser jdbcUrlParser;
    private final ConcurrentMap<HadoopConfiguration, ConcurrentMap<String, ServiceRegistration>> configMap;
    private final Map<String, DriverFactory> hiveDriverFactoryMap;
    private final BundleContext bundleContext;

    public ShimDriverLoader(JdbcUrlParser jdbcUrlParser, BundleContext bundleContext) {
        this(jdbcUrlParser, bundleContext, HadoopConfigurationBootstrap.getInstance(), ShimDriverLoader.initHiveDriverFactoryMap());
    }

    public ShimDriverLoader(JdbcUrlParser jdbcUrlParser, BundleContext bundleContext, HadoopConfigurationBootstrap hadoopConfigurationBootstrap) {
        this(jdbcUrlParser, bundleContext, hadoopConfigurationBootstrap, ShimDriverLoader.initHiveDriverFactoryMap());
    }

    public ShimDriverLoader(JdbcUrlParser jdbcUrlParser, BundleContext bundleContext, HadoopConfigurationBootstrap hadoopConfigurationBootstrap, Map<String, DriverFactory> hiveDriverFactoryMap) {
        this.jdbcUrlParser = jdbcUrlParser;
        this.bundleContext = bundleContext;
        this.configMap = new ConcurrentHashMap<HadoopConfiguration, ConcurrentMap<String, ServiceRegistration>>();
        this.hiveDriverFactoryMap = new ConcurrentHashMap<String, DriverFactory>(hiveDriverFactoryMap);
        try {
            hadoopConfigurationBootstrap.registerHadoopConfigurationListener((HadoopConfigurationListener)this);
        }
        catch (ConfigurationException e) {
            this.LOGGER.error("Unable to register " + this, (Throwable)e);
        }
    }

    private static Map<String, DriverFactory> initHiveDriverFactoryMap() {
        HashMap<String, DriverFactory> hiveDriverFactoryMap = new HashMap<String, DriverFactory>();
        hiveDriverFactoryMap.put(HIVE, HiveDriver::new);
        hiveDriverFactoryMap.put(HIVE_2, HiveDriver::new);
        hiveDriverFactoryMap.put(HIVE_2_SIMBA, HiveSimbaDriver::new);
        hiveDriverFactoryMap.put(IMPALA, ImpalaDriver::new);
        hiveDriverFactoryMap.put(IMPALA_SIMBA, ImpalaSimbaDriver::new);
        hiveDriverFactoryMap.put(SPARK_SIMBA, SparkSimbaDriver::new);
        return hiveDriverFactoryMap;
    }

    public void onClassLoaderAvailable(ClassLoader classLoader) {
    }

    public void onConfigurationOpen(HadoopConfiguration hadoopConfiguration, boolean defaultConfiguration) {
        if (hadoopConfiguration == null) {
            return;
        }
        this.configMap.put(hadoopConfiguration, this.hiveDriverFactoryMap.entrySet().stream().map(pair -> {
            Driver jdbcDriver;
            try {
                jdbcDriver = hadoopConfiguration.getHadoopShim().getJdbcDriver((String)pair.getKey());
            }
            catch (Throwable e) {
                return null;
            }
            if (jdbcDriver == null) {
                return null;
            }
            Driver hiveDriver = ((DriverFactory)pair.getValue()).create(jdbcDriver, hadoopConfiguration.getIdentifier(), defaultConfiguration, this.jdbcUrlParser);
            if (hiveDriver == null) {
                return null;
            }
            Hashtable<String, String> dictionary = new Hashtable<String, String>();
            ((Dictionary)dictionary).put("dataSourceType", "bigdata");
            final ServiceRegistration serviceRegistration = this.bundleContext.registerService(Driver.class.getCanonicalName(), (Object)hiveDriver, dictionary);
            return new Map.Entry<String, ServiceRegistration>(){

                @Override
                public String getKey() {
                    return (String)pair.getKey();
                }

                @Override
                public ServiceRegistration getValue() {
                    return serviceRegistration;
                }

                @Override
                public ServiceRegistration setValue(ServiceRegistration value) {
                    throw new UnsupportedOperationException();
                }
            };
        }).filter(Objects::nonNull).collect(Collectors.toMap(entry -> entry.getKey(), entry -> entry.getValue(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, ConcurrentHashMap::new)));
    }

    public void onConfigurationClose(HadoopConfiguration hadoopConfiguration) {
        if (hadoopConfiguration == null) {
            return;
        }
        Map hiveDrivers = (Map)this.configMap.remove(hadoopConfiguration);
        if (hiveDrivers == null) {
            return;
        }
        hiveDrivers.values().forEach(hiveDriver -> hiveDriver.unregister());
    }

    protected static interface DriverFactory {
        public Driver create(Driver var1, String var2, boolean var3, JdbcUrlParser var4);
    }
}

