/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.metadata.mqleditor.MqlDomain;
import org.pentaho.commons.metadata.mqleditor.beans.Domain;
import org.pentaho.commons.metadata.mqleditor.editor.MQLEditorService;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.ConditionsController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.MainController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.OrderController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.PreviewController;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.SelectedColumnController;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIDomain;
import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.commons.metadata.mqleditor.editor.service.MQLEditorServiceImpl;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.MQLEditorServiceDelegate;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;

public abstract class AbstractMqlEditor {
    protected static Log log = LogFactory.getLog(AbstractMqlEditor.class);
    protected MainController mainController = new MainController();
    protected SelectedColumnController selectedColumnController = new SelectedColumnController();
    protected ConditionsController constraintController = new ConditionsController();
    protected OrderController orderController = new OrderController();
    protected PreviewController previewController = new PreviewController();
    protected IMetadataDomainRepository repo;
    protected Workspace workspace = new Workspace();
    protected XulDomContainer container;
    protected XulLoader xulLoader;
    protected XulRunner xulRunner;
    protected MQLEditorServiceDelegate delegate;
    protected Window parentWindow;

    public AbstractMqlEditor(Window parent, IMetadataDomainRepository repo) {
        this.parentWindow = parent;
        this.init();
        this.setService(new MQLEditorServiceImpl(repo));
    }

    public AbstractMqlEditor(IMetadataDomainRepository repo, MQLEditorService service, MQLEditorServiceDelegate delegate) {
        this.init();
        this.repo = repo;
        this.setService(service);
        this.delegate = delegate;
    }

    public AbstractMqlEditor(IMetadataDomainRepository repo) {
        this.init();
        this.repo = repo;
        this.setService(new MQLEditorServiceImpl(repo));
        this.delegate = new MQLEditorServiceDelegate(repo);
    }

    private void setService(MQLEditorService service) {
        this.mainController.setService(service);
        this.previewController.setService(service);
        service.getMetadataDomains(new XulServiceCallback<List<MqlDomain>>(){

            public void error(String message, Throwable error) {
                log.error((Object)"Error loading Metadata Domain list", error);
            }

            public void success(List<MqlDomain> retVal) {
                ArrayList<UIDomain> uiDomains = new ArrayList<UIDomain>();
                for (MqlDomain d : retVal) {
                    uiDomains.add(new UIDomain((Domain)d));
                }
                AbstractMqlEditor.this.workspace.setDomains(uiDomains);
                try {
                    AbstractMqlEditor.this.xulRunner.initialize();
                }
                catch (XulException e) {
                    log.error((Object)"error starting Xul application", (Throwable)e);
                }
            }
        });
    }

    protected abstract XulLoader getLoader();

    protected abstract XulRunner getRunner();

    private void init() {
        try {
            XulLoader loader = this.getLoader();
            loader.setOuterContext((Object)this.parentWindow);
            this.container = loader.loadXul("org/pentaho/commons/metadata/mqleditor/editor/xul/mainFrame.xul");
            this.getRunner().addContainer(this.container);
            DefaultBindingFactory bf = new DefaultBindingFactory();
            bf.setDocument(this.container.getDocumentRoot());
            this.mainController.setBindingFactory((BindingFactory)bf);
            this.selectedColumnController.setBindingFactory((BindingFactory)bf);
            this.constraintController.setBindingFactory((BindingFactory)bf);
            this.orderController.setBindingFactory((BindingFactory)bf);
            this.previewController.setBindingFactory((BindingFactory)bf);
            this.container.addEventHandler((XulEventHandler)this.mainController);
            this.container.addEventHandler((XulEventHandler)this.selectedColumnController);
            this.container.addEventHandler((XulEventHandler)this.constraintController);
            this.container.addEventHandler((XulEventHandler)this.orderController);
            this.container.addEventHandler((XulEventHandler)this.previewController);
            this.mainController.setWorkspace(this.workspace);
            this.selectedColumnController.setWorkspace(this.workspace);
            this.constraintController.setWorkspace(this.workspace);
            this.orderController.setWorkspace(this.workspace);
            this.previewController.setWorkspace(this.workspace);
        }
        catch (XulException e) {
            log.error((Object)"error loading Xul application", (Throwable)e);
        }
    }

    public void show() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("mqlEditorDialog");
        dialog.show();
    }

    public void setQuery(String query) throws PentahoMetadataException {
        if (query == null) {
            this.mainController.clearWorkspace();
        } else {
            QueryXmlHelper helper = new QueryXmlHelper();
            Query queryObject = helper.fromXML(this.repo, query);
            org.pentaho.commons.metadata.mqleditor.beans.Query thinQuery = (org.pentaho.commons.metadata.mqleditor.beans.Query)this.delegate.convertModelToThin(queryObject);
            this.mainController.setSavedQuery(thinQuery);
        }
    }

    public boolean getOkClicked() {
        return this.mainController.getOkClicked();
    }

    public String getQuery() {
        return this.delegate.saveQuery(this.workspace.getMqlQuery());
    }

    public void hidePreview() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById("mqlEditorDialog");
        dialog.setButtons("accept,cancel");
    }

    public void addOverlay(XulOverlay overlay) throws XulException {
        this.container.loadOverlay(overlay.getOverlayUri());
    }
}

