/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class PmdDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/pmd-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/datasources/pmd", false);
        tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/datasources/pmd", "global-script", true);
        tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/datasources/pmd", "script", true);
        tagDescription.setElementHasCData("http://reporting.pentaho.org/namespaces/datasources/pmd", "static-query", true);
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/pmd");
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "pmd-datasource", rootAttrs, false);
        PmdDataFactory df = (PmdDataFactory)dataFactory;
        AttributeList configAttrs = new AttributeList();
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/pmd", "domain", String.valueOf(df.getDomainId()));
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/pmd", "xmi-file", String.valueOf(df.getXmiFile()));
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "config", configAttrs, true);
        String globalScript = df.getGlobalScript();
        String globalScriptLanguage = df.getGlobalScriptLanguage();
        if (!StringUtils.isEmpty((String)globalScript) && !StringUtils.isEmpty((String)globalScriptLanguage)) {
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "global-script", "language", globalScriptLanguage, false);
            xmlWriter.writeTextNormalized(globalScript, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "query-definitions", false);
        String[] queryNames = df.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = df.getQuery(queryName);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "query", "name", queryName, false);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "static-query", false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
            String queryScriptLanguage = df.getScriptingLanguage(queryName);
            String queryScript = df.getScript(queryName);
            if (!(StringUtils.isEmpty((String)queryScript) || StringUtils.isEmpty((String)queryScriptLanguage) && StringUtils.isEmpty((String)globalScriptLanguage))) {
                if (StringUtils.isEmpty((String)queryScriptLanguage)) {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "script", false);
                } else {
                    xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/pmd", "script", "language", queryScriptLanguage, false);
                }
                xmlWriter.writeTextNormalized(queryScript, false);
                xmlWriter.writeCloseTag();
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

