/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MDXMetaDataMemberAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.QueryResultWrapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.util.ResultSetProcessingLib;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;

public class DenormalizedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final Log logger = LogFactory.getLog(DenormalizedMDXTableModel.class);
    private final List<Member> columnToMemberMapping;
    private final CellSet resultSet;
    private int rowCount;
    private final int columnCount;
    private final List<String> columnNames;
    private final int[] axesSize;
    private final IntList columnToAxisPosition;
    private final QueryResultWrapper resultWrapper;

    @Deprecated
    public DenormalizedMDXTableModel(QueryResultWrapper resultSet) {
        this(resultSet, 0, false);
    }

    public DenormalizedMDXTableModel(QueryResultWrapper resultWrapper, int rowLimit, boolean membersOnAxisSorted) {
        ArgumentNullException.validate((String)"resultWrapper", (Object)resultWrapper);
        this.resultWrapper = resultWrapper;
        this.resultSet = resultWrapper.getCellSet();
        List axes = this.resultSet.getAxes();
        this.axesSize = ResultSetProcessingLib.computeItemsPerAxis(axes);
        this.rowCount = this.computeRowCount(this.axesSize);
        int[] axesMembers = ResultSetProcessingLib.computeTotalColumnsPerAxis(axes, 0, membersOnAxisSorted);
        this.columnCount = this.computeColumnCount(axesMembers);
        this.columnToAxisPosition = ResultSetProcessingLib.computeColumnToAxisMapping(axes, axesMembers, this.columnCount, 0);
        this.columnToMemberMapping = Collections.unmodifiableList(ResultSetProcessingLib.computeColumnToMemberMapping(axes, axesMembers, 0, membersOnAxisSorted));
        this.columnNames = this.computeColumnNames(this.columnToMemberMapping);
        if (rowLimit > 0) {
            this.rowCount = Math.min(rowLimit, this.rowCount);
        }
    }

    private List<String> computeColumnNames(List<Member> columnToMemberMapper) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Member member : columnToMemberMapper) {
            columnNames.add(member.getLevel().getUniqueName());
        }
        Member measureName = DenormalizedMDXTableModel.computeMeasureName(this.resultSet);
        if (measureName != null) {
            columnNames.add(measureName.getUniqueName());
        } else {
            columnNames.add("Measure");
        }
        return columnNames;
    }

    private int computeColumnCount(int[] axesMembers) {
        if (axesMembers.length == 0) {
            return 1;
        }
        boolean emptyAxisFound = false;
        int columnCount = 0;
        for (int i = 0; i < axesMembers.length; ++i) {
            columnCount += axesMembers[i];
            if (axesMembers[i] != 0) continue;
            emptyAxisFound = true;
        }
        if (!emptyAxisFound) {
            ++columnCount;
        }
        return columnCount;
    }

    private int computeRowCount(int[] axesSize) {
        int rowCount = 1;
        for (int i = 0; i < axesSize.length; ++i) {
            int size = axesSize[i];
            rowCount *= size;
        }
        return Math.max(1, rowCount);
    }

    private static Member computeMeasureName(CellSet resultSet) {
        List positionList = resultSet.getFilterAxis().getPositions();
        for (int i = 0; i < positionList.size(); ++i) {
            Position position = (Position)positionList.get(i);
            List members = position.getMembers();
            for (int positionIndex = 0; positionIndex < members.size(); ++positionIndex) {
                for (Member m = (Member)members.get(positionIndex); m != null; m = m.getParentMember()) {
                    if (m.getMemberType() != Member.Type.MEASURE) continue;
                    return m;
                }
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    public Class getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Member candidateMember;
        List<Integer> cellKey;
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            cellKey = this.computeCellKey(rowIndex);
            try {
                Cell cell = this.resultSet.getCell(cellKey);
                if (cell.isNull()) {
                    return null;
                }
                return cell.getValue();
            }
            catch (NullPointerException pe) {
                pe.printStackTrace();
            }
        }
        if ((candidateMember = this.getCandidateMembers(columnIndex, cellKey = this.computeCellKey(rowIndex))) != null) {
            return candidateMember.getName();
        }
        return null;
    }

    private boolean isMeasureColumn(int columnIndex) {
        return columnIndex >= this.columnToMemberMapping.size();
    }

    private List<Integer> computeCellKey(int rowIndex) {
        ArrayList<Integer> cellKey = new ArrayList<Integer>(this.axesSize.length);
        int tmpRowIdx = rowIndex;
        for (int i = 0; i < this.axesSize.length; ++i) {
            int axisSize = this.axesSize[i];
            if (axisSize == 0) {
                cellKey.add(0);
                continue;
            }
            int pos = tmpRowIdx % axisSize;
            cellKey.add(pos);
            tmpRowIdx /= axisSize;
        }
        return cellKey;
    }

    private Member getCandidateMembers(int columnIndex, List<Integer> cellKey) {
        int axisIndex = this.columnToAxisPosition.get(columnIndex);
        List axes = this.resultSet.getAxes();
        CellSetAxis axis = (CellSetAxis)axes.get(axisIndex);
        List positionList = axis.getPositions();
        if (positionList.isEmpty()) {
            return null;
        }
        int posIndex = cellKey.get(axisIndex);
        Position position = (Position)positionList.get(posIndex);
        Member memberByName = this.findMemberByName(position.getMembers(), columnIndex);
        if (memberByName != null) {
            return memberByName;
        }
        return this.findRootMember(position.getMembers(), columnIndex);
    }

    private Member findRootMember(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || member.getParentMember() != null) continue;
            return member;
        }
        return null;
    }

    private Member findMemberByName(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member match;
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || (match = this.searchContextMemberOfParents(member, columnIndex)) == null) continue;
            return match;
        }
        return null;
    }

    private Member searchContextMemberOfParents(Member member, int columnIndex) {
        String columnName = this.getColumnName(columnIndex);
        for (Member candidate = member; candidate != null; candidate = candidate.getParentMember()) {
            if (!candidate.getLevel().getUniqueName().equals(columnName)) continue;
            return candidate;
        }
        return null;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            PreparedOlapStatement statement = this.resultWrapper.getStatement();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            List<Integer> cellKey = this.computeCellKey(rowIndex);
            Cell cell = this.resultSet.getCell(cellKey);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        List<Integer> cellKey = this.computeCellKey(rowIndex);
        Member contextMember = this.getCandidateMembers(columnIndex, cellKey);
        if (contextMember != null) {
            return new MDXMetaDataMemberAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, contextMember);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        DefaultDataAttributes dataAttributes = new DefaultDataAttributes();
        dataAttributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", DefaultConceptQueryMapper.INSTANCE, (Object)"normalized");
        return dataAttributes;
    }
}

