/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.metadata.Member;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.QueryResultWrapper;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

public class LegacyBandedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private static final int AXIS_COLUMN = 0;
    private static final int AXIS_ROW = 1;
    private CellSet resultSet;
    private GenericObjectTable rowHeaders;
    private GenericObjectTable columnHeaders;
    private String[] columnNames;
    private int columnCount;
    private int rowCount;
    private boolean emptyAxisCase;
    private QueryResultWrapper resultWrapper;

    public LegacyBandedMDXTableModel(QueryResultWrapper resultWrapper, int queryLimitValue) throws ReportDataFactoryException {
        if (resultWrapper == null) {
            throw new NullPointerException("ResultSet returned was null");
        }
        this.resultWrapper = resultWrapper;
        this.resultSet = resultWrapper.getCellSet();
        int axisCount = this.resultSet.getAxes().size();
        if (axisCount > 2) {
            throw new ReportDataFactoryException("Cannot handle results with more than two axes.");
        }
        this.rowHeaders = this.createRowHeaders();
        this.columnHeaders = this.createColumnHeaders();
        this.columnCount = this.rowHeaders.getRowCount() > 0 ? this.rowHeaders.getColumnCount() + this.columnHeaders.getColumnCount() : this.columnHeaders.getColumnCount();
        if (this.columnCount == 0) {
            this.columnCount = 1;
            this.emptyAxisCase = true;
            this.columnNames = new String[]{"Measure"};
            this.rowCount = 1;
        } else {
            this.columnNames = new String[this.columnCount];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = this.calcColumnName(i);
            }
            this.rowCount = axisCount == 2 ? this.rowHeaders.getRowCount() : Math.max(1, this.rowHeaders.getRowCount());
        }
        if (queryLimitValue > 0) {
            this.rowCount = Math.min(queryLimitValue, this.rowCount);
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            PreparedOlapStatement statement = this.resultWrapper.getStatement();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String calcColumnName(int columnNumber) {
        if (columnNumber < this.rowHeaders.getColumnCount()) {
            return this.calcColumnNameFromRowHeader(columnNumber);
        }
        columnNumber -= this.rowHeaders.getColumnCount();
        StringBuffer buf = new StringBuffer(32);
        for (int i = 0; i < this.columnHeaders.getRowCount(); ++i) {
            Object o;
            if (i > 0 && buf.length() > 0) {
                buf.append('/');
            }
            if ((o = this.columnHeaders.getObject(i, columnNumber)) == null) continue;
            buf.append(String.valueOf(o));
        }
        return buf.toString();
    }

    private String calcColumnNameFromRowHeader(int columnNumber) {
        List axes = this.resultSet.getAxes();
        CellSetAxis axis = (CellSetAxis)axes.get(1);
        List positions = axis.getPositions();
        Position firstPosition = (Position)positions.get(0);
        List memberList = firstPosition.getMembers();
        if (columnNumber < memberList.size()) {
            Member member = (Member)memberList.get(columnNumber);
            return member.getHierarchy().getName();
        }
        Member member = (Member)memberList.get(memberList.size() - 1);
        return member.getHierarchy().getName() + '{' + columnNumber + '}';
    }

    private GenericObjectTable createColumnHeaders() {
        List axes = this.resultSet.getAxes();
        if (axes.size() < 1) {
            return new GenericObjectTable();
        }
        CellSetAxis axis = (CellSetAxis)axes.get(0);
        List positions = axis.getPositions();
        int colCount = positions.size();
        GenericObjectTable result = new GenericObjectTable(20, Math.max(1, colCount));
        for (int c = 0; c < colCount; ++c) {
            Position position = (Position)positions.get(c);
            List memberList = position.getMembers();
            Member member = null;
            int rowCount = memberList.size();
            for (int r = 0; r < rowCount; ++r) {
                member = (Member)memberList.get(r);
                if (member == null) continue;
                result.setObject(r, c, (Object)member.getName());
            }
            if (member == null) continue;
            result.setObject(rowCount, c, (Object)member.getHierarchy().getName());
        }
        return result;
    }

    private GenericObjectTable createRowHeaders() {
        List axes = this.resultSet.getAxes();
        if (axes.size() < 2) {
            return new GenericObjectTable();
        }
        CellSetAxis axis = (CellSetAxis)axes.get(1);
        List positions = axis.getPositions();
        int rowCount = positions.size();
        GenericObjectTable result = new GenericObjectTable(Math.max(1, rowCount), 5);
        for (int r = 0; r < rowCount; ++r) {
            Position position = (Position)positions.get(r);
            List members = position.getMembers();
            Member member = null;
            int colCount = members.size();
            for (int c = 0; c < colCount; ++c) {
                member = (Member)members.get(c);
                result.setObject(r, c, (Object)member.getName());
            }
            if (member == null) continue;
            result.setObject(r, colCount, (Object)member.getHierarchy().getName());
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.resultSet == null) {
            return null;
        }
        if (columnIndex < this.rowHeaders.getColumnCount()) {
            return this.rowHeaders.getObject(rowIndex, columnIndex);
        }
        if (this.emptyAxisCase) {
            Cell cell = this.resultSet.getCell(0);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        if (this.rowHeaders.getRowCount() == 0) {
            ArrayList<Integer> key = new ArrayList<Integer>(1);
            key.add(columnIndex);
            Cell cell = this.resultSet.getCell(key);
            if (cell.isNull()) {
                return null;
            }
            return cell.getValue();
        }
        ArrayList<Integer> key = new ArrayList<Integer>(2);
        key.add(columnIndex - this.rowHeaders.getColumnCount());
        key.add(rowIndex);
        Cell cell = this.resultSet.getCell(key);
        if (cell.isNull()) {
            return null;
        }
        return cell.getValue();
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (this.resultSet == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (columnIndex < this.rowHeaders.getColumnCount()) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (this.emptyAxisCase) {
            Cell cell = this.resultSet.getCell(0);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        if (this.rowHeaders.getRowCount() == 0) {
            ArrayList<Integer> key = new ArrayList<Integer>(1);
            key.add(columnIndex);
            Cell cell = this.resultSet.getCell(key);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        ArrayList<Integer> key = new ArrayList<Integer>(2);
        key.add(columnIndex - this.rowHeaders.getColumnCount());
        key.add(rowIndex);
        Cell c = this.resultSet.getCell(key);
        return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, c);
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        return EmptyDataAttributes.INSTANCE;
    }
}

