/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.DriverConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.JndiConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;

public class Olap4jDataFactoryCore
extends DefaultDataFactoryCore {
    private static final Log logger = LogFactory.getLog(Olap4jDataFactoryCore.class);

    public String getDisplayConnectionName(DataFactoryMetaData metaData, DataFactory dataFactory) {
        AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)dataFactory;
        OlapConnectionProvider connectionProvider = mdxDataFactory.getConnectionProvider();
        if (connectionProvider instanceof DriverConnectionProvider) {
            DriverConnectionProvider driverConnectionProvider = (DriverConnectionProvider)connectionProvider;
            return driverConnectionProvider.getProperty("::pentaho-reporting::name");
        }
        if (connectionProvider instanceof JndiConnectionProvider) {
            JndiConnectionProvider jndiConnectionProvider = (JndiConnectionProvider)connectionProvider;
            return jndiConnectionProvider.getConnectionPath();
        }
        return null;
    }

    public Object getQueryHash(DataFactoryMetaData dataFactoryMetaData, DataFactory dataFactory, String queryName, DataRow parameter) {
        try {
            AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)dataFactory;
            return mdxDataFactory.getQueryHash(queryName, parameter);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to create query hash", (Throwable)e);
            return null;
        }
    }

    public String[] getReferencedFields(DataFactoryMetaData metaData, DataFactory element, String query, DataRow parameter) {
        try {
            AbstractMDXDataFactory mdxDataFactory = (AbstractMDXDataFactory)element;
            return mdxDataFactory.getReferencedFields(query, parameter);
        }
        catch (ReportDataFactoryException e) {
            logger.warn((Object)"Unable to collect referenced fields", (Throwable)e);
            return null;
        }
    }
}

