/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.refinery.UIBuilder;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public abstract class JobEntryDialogBoilerplate<T extends JobEntryInterface>
extends JobEntryDialog
implements JobEntryDialogInterface {
    protected T jobEntry;
    protected Label wlName;
    protected Text wName;
    protected Label wIcon;
    private Label wTopSeparator;
    protected Button wOK;
    protected Button wCancel;
    protected Listener lsOK;
    protected Listener lsCancel;
    protected ModifyListener lsMod;
    protected SelectionAdapter lsDef;
    protected boolean changed;
    protected Class<?> PKG;
    protected static final int VAR_EXTRA_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;

    public JobEntryDialogBoilerplate(Shell parent, JobEntryInterface jobEntry, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntry, rep, jobMeta);
        this.jobEntry = jobEntry;
        this.PKG = ((Object)((Object)this)).getClass();
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, this.jobEntry);
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 10;
        formLayout.marginBottom = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getTitle());
        Composite topControl = this.hasEntryNameHeader() ? this.createJobNameHeader() : this.shell;
        Control bottomControl = this.createOkCancelButtons();
        Composite main = this.createMainComposite((Control)topControl, bottomControl);
        this.createControls(this.shell, (Control)topControl, bottomControl, main);
        this.createStandardListeners();
        this.loadData(this.jobEntry);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    protected boolean hasEntryNameHeader() {
        return true;
    }

    protected int getMinHeight(Composite shell) {
        shell.pack();
        int minHeight = shell.computeSize((int)435, (int)-1).y;
        return minHeight;
    }

    protected Composite createMainComposite(Control widgetAbove, Control widgetBelow) {
        Composite composite = UIBuilder.createFormComposite((Composite)this.shell);
        this.props.setLook((Control)composite);
        FormData fdComposite = new FormData();
        fdComposite.top = new FormAttachment(widgetAbove, 0);
        fdComposite.bottom = new FormAttachment(widgetBelow, 0);
        fdComposite.left = new FormAttachment(0);
        fdComposite.right = new FormAttachment(100);
        composite.setLayoutData((Object)fdComposite);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 15;
        composite.setLayout((Layout)layout);
        return composite;
    }

    protected abstract void createControls(Shell var1, Control var2, Control var3, Composite var4);

    protected Control createOkCancelButtons() {
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setAlignment(0x1000000);
        this.wCancel.setText(BaseMessages.getString(this.PKG, (String)"System.Button.Cancel", (String[])new String[0]) + "  ");
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100);
        fdCancel.bottom = new FormAttachment(100);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setAlignment(0x1000000);
        this.wOK.setText(BaseMessages.getString(this.PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOK = new FormData();
        fdOK.top = new FormAttachment((Control)this.wCancel, 0, 128);
        fdOK.right = new FormAttachment((Control)this.wCancel, -4, 16384);
        this.wOK.setLayoutData((Object)fdOK);
        Label wBottomHorizontalSeparator = new Label((Composite)this.shell, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(0);
        fdSeparator.right = new FormAttachment(100);
        fdSeparator.bottom = new FormAttachment((Control)this.wCancel, -15);
        wBottomHorizontalSeparator.setLayoutData((Object)fdSeparator);
        return wBottomHorizontalSeparator;
    }

    protected Composite createJobNameHeader() {
        Composite composite = UIBuilder.createFormComposite((Composite)this.shell);
        this.props.setLook((Control)composite);
        this.wlName = new Label(composite, 16384);
        this.wlName.setText(BaseMessages.getString(this.PKG, (String)"System.JobName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.wName = new Text(composite, 18436);
        this.props.setLook((Control)this.wName);
        this.addLabelInputPairBelow((Control)this.wlName, (Control)this.wName, (Control)composite, 250);
        this.wTopSeparator = new Label(composite, 258);
        FormData fdSeparator = new FormData();
        fdSeparator.top = new FormAttachment((Control)this.wName, 15);
        fdSeparator.left = new FormAttachment(0);
        fdSeparator.right = new FormAttachment(100);
        this.wTopSeparator.setLayoutData((Object)fdSeparator);
        this.createIconLabel(composite);
        return composite;
    }

    protected void createIconLabel(Composite parent) {
        if (StringUtils.isNotBlank((String)this.getJobIcon())) {
            this.wIcon = new Label(parent, 0x1000000);
            Image img = SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)this.getJobIcon(), (int)32, (int)32);
            this.wIcon.setImage(img);
            FormData fdIcon = new FormData();
            fdIcon.top = new FormAttachment(0, 5);
            fdIcon.right = new FormAttachment(100);
            this.wIcon.setLayoutData((Object)fdIcon);
            PropsUI.getInstance().setLook((Control)this.wIcon);
        }
    }

    protected abstract String getJobIcon();

    protected String getMsg(String messageKey) {
        return BaseMessages.getString(this.PKG, (String)messageKey, (String[])new String[0]);
    }

    private void createStandardListeners() {
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryDialogBoilerplate.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryDialogBoilerplate.this.cancel();
            }
        };
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                JobEntryDialogBoilerplate.this.jobEntry.setChanged();
            }
        };
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryDialogBoilerplate.this.ok();
            }
        };
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryDialogBoilerplate.this.cancel();
            }
        });
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        if (this.hasEntryNameHeader()) {
            this.wName.addSelectionListener((SelectionListener)this.lsDef);
            this.wName.addModifyListener(this.lsMod);
        }
    }

    protected Control addLabelInputPairBelow(Control label, Control input, Control widgetAbove) {
        this.addLabelBelow(label, widgetAbove);
        return this.addControlBelow(input, label);
    }

    protected Control addLabelInputPairBelow(Control label, Control input, Control widgetAbove, int fieldWidth) {
        this.addLabelBelow(label, widgetAbove);
        return this.addControlBelow(input, label, fieldWidth);
    }

    protected Control addLabelBelow(Control label, Control widgetAbove) {
        this.props.setLook(label);
        FormData fData = new FormData();
        int topMargin = label.getParent().equals(widgetAbove) ? 0 : 10;
        fData.top = new FormAttachment(widgetAbove, topMargin);
        fData.left = new FormAttachment(0);
        label.setLayoutData((Object)fData);
        return label;
    }

    protected Control addControlBelow(Control control, Control label) {
        return this.addControlBelow(control, label, -1);
    }

    protected Control addControlBelow(Control control, Control above, int controlWidth) {
        this.props.setLook(control);
        FormData fData = new FormData();
        int topMargin = control.getParent().equals(above) ? 0 : 5;
        fData.top = new FormAttachment(above, topMargin);
        fData.left = new FormAttachment(0);
        if (controlWidth > 0) {
            fData.width = controlWidth;
            fData.right = new FormAttachment(100, -this.getControlOffset(control, controlWidth));
        }
        control.setLayoutData((Object)fData);
        return control;
    }

    private int getControlOffset(Control control, int controlWidth) {
        return 435 - this.getMarginWidths(control) - controlWidth;
    }

    private int getMarginWidths(Control control) {
        int extraWidth = 0;
        Composite parent = control.getParent();
        while (!parent.equals(this.getParent())) {
            extraWidth += parent.computeTrim((int)0, (int)0, (int)0, (int)0).width;
            if (parent.getLayout() instanceof FormLayout) {
                extraWidth += 2 * ((FormLayout)parent.getLayout()).marginWidth;
            }
            parent = parent.getParent();
        }
        return extraWidth;
    }

    protected Group createGroup(Composite parent, Control widgetAbove, String groupText) {
        Group group = new Group(parent, 16);
        group.setText(groupText);
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginTop = -5;
        groupLayout.marginBottom = -5;
        groupLayout.marginWidth = 5;
        groupLayout.marginHeight = 15;
        group.setLayout((Layout)groupLayout);
        this.props.setLook((Control)group);
        FormData fData = new FormData();
        int topMargin = group.getParent().equals(widgetAbove) ? 0 : 10;
        fData.top = new FormAttachment(widgetAbove, topMargin);
        fData.left = new FormAttachment(0);
        fData.right = new FormAttachment(100);
        group.setLayoutData((Object)fData);
        return group;
    }

    protected Control addLoneControlBelow(Control control, Control widgetAbove) {
        this.props.setLook(control);
        FormData fData = new FormData();
        int topMargin = control.getParent().equals(widgetAbove) ? 0 : 10;
        fData.top = new FormAttachment(widgetAbove, topMargin);
        fData.left = new FormAttachment(0);
        control.setLayoutData((Object)fData);
        return control;
    }

    protected Control addLoneControlBelow(Control control, Control widgetAbove, int width) {
        this.props.setLook(control);
        FormData fData = new FormData();
        fData.top = new FormAttachment(widgetAbove, 4);
        fData.width = width;
        control.pack(false);
        control.setLayoutData((Object)fData);
        return control;
    }

    protected void setControlWidth(Control control, int width) {
        Point size = control.getSize();
        size.x = width;
        control.setSize(size);
    }

    protected void ok() {
        if (!this.okToClose()) {
            return;
        }
        this.saveData(this.jobEntry);
        this.dispose();
    }

    protected boolean okToClose() {
        if (this.hasEntryNameHeader() && Const.isEmpty((String)this.wName.getText())) {
            this.showError(this.getMsg("System.StepJobEntryNameMissing.Title"), this.getMsg("System.JobEntryNameMissing.Msg"));
            return false;
        }
        return true;
    }

    protected void showError(String title, String msg) {
        MessageBox mb = new MessageBox(this.shell, 33);
        mb.setText(title);
        mb.setMessage(msg);
        mb.open();
    }

    protected void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    protected abstract String getTitle();

    protected void loadData(T jobEntry) {
        if (this.hasEntryNameHeader() && jobEntry.getName() != null) {
            this.wName.setText(jobEntry.getName());
        }
    }

    protected void saveData(T jobEntry) {
        if (this.hasEntryNameHeader()) {
            jobEntry.setName(this.wName.getText());
        }
    }
}

