/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.common;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.pentaho.di.core.refinery.UIBuilder;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.TextVar;

public class ServerConnectionGroupWrapper {
    private Class<?> msgClass;
    private Composite main;
    private TextVar wPublishUrl;
    private Label wlPublishUrl;
    private TextVar wPublishUser;
    private Label wlPublishUser;
    private TextVar wPublishPassword;
    private Label wlPublishPassword;
    private Button bSubmit;
    private PropsUI props;
    private JobMeta jobMeta;
    private JobEntryInterface jobEntry;
    private ModifyListener modifyListener;
    private Group group;

    public ServerConnectionGroupWrapper(Composite main, PropsUI props, JobMeta jobMeta, JobEntryInterface jobEntry, Class<?> msgClass) {
        this.msgClass = msgClass;
        this.main = main;
        this.props = props;
        this.jobMeta = jobMeta;
        this.jobEntry = jobEntry;
        this.init();
    }

    private void init() {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerConnectionGroupWrapper.this.jobEntry.setChanged();
            }
        };
        this.group = this.createServerGroup();
    }

    private Group createServerGroup() {
        Group group = UIBuilder.createFormGroup(this.main);
        group.setText(this.getMsg("ServerConnection.Group.Label"));
        this.props.setLook((Control)group);
        this.wlPublishUrl = new Label((Composite)group, 16384);
        this.wlPublishUrl.setText(this.getMsg("ServerConnection.Url.Label"));
        this.wlPublishUrl.setToolTipText(this.getMsg("ServerConnection.Url.Tooltip"));
        this.wPublishUrl = new TextVar((VariableSpace)this.jobMeta, (Composite)group, 2048);
        this.wPublishUrl.addModifyListener(this.modifyListener);
        this.wPublishUrl.setToolTipText(this.getMsg("ServerConnection.Url.Tooltip"));
        this.props.setLook((Control)this.wlPublishUrl);
        this.props.setLook((Control)this.wPublishUrl);
        this.wlPublishUser = new Label((Composite)group, 16384);
        this.wlPublishUser.setText(this.getMsg("ServerConnection.User.Label"));
        this.wlPublishUser.setToolTipText(this.getMsg("ServerConnection.User.Tooltip"));
        this.wPublishUser = new TextVar((VariableSpace)this.jobMeta, (Composite)group, 2048);
        this.wPublishUser.addModifyListener(this.modifyListener);
        this.wPublishUser.setToolTipText(this.getMsg("ServerConnection.User.Tooltip"));
        this.props.setLook((Control)this.wlPublishUser);
        this.props.setLook((Control)this.wPublishUser);
        this.wlPublishPassword = new Label((Composite)group, 16384);
        this.wlPublishPassword.setText(this.getMsg("ServerConnection.Password.Label"));
        this.wPublishPassword = new TextVar((VariableSpace)this.jobMeta, (Composite)group, 0x400800);
        this.wPublishPassword.addModifyListener(this.modifyListener);
        this.props.setLook((Control)this.wlPublishPassword);
        this.props.setLook((Control)this.wPublishPassword);
        this.bSubmit = new Button((Composite)group, 0x1000008);
        this.bSubmit.setText(" " + this.getMsg("ServerConnection.Submit.Label") + " ");
        this.bSubmit.setToolTipText(this.getMsg("ServerConnection.Submit.Description"));
        this.props.setLook((Control)this.bSubmit);
        this.positionServerGroup(group);
        return group;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setSubmitButtonText(String txt) {
        this.bSubmit.setText(txt);
    }

    public void setSubmitButtonTooltip(String txt) {
        this.bSubmit.setToolTipText(txt);
    }

    public void addSubmitButtonListener(Listener listener) {
        if (listener != null) {
            this.bSubmit.addListener(13, listener);
        }
    }

    public void setBiServerConnection(BiServerConnection biserverConnection) {
        this.wPublishUrl.setText(biserverConnection.getUrl());
        this.wPublishUser.setText(biserverConnection.getUserId());
        this.wPublishPassword.setText(biserverConnection.getPassword());
    }

    public BiServerConnection getBiServerConnection(boolean resolveVariables) {
        BiServerConnection biServerModel = new BiServerConnection();
        if (resolveVariables) {
            String url = this.jobMeta.environmentSubstitute(this.wPublishUrl.getText());
            if (StringUtils.endsWith((String)url, (String)"//")) {
                url = StringUtils.chop((String)url);
            }
            biServerModel.setUrl(url);
            biServerModel.setUserId(this.jobMeta.environmentSubstitute(this.wPublishUser.getText()));
            biServerModel.setPassword(this.jobMeta.environmentSubstitute(this.wPublishPassword.getText()));
        } else {
            biServerModel.setUrl(this.wPublishUrl.getText());
            biServerModel.setUserId(this.wPublishUser.getText());
            biServerModel.setPassword(this.wPublishPassword.getText());
        }
        return biServerModel;
    }

    private void positionServerGroup(Group group) {
        UIBuilder.positionLabelInputPairBelow(this.wlPublishUrl, (Control)this.wPublishUrl, null, 0, 7);
        ((FormData)this.wPublishUrl.getLayoutData()).width = 350;
        UIBuilder.positionLabelInputPairBelow(this.wlPublishUser, (Control)this.wPublishUser, (Control)this.wPublishUrl, 10, 7);
        ((FormData)this.wPublishUser.getLayoutData()).width = 250;
        UIBuilder.positionLabelInputPairBelow(this.wlPublishPassword, (Control)this.wPublishPassword, (Control)this.wPublishUser, 10, 7);
        ((FormData)this.wPublishPassword.getLayoutData()).width = 250;
        UIBuilder.positionControlBelow((Control)this.bSubmit, (Control)this.wPublishPassword, 15, 7);
    }

    protected String getMsg(String messageKey) {
        return BaseMessages.getString(this.msgClass, (String)messageKey, (String[])new String[0]);
    }
}

